/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers;

import java.util.Objects;
import org.ehcache.Cache;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.RequiredContext;

@RequiredContext(value={@Named(value="instanceId"), @Named(value="cacheManagerName"), @Named(value="cacheName")})
public final class CacheBinding {
    private final String alias;
    private final Cache<?, ?> cache;

    public CacheBinding(String alias, Cache<?, ?> cache) {
        this.alias = Objects.requireNonNull(alias);
        this.cache = Objects.requireNonNull(cache);
    }

    public String getAlias() {
        return this.alias;
    }

    public <K, V> Cache<K, V> getCache() {
        return this.cache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheBinding that = (CacheBinding)o;
        return this.alias.equals(that.alias) && this.cache.equals(that.cache);
    }

    public int hashCode() {
        int result = this.alias.hashCode();
        result = 31 * result + this.cache.hashCode();
        return result;
    }

    public String toString() {
        return this.alias;
    }
}

