/*
 * Decompiled with CFR 0.152.
 */
package org.eu.ingwar.tools.arquillian.extension.deployment;

import java.io.ByteArrayOutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EarDescriptorBuilder {
    private final String basename;
    private final List<String> ejbs = new ArrayList<String>();
    private final List<Map.Entry<String, String>> webs = new ArrayList<Map.Entry<String, String>>();
    private Document doc;
    private Element rootElement;
    private boolean addRandom = true;

    public EarDescriptorBuilder(String basename) {
        this.basename = basename;
    }

    public EarDescriptorBuilder addEjb(String filename) {
        this.ejbs.add(filename);
        return this;
    }

    public EarDescriptorBuilder addWeb(String filename, String context) {
        AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(filename, context);
        this.webs.add(entry);
        return this;
    }

    public EarDescriptorBuilder addWeb(String filename) {
        String context = this.removeExtension(filename).replaceAll("[^a-z]", "");
        if (this.addRandom) {
            Random random = new Random();
            context = context + "-" + random.nextInt(Integer.MAX_VALUE);
        }
        return this.addWeb(filename, context);
    }

    public void setAddRandom(boolean addRandom) {
        this.addRandom = addRandom;
    }

    private String removeExtension(String filename) {
        return filename.replaceAll("\\.[a-z]{2,}$", "");
    }

    public String render() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            this.rootElement = this.doc.createElement("application");
            this.rootElement.setAttribute("xmlns", "http://java.sun.com/xml/ns/javaee");
            this.rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.rootElement.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_6.xsd");
            this.rootElement.setAttribute("version", "6");
            this.doc.appendChild(this.rootElement);
            Element element = this.doc.createElement("description");
            element.setTextContent("Autogenerated deployment for " + this.basename);
            this.rootElement.appendChild(element);
            element = this.doc.createElement("display-name");
            element.setTextContent(this.basename + "-full");
            this.rootElement.appendChild(element);
            for (String string : this.ejbs) {
                this.writeEjbModule(string);
            }
            for (Map.Entry entry : this.webs) {
                this.writeWebModule((String)entry.getKey(), (String)entry.getValue());
            }
            element = this.doc.createElement("library-directory");
            element.setTextContent("lib");
            this.rootElement.appendChild(element);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bytes);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, result);
            return bytes.toString();
        }
        catch (TransformerException ex) {
            throw new IllegalStateException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void writeWebModule(String filename, String context) {
        Element element = this.writeModule();
        Element web = this.doc.createElement("web");
        element.appendChild(web);
        Element webUri = this.doc.createElement("web-uri");
        Element contextRoot = this.doc.createElement("context-root");
        web.appendChild(webUri);
        web.appendChild(contextRoot);
        webUri.setTextContent(filename);
        contextRoot.setTextContent(context);
    }

    private void writeEjbModule(String filename) {
        Element element = this.writeModule();
        Element ejb = this.doc.createElement("ejb");
        element.appendChild(ejb);
        ejb.setTextContent(filename);
    }

    private Element writeModule() {
        Element element = this.doc.createElement("module");
        this.rootElement.appendChild(element);
        return element;
    }

    boolean containsWar() {
        return !this.webs.isEmpty();
    }
}

