/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import java.util.Map;

public abstract class BasicElementImpl
implements ElementImpl {
    private ObjectFile.Element element;

    public BasicElementImpl(ObjectFile.Element element) {
        this.element = element;
    }

    public BasicElementImpl() {
    }

    @Override
    public void setElement(ObjectFile.Element element) {
        assert (element != null);
        assert (this.element == null || this.element == element);
        this.element = element;
    }

    public ObjectFile getOwner() {
        return this.element.getOwner();
    }

    @Override
    public ObjectFile.Element getElement() {
        assert (this.element != null);
        return this.element;
    }

    @Override
    public int getAlignment() {
        return this.element.getAlignment();
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        return ObjectFile.defaultDependencies(decisions, this.element);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return ObjectFile.defaultDecisions(this.element, copyingIn);
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        return ObjectFile.defaultGetOrDecideOffset(alreadyDecided, this.element, offsetHint);
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return ObjectFile.defaultGetOrDecideSize(alreadyDecided, this.element, sizeHint);
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this.element, vaddrHint);
    }

    @Override
    public int getMemSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
        return (Integer)alreadyDecided.get(this.element).getDecidedValue(LayoutDecision.Kind.SIZE);
    }

    @Override
    public boolean isReferenceable() {
        return this.isLoadable();
    }
}

