// CheckStyle: start generated
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawReadValueNode;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawReadValueNodeGen;
import com.oracle.truffle.api.strings.TruffleStringIterator.NextNode;
import com.oracle.truffle.api.strings.TruffleStringIterator.PreviousNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(TruffleStringIterator.class)
public final class TruffleStringIteratorFactory {

    @GeneratedBy(NextNode.class)
    static final class NextNodeGen extends NextNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawReadValueNode fixed_readNode_;
        @Child private RawReadValueNode fixedValid_readNode_;
        @Child private RawReadValueNode brokenAscii_readNode_;
        @Child private RawReadValueNode brokenUTF32_readNode_;

        private NextNodeGen() {
        }

        @Override
        int executeInternal(TruffleStringIterator arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 fixed(TruffleStringIterator, RawReadValueNode) || fixedValid(TruffleStringIterator, RawReadValueNode) || brokenAscii(TruffleStringIterator, RawReadValueNode) || brokenUTF32(TruffleStringIterator, RawReadValueNode) || utf8Valid(TruffleStringIterator) || utf8Broken(TruffleStringIterator) || utf16Valid(TruffleStringIterator) || utf16Broken(TruffleStringIterator) || unsupported(TruffleStringIterator) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 fixed(TruffleStringIterator, RawReadValueNode) */) {
                    if ((TStringGuards.isFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isBestEffort(arg0Value.errorHandling))) {
                        return NextNode.fixed(arg0Value, this.fixed_readNode_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 fixedValid(TruffleStringIterator, RawReadValueNode) */) {
                    if ((TStringGuards.isUpToValidFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                        return NextNode.fixedValid(arg0Value, this.fixedValid_readNode_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 brokenAscii(TruffleStringIterator, RawReadValueNode) */) {
                    if ((TStringGuards.isAscii(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                        return NextNode.brokenAscii(arg0Value, this.brokenAscii_readNode_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 brokenUTF32(TruffleStringIterator, RawReadValueNode) */) {
                    if ((TStringGuards.isUTF32(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                        return NextNode.brokenUTF32(arg0Value, this.brokenUTF32_readNode_);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 utf8Valid(TruffleStringIterator) */) {
                    if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                        return NextNode.utf8Valid(arg0Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 utf8Broken(TruffleStringIterator) */) {
                    if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                        return NextNode.utf8Broken(arg0Value);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is-state_0 utf16Valid(TruffleStringIterator) */) {
                    if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                        return NextNode.utf16Valid(arg0Value);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is-state_0 utf16Broken(TruffleStringIterator) */) {
                    if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                        return NextNode.utf16Broken(arg0Value);
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is-state_0 unsupported(TruffleStringIterator) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg0Value.encoding))) {
                        return NextNode.unsupported(arg0Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private int executeAndSpecialize(TruffleStringIterator arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isBestEffort(arg0Value.errorHandling))) {
                    this.fixed_readNode_ = super.insert((RawReadValueNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 fixed(TruffleStringIterator, RawReadValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return NextNode.fixed(arg0Value, this.fixed_readNode_);
                }
                if ((TStringGuards.isUpToValidFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    this.fixedValid_readNode_ = super.insert((RawReadValueNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 fixedValid(TruffleStringIterator, RawReadValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return NextNode.fixedValid(arg0Value, this.fixedValid_readNode_);
                }
                if ((TStringGuards.isAscii(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    this.brokenAscii_readNode_ = super.insert((RawReadValueNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 brokenAscii(TruffleStringIterator, RawReadValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return NextNode.brokenAscii(arg0Value, this.brokenAscii_readNode_);
                }
                if ((TStringGuards.isUTF32(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    this.brokenUTF32_readNode_ = super.insert((RawReadValueNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 brokenUTF32(TruffleStringIterator, RawReadValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return NextNode.brokenUTF32(arg0Value, this.brokenUTF32_readNode_);
                }
                if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 utf8Valid(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return NextNode.utf8Valid(arg0Value);
                }
                if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 utf8Broken(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return NextNode.utf8Broken(arg0Value);
                }
                if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                    this.state_0_ = state_0 = state_0 | 0b1000000 /* add-state_0 utf16Valid(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return NextNode.utf16Valid(arg0Value);
                }
                if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                    this.state_0_ = state_0 = state_0 | 0b10000000 /* add-state_0 utf16Broken(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return NextNode.utf16Broken(arg0Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg0Value.encoding))) {
                    this.state_0_ = state_0 = state_0 | 0b100000000 /* add-state_0 unsupported(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return NextNode.unsupported(arg0Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static NextNode create() {
            return new NextNodeGen();
        }

        public static NextNode getUncached() {
            return NextNodeGen.UNCACHED;
        }

        @GeneratedBy(NextNode.class)
        @DenyReplace
        private static final class Uncached extends NextNode {

            @TruffleBoundary
            @Override
            int executeInternal(TruffleStringIterator arg0Value) {
                if ((TStringGuards.isFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isBestEffort(arg0Value.errorHandling))) {
                    return NextNode.fixed(arg0Value, (RawReadValueNodeGen.getUncached()));
                }
                if ((TStringGuards.isUpToValidFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    return NextNode.fixedValid(arg0Value, (RawReadValueNodeGen.getUncached()));
                }
                if ((TStringGuards.isAscii(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    return NextNode.brokenAscii(arg0Value, (RawReadValueNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    return NextNode.brokenUTF32(arg0Value, (RawReadValueNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                    return NextNode.utf8Valid(arg0Value);
                }
                if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                    return NextNode.utf8Broken(arg0Value);
                }
                if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                    return NextNode.utf16Valid(arg0Value);
                }
                if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                    return NextNode.utf16Broken(arg0Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg0Value.encoding))) {
                    return NextNode.unsupported(arg0Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(PreviousNode.class)
    static final class PreviousNodeGen extends PreviousNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RawReadValueNode fixed_readNode_;
        @Child private RawReadValueNode fixedValid_readNode_;
        @Child private RawReadValueNode brokenAscii_readNode_;
        @Child private RawReadValueNode brokenUTF32_readNode_;

        private PreviousNodeGen() {
        }

        @Override
        int executeInternal(TruffleStringIterator arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 fixed(TruffleStringIterator, RawReadValueNode) || fixedValid(TruffleStringIterator, RawReadValueNode) || brokenAscii(TruffleStringIterator, RawReadValueNode) || brokenUTF32(TruffleStringIterator, RawReadValueNode) || utf8Valid(TruffleStringIterator) || utf8Broken(TruffleStringIterator) || utf16Valid(TruffleStringIterator) || utf16Broken(TruffleStringIterator) || unsupported(TruffleStringIterator) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 fixed(TruffleStringIterator, RawReadValueNode) */) {
                    if ((TStringGuards.isFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isBestEffort(arg0Value.errorHandling))) {
                        return PreviousNode.fixed(arg0Value, this.fixed_readNode_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 fixedValid(TruffleStringIterator, RawReadValueNode) */) {
                    if ((TStringGuards.isUpToValidFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                        return PreviousNode.fixedValid(arg0Value, this.fixedValid_readNode_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 brokenAscii(TruffleStringIterator, RawReadValueNode) */) {
                    if ((TStringGuards.isAscii(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                        return PreviousNode.brokenAscii(arg0Value, this.brokenAscii_readNode_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 brokenUTF32(TruffleStringIterator, RawReadValueNode) */) {
                    if ((TStringGuards.isUTF32(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                        return PreviousNode.brokenUTF32(arg0Value, this.brokenUTF32_readNode_);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 utf8Valid(TruffleStringIterator) */) {
                    if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                        return PreviousNode.utf8Valid(arg0Value);
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 utf8Broken(TruffleStringIterator) */) {
                    if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                        return PreviousNode.utf8Broken(arg0Value);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is-state_0 utf16Valid(TruffleStringIterator) */) {
                    if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                        return PreviousNode.utf16Valid(arg0Value);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is-state_0 utf16Broken(TruffleStringIterator) */) {
                    if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                        return PreviousNode.utf16Broken(arg0Value);
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is-state_0 unsupported(TruffleStringIterator) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg0Value.encoding))) {
                        return PreviousNode.unsupported(arg0Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private int executeAndSpecialize(TruffleStringIterator arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.isFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isBestEffort(arg0Value.errorHandling))) {
                    this.fixed_readNode_ = super.insert((RawReadValueNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 fixed(TruffleStringIterator, RawReadValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return PreviousNode.fixed(arg0Value, this.fixed_readNode_);
                }
                if ((TStringGuards.isUpToValidFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    this.fixedValid_readNode_ = super.insert((RawReadValueNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 fixedValid(TruffleStringIterator, RawReadValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return PreviousNode.fixedValid(arg0Value, this.fixedValid_readNode_);
                }
                if ((TStringGuards.isAscii(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    this.brokenAscii_readNode_ = super.insert((RawReadValueNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 brokenAscii(TruffleStringIterator, RawReadValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return PreviousNode.brokenAscii(arg0Value, this.brokenAscii_readNode_);
                }
                if ((TStringGuards.isUTF32(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    this.brokenUTF32_readNode_ = super.insert((RawReadValueNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 brokenUTF32(TruffleStringIterator, RawReadValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return PreviousNode.brokenUTF32(arg0Value, this.brokenUTF32_readNode_);
                }
                if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 utf8Valid(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return PreviousNode.utf8Valid(arg0Value);
                }
                if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 utf8Broken(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return PreviousNode.utf8Broken(arg0Value);
                }
                if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                    this.state_0_ = state_0 = state_0 | 0b1000000 /* add-state_0 utf16Valid(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return PreviousNode.utf16Valid(arg0Value);
                }
                if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                    this.state_0_ = state_0 = state_0 | 0b10000000 /* add-state_0 utf16Broken(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return PreviousNode.utf16Broken(arg0Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg0Value.encoding))) {
                    this.state_0_ = state_0 = state_0 | 0b100000000 /* add-state_0 unsupported(TruffleStringIterator) */;
                    lock.unlock();
                    hasLock = false;
                    return PreviousNode.unsupported(arg0Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static PreviousNode create() {
            return new PreviousNodeGen();
        }

        public static PreviousNode getUncached() {
            return PreviousNodeGen.UNCACHED;
        }

        @GeneratedBy(PreviousNode.class)
        @DenyReplace
        private static final class Uncached extends PreviousNode {

            @TruffleBoundary
            @Override
            int executeInternal(TruffleStringIterator arg0Value) {
                if ((TStringGuards.isFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isBestEffort(arg0Value.errorHandling))) {
                    return PreviousNode.fixed(arg0Value, (RawReadValueNodeGen.getUncached()));
                }
                if ((TStringGuards.isUpToValidFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    return PreviousNode.fixedValid(arg0Value, (RawReadValueNodeGen.getUncached()));
                }
                if ((TStringGuards.isAscii(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    return PreviousNode.brokenAscii(arg0Value, (RawReadValueNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg0Value.encoding)) && (TStringGuards.isBrokenFixedWidth(arg0Value.codeRangeA)) && (TStringGuards.isReturnNegative(arg0Value.errorHandling))) {
                    return PreviousNode.brokenUTF32(arg0Value, (RawReadValueNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                    return PreviousNode.utf8Valid(arg0Value);
                }
                if ((TStringGuards.isUTF8(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                    return PreviousNode.utf8Broken(arg0Value);
                }
                if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isValidMultiByte(arg0Value.codeRangeA))) {
                    return PreviousNode.utf16Valid(arg0Value);
                }
                if ((TStringGuards.isUTF16(arg0Value.encoding)) && (TStringGuards.isBrokenMultiByteOrUnknown(arg0Value.codeRangeA))) {
                    return PreviousNode.utf16Broken(arg0Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg0Value.encoding))) {
                    return PreviousNode.unsupported(arg0Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
