package org.jboss.weld.environment.servlet.logging;

import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-01-12T17:33:09+0100")
public class TomcatLogger_$logger extends DelegatingBasicLogger implements TomcatLogger, WeldEnvironmentLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = TomcatLogger_$logger.class.getName();
    public TomcatLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void allInjectionsAvailable() {
        super.log.logf(FQCN, INFO, null, allInjectionsAvailable$str());
    }
    protected String allInjectionsAvailable$str() {
        return "WELD-ENV-001100: Tomcat 7+ detected, CDI injection will be available in Servlets, Filters and Listeners.";
    }
    @Override
    public final void listenersInjectionsNotAvailable() {
        super.log.logf(FQCN, INFO, null, listenersInjectionsNotAvailable$str());
    }
    protected String listenersInjectionsNotAvailable$str() {
        return "WELD-ENV-001101: Tomcat 7+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported.";
    }
    @Override
    public final void unableToReplaceTomcat(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, unableToReplaceTomcat$str());
    }
    protected String unableToReplaceTomcat$str() {
        return "WELD-ENV-001102: Unable to replace Tomcat 7 AnnotationProcessor. CDI injection will not be available in Servlets, Filters, or Listeners.";
    }
    protected String cannotCreatWeldForwardingAnnotationProcessor$str() {
        return "WELD-ENV-001103: Cannot create WeldForwardingAnnotationProcessor.";
    }
    @Override
    public final RuntimeException cannotCreatWeldForwardingAnnotationProcessor(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotCreatWeldForwardingAnnotationProcessor$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String cannotGetStandardContext$str() {
        return "WELD-ENV-001104: Cannot get StandardContext from ServletContext.";
    }
    @Override
    public final RuntimeException cannotGetStandardContext(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotGetStandardContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String neitherFieldNorGetterSetterFound$str() {
        return "WELD-ENV-001105: Neither field nor getter/setter found for instanceManager on {0}";
    }
    @Override
    public final RuntimeException neitherFieldNorGetterSetterFound(final Class<?> standardContextClass) {
        final RuntimeException result = new RuntimeException(_formatMessage(neitherFieldNorGetterSetterFound$str(), standardContextClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String errorInvokingMethod$str() {
        return "WELD-ENV-001106: Exception invoking method {0} on object {1}, using arguments {2}";
    }
    @Override
    public final RuntimeException errorInvokingMethod(final String method, final Object obj, final Object... args) {
        final RuntimeException result = new RuntimeException(_formatMessage(errorInvokingMethod$str(), method, obj, Arrays.toString(args)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorReadingField$str() {
        return "WELD-ENV-001107: Exception reading field {0} on object {1}";
    }
    @Override
    public final RuntimeException errorReadingField(final String field, final Object obj) {
        final RuntimeException result = new RuntimeException(_formatMessage(errorReadingField$str(), field, obj));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorWritingField$str() {
        return "WELD-ENV-001108: Exception writing field {0} on object {1}, new value: {2}";
    }
    @Override
    public final RuntimeException errorWritingField(final String field, final Object obj, final Object value) {
        final RuntimeException result = new RuntimeException(_formatMessage(errorWritingField$str(), field, obj, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable arg0) {
        super.log.logf(FQCN, DEBUG, arg0, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
    @Override
    public final void catchingTrace(final Throwable arg0) {
        super.log.logf(FQCN, TRACE, arg0, catchingTrace$str());
    }
    protected String catchingTrace$str() {
        return "Catching";
    }
}
