package org.jboss.weld.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;
import javax.enterprise.inject.spi.ObserverMethod;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-02-15T14:41:51+0100")
public class EventLogger_$logger extends DelegatingBasicLogger implements EventLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EventLogger_$logger.class.getName();
    public EventLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void asyncFire(final Object param1, final Object param2) {
        super.log.logv(FQCN, DEBUG, null, asyncFire$str(), param1, param2);
    }
    protected String asyncFire$str() {
        return "WELD-000400: Sending event {0} directly to observer {1}";
    }
    @Override
    public final void asyncObserverFailure(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, ERROR, null, asyncObserverFailure$str(), param1, param2, param3);
    }
    protected String asyncObserverFailure$str() {
        return "WELD-000401: Failure while notifying an observer {0} of event {1}.\n {2}";
    }
    protected String serializationProxyRequired$str() {
        return "WELD-000403: Proxy required";
    }
    @Override
    public final InvalidObjectException serializationProxyRequired() {
        final InvalidObjectException result = new InvalidObjectException(String.format(getLoggingLocale(), serializationProxyRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidScopedConditionalObserver$str() {
        return "WELD-000404: Conditional observer method cannot be declared by a @Dependent scoped bean: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException invalidScopedConditionalObserver(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidScopedConditionalObserver$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String multipleEventParameters$str() {
        return "WELD-000405: Observer method cannot have more than one event parameter annotated with @Observes or @ObservesAsync: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException multipleEventParameters(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(multipleEventParameters$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDisposesParameter$str() {
        return "WELD-000406: Observer method cannot have a parameter annotated with @Disposes: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException invalidDisposesParameter(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidDisposesParameter$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidProducer$str() {
        return "WELD-000407: Observer method cannot be annotated with @Produces: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException invalidProducer(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidProducer$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInitializer$str() {
        return "WELD-000408: Observer method cannot be annotated with @Inject, observer methods are automatically injection points: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException invalidInitializer(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidInitializer$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInjectionPoint$str() {
        return "WELD-000409: Observer method for container lifecycle event can only inject BeanManager: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException invalidInjectionPoint(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidInjectionPoint$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidWithAnnotations$str() {
        return "WELD-000410: Observer method cannot define @WithAnnotations: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException invalidWithAnnotations(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidWithAnnotations$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unrestrictedProcessAnnotatedTypes(final Object param1) {
        super.log.logv(FQCN, INFO, null, unrestrictedProcessAnnotatedTypes$str(), param1);
    }
    protected String unrestrictedProcessAnnotatedTypes$str() {
        return "WELD-000411: Observer method {0} receives events for all annotated types. Consider restricting events using @WithAnnotations or a generic type with bounds.";
    }
    protected String observerMethodsMethodReturnsNull$str() {
        return "WELD-000412: ObserverMethod.{0}() returned null for {1}";
    }
    @Override
    public final DefinitionException observerMethodsMethodReturnsNull(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(observerMethodsMethodReturnsNull$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanClassMismatch$str() {
        return "WELD-000413: {0} cannot be replaced by an observer method with a different bean class {1}";
    }
    @Override
    public final DefinitionException beanClassMismatch(final ObserverMethod<?> originalObserverMethod, final ObserverMethod<?> observerMethod) {
        final DefinitionException result = new DefinitionException(_formatMessage(beanClassMismatch$str(), originalObserverMethod, observerMethod));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asyncContainerLifecycleEventObserver$str() {
        return "WELD-000414: Observer method for container lifecycle event cannot be asynchronous. {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException asyncContainerLifecycleEventObserver(final ObserverMethod<?> observer, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(asyncContainerLifecycleEventObserver$str(), observer, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notifyMethodNotImplemented$str() {
        return "WELD-000415: Custom implementation of observer method does not override either notify(T) or notify(EventContext<T>): {0}";
    }
    @Override
    public final DefinitionException notifyMethodNotImplemented(final Object observer) {
        final DefinitionException result = new DefinitionException(_formatMessage(notifyMethodNotImplemented$str(), observer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noneOrMultipleEventParametersDeclared$str() {
        return "WELD-000416: None or multiple event parameters declared on: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final IllegalArgumentException noneOrMultipleEventParametersDeclared(final Object method, final Object stackElement) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(noneOrMultipleEventParametersDeclared$str(), method, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void originalObservedTypeIsNotAssignableFrom(final Object originalObservedType, final Object observedType, final Object extension) {
        super.log.logv(FQCN, WARN, null, originalObservedTypeIsNotAssignableFrom$str(), originalObservedType, observedType, extension);
    }
    protected String originalObservedTypeIsNotAssignableFrom$str() {
        return "WELD-000417: The original observed type {0} is not assignable from {1} set by extension {2} - the observer method invocation may result in runtime exception!";
    }
    protected String staticContainerLifecycleEventObserver$str() {
        return "WELD-000418: Observer method for container lifecycle event cannot be static. {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException staticContainerLifecycleEventObserver(final ObserverMethod<?> observer, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(staticContainerLifecycleEventObserver$str(), observer, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNotificationMode$str() {
        return "WELD-000419: {0} is not a valid notification mode for asynchronous observers";
    }
    @Override
    public final IllegalArgumentException invalidNotificationMode(final Object mode) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidNotificationMode$str(), mode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noScheduledExecutorServicesProvided$str() {
        return "WELD-000420: Asynchronous observer notification with timeout option requires an implementation of ExecutorServices which provides an instance of ScheduledExecutorServices.";
    }
    @Override
    public final UnsupportedOperationException noScheduledExecutorServicesProvided() {
        final UnsupportedOperationException result = new UnsupportedOperationException(noScheduledExecutorServicesProvided$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInputValueForTimeout$str() {
        return "WELD-000421: Invalid input value for asynchronous observer notification timeout. Has to be parseable String, java.lang.Long or long. Original exception: {0}";
    }
    @Override
    public final IllegalArgumentException invalidInputValueForTimeout(final Object nfe) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidInputValueForTimeout$str(), nfe));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String selectByTypeOnlyWorksOnObject$str() {
        return "WELD-000422: WeldEvent.select(Type subtype, Annotation... qualifiers) can be invoked only on an instance of WeldEvent<Object>.";
    }
    @Override
    public final IllegalStateException selectByTypeOnlyWorksOnObject() {
        final IllegalStateException result = new IllegalStateException(selectByTypeOnlyWorksOnObject$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
