package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-02-15T14:41:50+0100")
public class UtilLogger_$logger extends DelegatingBasicLogger implements UtilLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UtilLogger_$logger.class.getName();
    public UtilLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String classNotEnum$str() {
        return "WELD-000804: {0} is not an enum";
    }
    @Override
    public final IllegalArgumentException classNotEnum(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(classNotEnum$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String tooManyPostConstructMethods$str() {
        return "WELD-000805: Cannot have more than one post construct method annotated with @PostConstruct for {0}";
    }
    @Override
    public final DefinitionException tooManyPostConstructMethods(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(tooManyPostConstructMethods$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooManyPreDestroyMethods$str() {
        return "WELD-000806: Cannot have more than one pre destroy method annotated @PreDestroy for {0}";
    }
    @Override
    public final DefinitionException tooManyPreDestroyMethods(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(tooManyPreDestroyMethods$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String initializerCannotBeProducer$str() {
        return "WELD-000807: Initializer method cannot be annotated @Produces {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException initializerCannotBeProducer(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(initializerCannotBeProducer$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String initializerCannotBeDisposalMethod$str() {
        return "WELD-000808: Initializer method cannot have parameters annotated @Disposes: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException initializerCannotBeDisposalMethod(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(initializerCannotBeDisposalMethod$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String qualifierOnFinalField$str() {
        return "WELD-000810: Cannot place qualifiers on final fields:  {0}";
    }
    @Override
    public final DefinitionException qualifierOnFinalField(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(qualifierOnFinalField$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ambiguousConstructor$str() {
        return "WELD-000812: Cannot determine constructor to use for {0}. Possible constructors {1}";
    }
    @Override
    public final DefinitionException ambiguousConstructor(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(ambiguousConstructor$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidQuantityInjectableFieldsAndInitializerMethods$str() {
        return "WELD-000813: injectableFields and initializerMethods must have the same size.\n\nInjectable Fields:  {0}\nInitializerMethods:  {1}";
    }
    @Override
    public final IllegalArgumentException invalidQuantityInjectableFieldsAndInitializerMethods(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidQuantityInjectableFieldsAndInitializerMethods$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String annotationNotQualifier$str() {
        return "WELD-000814: Annotation {0} is not a qualifier";
    }
    @Override
    public final IllegalArgumentException annotationNotQualifier(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(annotationNotQualifier$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String redundantQualifier$str() {
        return "WELD-000815: Qualifier {0} is already present in the set {1}";
    }
    @Override
    public final IllegalArgumentException redundantQualifier(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(redundantQualifier$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindConstructor$str() {
        return "WELD-000816: Cannot determine constructor to use for {0}";
    }
    @Override
    public final DefinitionException unableToFindConstructor(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(unableToFindConstructor$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindBeanDeploymentArchive$str() {
        return "WELD-000817: Unable to find Bean Deployment Archive for {0}";
    }
    @Override
    public final IllegalStateException unableToFindBeanDeploymentArchive(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToFindBeanDeploymentArchive$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String eventTypeNotAllowed$str() {
        return "WELD-000818: Event type {0} is not allowed";
    }
    @Override
    public final IllegalArgumentException eventTypeNotAllowed(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(eventTypeNotAllowed$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String typeParameterNotAllowedInEventType$str() {
        return "WELD-000819: Cannot provide an event type parameterized with a type parameter {0}";
    }
    @Override
    public final IllegalArgumentException typeParameterNotAllowedInEventType(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(typeParameterNotAllowedInEventType$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotProxyNonClassType$str() {
        return "WELD-000820: Cannot proxy non-Class Type {0}";
    }
    @Override
    public final IllegalArgumentException cannotProxyNonClassType(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(cannotProxyNonClassType$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String accessErrorOnField$str() {
        return "WELD-000824: Error getting field {0} on {1}";
    }
    @Override
    public final WeldException accessErrorOnField(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(accessErrorOnField$str(), param1, param2), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String annotationValuesInaccessible$str() {
        return "WELD-000826: Cannot access values() on annotation";
    }
    @Override
    public final DeploymentException annotationValuesInaccessible(final Throwable cause) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), annotationValuesInaccessible$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String initializerMethodIsGeneric$str() {
        return "WELD-000827: Initializer method may not be a generic method: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException initializerMethodIsGeneric(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(initializerMethodIsGeneric$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String resourceSetterInjectionNotAJavabean$str() {
        return "WELD-000833: Resource injection point represents a method which doesn't follow JavaBean conventions {0}";
    }
    @Override
    public final DefinitionException resourceSetterInjectionNotAJavabean(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(resourceSetterInjectionNotAJavabean$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToInjectResource(final Object member, final Object stackElement) {
        super.log.logv(FQCN, WARN, null, unableToInjectResource$str(), member, stackElement);
    }
    protected String unableToInjectResource$str() {
        return "WELD-000834: Unable to inject resource - most probably incorrect InjectionServices SPI implementation: {0}\n\tat {1}";
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
