/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.environment.servlet.logging.TomcatLogger;

public class TomcatLogger_$logger
extends DelegatingBasicLogger
implements TomcatLogger,
WeldEnvironmentLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = TomcatLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public TomcatLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void allInjectionsAvailable() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.allInjectionsAvailable$str(), new Object[0]);
    }

    protected String allInjectionsAvailable$str() {
        return "WELD-ENV-001100: Tomcat 7+ detected, CDI injection will be available in Servlets, Filters and Listeners.";
    }

    @Override
    public final void listenersInjectionsNotAvailable() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.listenersInjectionsNotAvailable$str(), new Object[0]);
    }

    protected String listenersInjectionsNotAvailable$str() {
        return "WELD-ENV-001101: Tomcat 7+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported.";
    }

    @Override
    public final void unableToReplaceTomcat(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.unableToReplaceTomcat$str(), new Object[0]);
    }

    protected String unableToReplaceTomcat$str() {
        return "WELD-ENV-001102: Unable to replace Tomcat 7 AnnotationProcessor. CDI injection will not be available in Servlets, Filters, or Listeners.";
    }

    protected String cannotCreatWeldForwardingAnnotationProcessor$str() {
        return "WELD-ENV-001103: Cannot create WeldForwardingAnnotationProcessor.";
    }

    @Override
    public final RuntimeException cannotCreatWeldForwardingAnnotationProcessor(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotCreatWeldForwardingAnnotationProcessor$str(), new Object[0]), cause);
        TomcatLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String cannotGetStandardContext$str() {
        return "WELD-ENV-001104: Cannot get StandardContext from ServletContext.";
    }

    @Override
    public final RuntimeException cannotGetStandardContext(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotGetStandardContext$str(), new Object[0]), cause);
        TomcatLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String neitherFieldNorGetterSetterFound$str() {
        return "WELD-ENV-001105: Neither field nor getter/setter found for instanceManager on {0}";
    }

    @Override
    public final RuntimeException neitherFieldNorGetterSetterFound(Class<?> standardContextClass) {
        RuntimeException result = new RuntimeException(this._formatMessage(this.neitherFieldNorGetterSetterFound$str(), standardContextClass));
        TomcatLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String errorInvokingMethod$str() {
        return "WELD-ENV-001106: Exception invoking method {0} on object {1}, using arguments {2}";
    }

    @Override
    public final RuntimeException errorInvokingMethod(String method, Object obj, Object ... args) {
        RuntimeException result = new RuntimeException(this._formatMessage(this.errorInvokingMethod$str(), method, obj, Arrays.toString(args)));
        TomcatLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorReadingField$str() {
        return "WELD-ENV-001107: Exception reading field {0} on object {1}";
    }

    @Override
    public final RuntimeException errorReadingField(String field, Object obj) {
        RuntimeException result = new RuntimeException(this._formatMessage(this.errorReadingField$str(), field, obj));
        TomcatLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorWritingField$str() {
        return "WELD-ENV-001108: Exception writing field {0} on object {1}, new value: {2}";
    }

    @Override
    public final RuntimeException errorWritingField(String field, Object obj, Object value) {
        RuntimeException result = new RuntimeException(this._formatMessage(this.errorWritingField$str(), field, obj, value));
        TomcatLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void catchingDebug(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, arg0, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }

    @Override
    public final void catchingTrace(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.TRACE, arg0, this.catchingTrace$str(), new Object[0]);
    }

    protected String catchingTrace$str() {
        return "Catching";
    }
}

