/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.LabelProvider;
import org.jboss.windup.config.loader.LabelLoader;
import org.jboss.windup.config.loader.LabelProviderLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.Label;
import org.jboss.windup.config.metadata.LabelProviderRegistry;
import org.jboss.windup.util.ServiceLogger;
import org.jboss.windup.util.exception.WindupException;

public class LabelLoaderImpl
implements LabelLoader {
    public static Logger LOG = Logger.getLogger(LabelLoaderImpl.class.getName());
    @Inject
    private Imported<LabelProviderLoader> loaders;

    public LabelProviderRegistry loadConfiguration(RuleLoaderContext ruleLoaderContext) {
        return this.build(ruleLoaderContext);
    }

    private void checkForDuplicateProviders(List<LabelProvider> providers) {
        HashMap<LabelProvider, LabelProvider> duplicates = new HashMap<LabelProvider, LabelProvider>(providers.size());
        for (LabelProvider provider : providers) {
            LabelProvider previousProvider = (LabelProvider)duplicates.get(provider);
            if (previousProvider != null) {
                String currentProviderOrigin = provider.getMetadata().getOrigin();
                String previousProviderOrigin = previousProvider.getMetadata().getOrigin();
                String typeMessage = previousProvider.getClass().equals(provider.getClass()) ? " (type: " + previousProviderOrigin + " and " + currentProviderOrigin + ")" : " (types: " + Proxies.unwrapProxyClassName(previousProvider.getClass()) + " at " + previousProviderOrigin + " and " + Proxies.unwrapProxyClassName(provider.getClass()) + " at " + currentProviderOrigin + ")";
                throw new WindupException("Found two providers with the same id: " + provider.getMetadata().getID() + typeMessage);
            }
            duplicates.put(provider, provider);
        }
    }

    private List<LabelProvider> getProviders(RuleLoaderContext ruleLoaderContext) {
        LOG.info("Starting provider load...");
        ArrayList<LabelProvider> unsortedProviders = new ArrayList<LabelProvider>();
        for (LabelProviderLoader loader : this.loaders) {
            if (ruleLoaderContext.isFileBasedRulesOnly() && !loader.isFileBased()) continue;
            unsortedProviders.addAll(loader.getProviders(ruleLoaderContext));
        }
        LOG.info("Loaded, now sorting, etc");
        this.checkForDuplicateProviders(unsortedProviders);
        ArrayList<LabelProvider> sortedProviders = new ArrayList<LabelProvider>(unsortedProviders);
        sortedProviders.sort(Comparator.comparingInt(t -> t.getMetadata().getPriority()));
        ServiceLogger.logLoadedServices((Logger)LOG, LabelProvider.class, sortedProviders);
        LOG.info("Finished provider load");
        return Collections.unmodifiableList(sortedProviders);
    }

    private LabelProviderRegistry build(RuleLoaderContext ruleLoaderContext) {
        List<LabelProvider> providers = this.getProviders(ruleLoaderContext);
        LabelProviderRegistry registry = new LabelProviderRegistry();
        registry.setProviders(providers);
        for (LabelProvider provider : providers) {
            if (ruleLoaderContext.getLabelProviderFilter() != null) {
                boolean accepted = ruleLoaderContext.getLabelProviderFilter().accept((Object)provider);
                LOG.info((accepted ? "Accepted" : "Skipped") + ": [" + provider + "] by filter [" + ruleLoaderContext.getLabelProviderFilter() + "]");
                if (!accepted) continue;
            }
            List labels = provider.getData().getLabels();
            List labelIDs = labels.stream().map(Label::getId).collect(Collectors.toList());
            List repeatedLabels = labels.stream().filter(i -> Collections.frequency(labelIDs, i.getId()) > 1).collect(Collectors.toList());
            if (!repeatedLabels.isEmpty()) {
                throw new WindupException("Found multiple labels with the same id: " + repeatedLabels.stream().map(Label::getId).distinct().collect(Collectors.joining(",")) + " within the same labelSet: " + provider.getMetadata().getID());
            }
            List invalidLabels = labels.stream().filter(p -> Objects.isNull(p.getId()) || Objects.isNull(p.getName()) || p.getId().trim().isEmpty() || p.getName().trim().isEmpty()).collect(Collectors.toList());
            if (!invalidLabels.isEmpty()) {
                throw new WindupException("Found invalid labels: " + invalidLabels.stream().map(Label::getId).collect(Collectors.joining(",")) + " within the labelSet:" + provider.getMetadata().getID() + ". Label[id] and Label[name] name should not be null or empty");
            }
            registry.setLabels(provider, labels);
        }
        return registry;
    }
}

