/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Locale;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.config.ConfigurationParameterConverter;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;

@API(status=API.Status.INTERNAL, since="5.8")
public class EnumConfigurationParameterConverter<E extends Enum<E>>
implements ConfigurationParameterConverter<E> {
    private static final Logger logger = LoggerFactory.getLogger(EnumConfigurationParameterConverter.class);
    private final Class<E> enumType;
    private final String enumDisplayName;

    public EnumConfigurationParameterConverter(Class<E> enumType, String enumDisplayName) {
        this.enumType = enumType;
        this.enumDisplayName = enumDisplayName;
    }

    @Override
    public Optional<E> get(ConfigurationParameters configParams, String key) {
        return configParams.get(key).map(value -> this.convert(key, (String)value));
    }

    public Optional<E> get(ExtensionContext extensionContext, String key) {
        return extensionContext.getConfigurationParameter(key, value -> this.convert(key, (String)value));
    }

    private E convert(String key, String value) {
        String constantName = null;
        try {
            constantName = value.strip().toUpperCase(Locale.ROOT);
            E result = Enum.valueOf(this.enumType, constantName);
            logger.config(() -> "Using %s '%s' set via the '%s' configuration parameter.".formatted(this.enumDisplayName, result, key));
            return result;
        }
        catch (Exception ex) {
            throw new JUnitException("Invalid %s '%s' set via the '%s' configuration parameter.".formatted(this.enumDisplayName, constantName, key));
        }
    }
}

