/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;

public class CsvRecord {
    final long startingLineNumber;
    final String[] fields;
    final boolean comment;

    CsvRecord(long startingLineNumber, String[] fields, boolean comment) {
        this.startingLineNumber = startingLineNumber;
        this.fields = fields;
        this.comment = comment;
    }

    public long getStartingLineNumber() {
        return this.startingLineNumber;
    }

    public String getField(int index) {
        return this.fields[index];
    }

    public List<String> getFields() {
        return Collections.unmodifiableList(Arrays.asList(this.fields));
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public boolean isComment() {
        return this.comment;
    }

    public String toString() {
        return new StringJoiner(", ", CsvRecord.class.getSimpleName() + "[", "]").add("startingLineNumber=" + this.startingLineNumber).add("fields=" + Arrays.toString(this.fields)).add("comment=" + this.comment).toString();
    }
}

