/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.AbstractInternalCsvCallbackHandler;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.FieldModifier;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.NamedCsvRecord;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.RecordType;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.util.Nullable;

public final class NamedCsvRecordHandler
extends AbstractInternalCsvCallbackHandler<NamedCsvRecord> {
    private static final String[] EMPTY_HEADER = new String[0];
    private final boolean allowDuplicateHeaderFields;
    private final boolean returnHeader;
    @Nullable
    private String[] header;

    private NamedCsvRecordHandler(int maxFields, int maxFieldSize, int maxRecordSize, FieldModifier fieldModifier, boolean allowDuplicateHeaderFields, boolean returnHeader, @Nullable List<String> header) {
        super(maxFields, maxFieldSize, maxRecordSize, fieldModifier);
        this.allowDuplicateHeaderFields = allowDuplicateHeaderFields;
        this.returnHeader = returnHeader;
        if (header != null) {
            this.header = this.validateHeader(header.toArray(new String[0]));
        }
    }

    public static NamedCsvRecordHandlerBuilder builder() {
        return new NamedCsvRecordHandlerBuilder();
    }

    public static NamedCsvRecordHandler of() {
        return NamedCsvRecordHandler.builder().build();
    }

    public static NamedCsvRecordHandler of(Consumer<NamedCsvRecordHandlerBuilder> configurer) {
        Objects.requireNonNull(configurer, "configurer must not be null");
        NamedCsvRecordHandlerBuilder builder = NamedCsvRecordHandler.builder();
        configurer.accept(builder);
        return builder.build();
    }

    private String[] validateHeader(String[] fields) {
        Objects.requireNonNull(fields, "header must not be null");
        for (String h : fields) {
            Objects.requireNonNull(h, "header element must not be null");
        }
        if (!this.allowDuplicateHeaderFields) {
            NamedCsvRecordHandler.checkForDuplicates(fields);
        }
        return fields;
    }

    private static void checkForDuplicates(String[] header) {
        LinkedHashSet<String> duplicateHeaders = new LinkedHashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        for (String h : header) {
            if (seen.add(h)) continue;
            duplicateHeaders.add(h);
        }
        if (!duplicateHeaders.isEmpty()) {
            throw new IllegalArgumentException("Header contains duplicate fields: " + String.valueOf(duplicateHeaders));
        }
    }

    @Override
    @Nullable
    protected NamedCsvRecord buildRecord() {
        String[] compactFields = this.compactFields();
        if (this.recordType == RecordType.COMMENT) {
            return new NamedCsvRecord(this.startingLineNumber, compactFields, true, EMPTY_HEADER);
        }
        if (this.header == null) {
            this.header = this.validateHeader(compactFields);
            if (!this.returnHeader) {
                return null;
            }
        }
        return new NamedCsvRecord(this.startingLineNumber, compactFields, false, this.header);
    }

    public static final class NamedCsvRecordHandlerBuilder
    extends AbstractInternalCsvCallbackHandler.AbstractInternalCsvCallbackHandlerBuilder<NamedCsvRecordHandlerBuilder> {
        private boolean allowDuplicateHeaderFields;
        private boolean returnHeader;
        @Nullable
        private List<String> header;

        private NamedCsvRecordHandlerBuilder() {
        }

        public NamedCsvRecordHandlerBuilder allowDuplicateHeaderFields(boolean allowDuplicateHeaderFields) {
            this.allowDuplicateHeaderFields = allowDuplicateHeaderFields;
            return this;
        }

        public NamedCsvRecordHandlerBuilder header(String ... header) {
            Objects.requireNonNull(header, "header must not be null");
            this.header = List.of(header);
            return this;
        }

        public NamedCsvRecordHandlerBuilder header(List<String> header) {
            Objects.requireNonNull(header, "header must not be null");
            this.header = List.copyOf(header);
            return this;
        }

        public NamedCsvRecordHandlerBuilder returnHeader(boolean returnHeader) {
            this.returnHeader = returnHeader;
            return this;
        }

        @Override
        protected NamedCsvRecordHandlerBuilder self() {
            return this;
        }

        public NamedCsvRecordHandler build() {
            if (this.returnHeader && this.header != null) {
                throw new IllegalArgumentException("Predefined headers cannot be used with returnHeader=true");
            }
            return new NamedCsvRecordHandler(this.maxFields, this.maxFieldSize, this.maxRecordSize, this.fieldModifier, this.allowDuplicateHeaderFields, this.returnHeader, this.header);
        }
    }
}

