/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.license.LicenseCheckingSnapshotGenerator;
import com.datical.liquibase.ext.util.CachedQueryUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtil;

public class SynonymSnapshotGenerator
extends LicenseCheckingSnapshotGenerator {
    public static final String ACTUAL_OBJECT_CATALOG_NAME = "_actualObjectCatalogName";
    private final Pattern MSSQL_NAME_AND_SCHEMA_PATTERN = Pattern.compile("\\[(.*)\\]\\.\\[(.*)\\]");
    private final Pattern MSSQL_NAME_ONLY_PATTERN = Pattern.compile("\\[([^\\[\\]]*)\\]");
    private Set<String> oracleSystemSchemas = new HashSet<String>(Arrays.asList("APPQOSSYS", "BI", "CTXSYS", "DBMS_PRIVILEGE_CAPTURE", "DBSNMP", "DIP", "DMSYS", "DVSYS", "EXFSYS", "FLOWS_FILES", "LBACSYS", "MDDATA", "MDSYS", "MGMT_VIEW", "ODM", "ODM_MTR", "OLAPSYS", "ORACLE_OCM", "ORDDATA", "ORDSYS", "OUTLN", "SYS", "SYSMAN", "SYSTEM", "WMSYS", "XDB"));

    public SynonymSnapshotGenerator() {
        super(Synonym.class, new Class[]{Schema.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!LicenseServiceUtils.isProLicenseValid()) {
            return -1;
        }
        if (database instanceof OracleDatabase || database instanceof AbstractDb2Database || database instanceof MSSQLDatabase || database instanceof EnterpriseDBDatabase) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (foundObject instanceof Schema) {
            String sql;
            Database database = snapshot.getDatabase();
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            String schemaName = ((Schema)foundObject).toCatalogAndSchema().customize(database).getSchemaName();
            boolean fetchedAcrossSchemas = false;
            if (database instanceof OracleDatabase) {
                String allCatalogs = (String)snapshot.getScratchData("DatabaseSnapshot.allCatalogsString");
                sql = "SELECT NULL AS SYNONYM_CATALOG_NAME, ALL_SYNONYMS.OWNER AS SYNONYM_SCHEMA_NAME, SYNONYM_NAME, NULL AS OBJECT_CATALOG_NAME, TABLE_OWNER AS OBJECT_SCHEMA_NAME, TABLE_NAME AS OBJECT_NAME, NULL AS OBJECT_TYPE FROM ALL_SYNONYMS ";
                if (allCatalogs == null) {
                    sql = sql + "WHERE (ALL_SYNONYMS.OWNER='" + schemaName + "' OR (ALL_SYNONYMS.OWNER='PUBLIC' and ALL_SYNONYMS.TABLE_OWNER='" + schemaName + "'))";
                } else {
                    sql = sql + "WHERE (ALL_SYNONYMS.OWNER IN ('" + schemaName + "', " + allCatalogs + ") OR (ALL_SYNONYMS.OWNER='PUBLIC' and ALL_SYNONYMS.TABLE_OWNER IN ('" + schemaName + "', " + allCatalogs + ")))";
                    fetchedAcrossSchemas = true;
                }
            } else if (database instanceof DB2Database) {
                sql = "select a.TABSCHEMA AS SYNONYM_SCHEMA_NAME, a.TABNAME as SYNONYM_NAME, a.BASE_TABNAME as OBJECT_NAME, a.TABSCHEMA AS OBJECT_SCHEMA_NAME, decode(a.type, 'A', 'TABLE', 'q', 'SEQUENCE', 'u', 'MODULE') as OBJECT_TYPE from syscat.tables a where a.type in ('A', 'q', 'u') and (a.TABSCHEMA='" + schemaName + "' OR a.TABSCHEMA='SYSPUBLIC') and (a.OWNER != 'SYSIBM' OR a.OWNER IS NULL)";
            } else if (database instanceof Db2zDatabase) {
                sql = "SELECT CREATOR AS SYNONYM_SCHEMA_NAME, NAME AS SYNONYM_NAME, TBNAME AS OBJECT_NAME, TBCREATOR AS OBJECT_SCHEMA_NAME FROM SYSIBM.SYSTABLES WHERE CREATOR ='" + schemaName + "'AND TYPE='A'";
            } else if (database instanceof MSSQLDatabase) {
                sql = "SELECT NULL AS SYNONYM_CATALOG_NAME, SCHEMA_NAME(SCHEMA_ID) as SYNONYM_SCHEMA_NAME, name as SYNONYM_NAME, NULL AS OBJECT_CATALOG_NAME, NULL AS OBJECT_SCHEMA_NAME, PARSENAME(BASE_OBJECT_NAME,1) AS OBJECT_NAME, PARSENAME(BASE_OBJECT_NAME,2) AS OBJECT_SCHEMA_NAME, PARSENAME(BASE_OBJECT_NAME,3) AS OBJECT_CATALOG_NAME FROM sys.synonyms WHERE SCHEMA_NAME(SCHEMA_ID)='" + schemaName + "' AND IS_MS_SHIPPED='false'";
            } else if (database instanceof EnterpriseDBDatabase) {
                sql = this.getEnterpriseDBSql(schemaName) + "OR SCHEMA_NAME='PUBLIC'";
            } else {
                throw new UnexpectedLiquibaseException("Unexpected database: " + database.getShortName());
            }
            List<Map<String, ?>> rs = CachedQueryUtil.queryIfNotCached(fetchedAcrossSchemas, sql, "SynonymSnapshotGenerator.allRows", snapshot);
            for (Map<String, ?> row : rs) {
                boolean isPrivate;
                String actualSchemaName = (String)row.get("SYNONYM_SCHEMA_NAME");
                if (database instanceof MSSQLDatabase) {
                    isPrivate = true;
                } else if (actualSchemaName.equals("PUBLIC") || actualSchemaName.equals("SYSPUBLIC")) {
                    isPrivate = false;
                    actualSchemaName = null;
                } else {
                    isPrivate = true;
                }
                String actualCatalogName = (String)row.get("SYNONYM_CATALOG_NAME");
                if (database instanceof OracleDatabase && actualCatalogName == null) {
                    actualCatalogName = actualSchemaName;
                }
                Synonym synonym = new Synonym(actualCatalogName, actualSchemaName, (String)row.get("SYNONYM_NAME"));
                String objectCatalogName = (String)row.get("OBJECT_CATALOG_NAME");
                String objectSchemaName = (String)row.get("OBJECT_SCHEMA_NAME");
                if (database instanceof MSSQLDatabase) {
                    if (objectCatalogName == null) {
                        objectCatalogName = actualCatalogName;
                    }
                    if (objectSchemaName == null) {
                        objectSchemaName = actualSchemaName;
                    }
                } else if (objectCatalogName == null && objectSchemaName != null) {
                    objectCatalogName = objectSchemaName;
                }
                synonym.setObjectSchema(objectCatalogName, objectSchemaName);
                synonym.setObjectName((String)row.get("OBJECT_NAME"));
                synonym.setPrivate(isPrivate);
                synonym.setObjectType((String)row.get("OBJECT_TYPE"));
                if (fetchedAcrossSchemas && !StringUtil.trimToEmpty((String)synonym.getSchema().getCatalogName()).equalsIgnoreCase(schemaName) && (isPrivate || !StringUtil.trimToEmpty((String)objectCatalogName).equalsIgnoreCase(schemaName))) continue;
                if (!this.isSystemObject(synonym, database)) {
                    ((Schema)foundObject).addDatabaseObject((DatabaseObject)synonym);
                }
                if (!(database instanceof OracleDatabase)) continue;
                synonym.setAttribute("snapshotComplete", true);
            }
        }
    }

    protected boolean isSystemObject(Synonym synonym, Database database) {
        if (database instanceof OracleDatabase) {
            if (synonym.getObjectSchema() != null && (synonym.getObjectSchema().getName() != null || synonym.getObjectSchema().getCatalogName() != null)) {
                String objectSchema = null;
                objectSchema = synonym.getObjectSchema().getName() != null ? synonym.getObjectSchema().getName().toUpperCase() : synonym.getObjectSchema().getCatalogName().toUpperCase();
                if (this.oracleSystemSchemas.contains(objectSchema) || objectSchema.startsWith("APEX_") || objectSchema.startsWith("FLOWS_")) {
                    return true;
                }
            } else {
                synonym.setAttribute("missingSchema", true);
            }
            return synonym.getName().startsWith("/") || database.isSystemObject((DatabaseObject)synonym);
        }
        return false;
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        String sql;
        String schemaName;
        Database database = snapshot.getDatabase();
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        if (((Synonym)example).isPrivate()) {
            schemaName = example.getSchema().toCatalogAndSchema().customize(database).getSchemaName();
        } else if (database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase) {
            schemaName = "PUBLIC";
        } else if (database instanceof AbstractDb2Database) {
            schemaName = "SYSPUBLIC";
        } else {
            throw new UnexpectedLiquibaseException("Unknown public synonym schema for " + database.getShortName());
        }
        if (database instanceof OracleDatabase) {
            if (((Boolean)example.getAttribute("snapshotComplete", (Object)false)).booleanValue()) {
                example.setAttribute("snapshotComplete", null);
                return example;
            }
            sql = "SELECT NULL AS SYNONYM_CATALOG_NAME, OWNER AS SYNONYM_SCHEMA_NAME, SYNONYM_NAME, TABLE_OWNER AS OBJECT_CATALOG_NAME, NULL AS OBJECT_SCHEMA_NAME, TABLE_NAME AS OBJECT_NAME, NULL AS OBJECT_TYPE FROM ALL_SYNONYMS WHERE OWNER='" + schemaName + "' AND SYNONYM_NAME='" + example.getName() + "'";
        } else if (database instanceof DB2Database) {
            sql = "select a.TABSCHEMA AS SYNONYM_SCHEMA_NAME, a.TABNAME as SYNONYM_NAME, a.BASE_TABNAME as OBJECT_NAME, a.TABSCHEMA AS OBJECT_SCHEMA_NAME, decode(a.type, 'A', 'TABLE', 'q', 'SEQUENCE', 'u', 'MODULE') as OBJECT_TYPE from syscat.tables a where a.type in ('A', 'q', 'u') and (a.TABSCHEMA='" + schemaName + "') and a.TABNAME='" + example.getName() + "'";
        } else if (database instanceof Db2zDatabase) {
            sql = "SELECT CREATOR AS SYNONYM_SCHEMA_NAME, NAME AS SYNONYM_NAME, TBNAME AS OBJECT_NAME, TBCREATOR AS OBJECT_SCHEMA_NAME FROM SYSIBM.SYSTABLES WHERE CREATOR ='" + schemaName + "' AND NAME ='" + example.getName() + "' AND TYPE='A'";
        } else if (database instanceof MSSQLDatabase) {
            sql = "SELECT NULL AS SYNONYM_CATALOG_NAME, SCHEMA_NAME(SCHEMA_ID) as SYNONYM_SCHEMA_NAME, name as SYNONYM_NAME, NULL AS OBJECT_CATALOG_NAME, NULL AS OBJECT_SCHEMA_NAME, PARSENAME(BASE_OBJECT_NAME,1) AS OBJECT_NAME, PARSENAME(BASE_OBJECT_NAME,2) AS OBJECT_SCHEMA_NAME, PARSENAME(BASE_OBJECT_NAME,3) AS OBJECT_CATALOG_NAME FROM sys.synonyms WHERE SCHEMA_NAME(SCHEMA_ID)='" + schemaName + "' AND name='" + example.getName() + "' AND IS_MS_SHIPPED='false'";
        } else if (database instanceof EnterpriseDBDatabase) {
            sql = this.getEnterpriseDBSql(schemaName) + "AND SYNONYM_NAME='" + example.getName() + "'";
        } else {
            throw new UnexpectedLiquibaseException("Unexpected database: " + database.getShortName());
        }
        List rs = executor.queryForList((SqlStatement)new RawSqlStatement(sql));
        if (rs.size() == 0) {
            return null;
        }
        if (rs.size() > 1) {
            throw new DatabaseException("Too many rows returned for " + example);
        }
        Map row = (Map)rs.get(0);
        String finalSchemaName = ((Synonym)example).isPrivate() ? (String)row.get("SYNONYM_SCHEMA_NAME") : null;
        String synonymName = (String)row.get("SYNONYM_NAME");
        Synonym synonym = new Synonym((String)row.get("SYNONYM_CATALOG_NAME"), finalSchemaName, synonymName);
        if (database instanceof MSSQLDatabase) {
            synonym.setPrivate(true);
        } else {
            synonym.setPrivate(((Synonym)example).isPrivate());
        }
        String objectName = (String)row.get("OBJECT_NAME");
        String objectSchemaName = (String)row.get("OBJECT_SCHEMA_NAME");
        synonym.setObjectName(objectName);
        String objectCatalogName = (String)row.get("OBJECT_CATALOG_NAME");
        if (database instanceof MSSQLDatabase) {
            if (objectCatalogName == null) {
                objectCatalogName = (String)row.get("SYNONYM_CATALOG_NAME");
            }
            if (objectSchemaName == null) {
                objectSchemaName = (String)row.get("SYNONYM_SCHEMA_NAME");
            }
            synonym.setAttribute(ACTUAL_OBJECT_CATALOG_NAME, objectCatalogName);
        }
        synonym.setObjectSchema(objectCatalogName, objectSchemaName);
        String type = (String)row.get("OBJECT_TYPE");
        type = StringUtil.trimToNull((String)type);
        synonym.setObjectType(type);
        synonym.setAttribute("missingSchema", example.getAttribute("missingSchema", Boolean.class));
        return synonym;
    }

    private String getEnterpriseDBSql(String schemaName) {
        return "SELECT OWNER AS SYNONYM_CATALOG_NAME, SCHEMA_NAME AS SYNONYM_SCHEMA_NAME, SYNONYM_NAME, TABLE_OWNER AS OBJECT_CATALOG_NAME, TABLE_SCHEMA_NAME AS OBJECT_SCHEMA_NAME, TABLE_NAME AS OBJECT_NAME FROM ALL_SYNONYMS WHERE SCHEMA_NAME='" + schemaName + "' ";
    }
}

