/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import java.io.FileNotFoundException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.resource.Resource;
import liquibase.sdk.resource.MockResource;

public class InMemoryChecksFileAccessor
implements FileAccessor {
    private final Map<String, String> files = new ConcurrentHashMap<String, String>();

    @Override
    public FileAccessorDTO loadFileContents(String filename) throws FileNotFoundException {
        if (this.files.containsKey(filename)) {
            FileAccessorDTO dto = new FileAccessorDTO();
            dto.versioned = false;
            dto.contents = this.files.get(filename);
            dto.setOriginalContents(dto.contents);
            dto.resource = new MockResource(filename, dto.contents);
            return dto;
        }
        throw new FileNotFoundException();
    }

    @Override
    public void writeFileContents(Resource resource, String filename, String contents, boolean errorIfFileAlreadyExists) throws FileAlreadyExistsException {
        if (errorIfFileAlreadyExists && this.exists(filename)) {
            throw new FileAlreadyExistsException(filename);
        }
        this.files.put(filename, contents);
    }

    public boolean exists(String path) {
        return this.files.containsKey(path);
    }
}

