/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;

public class CheckRunInTransactionValue
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public String getName() {
        return "Check Changeset runInTransaction value";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "CheckRunInTransactionValue";
    }

    private boolean doEvaluate(ChangeSet changeSet, DynamicRule instance, boolean isRollback) {
        boolean checkValue;
        boolean changeSetValue = changeSet.isRunInTransaction();
        if (changeSetValue == (checkValue = ((Boolean)instance.getParameters().get(0).getValue()).booleanValue())) {
            this.addErrorMessage(changeSet, checkValue, instance, isRollback);
        }
        return this.returnAtEndOfRule(changeSet, instance, isRollback);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule instance) {
        return this.doEvaluate(changeSet, instance, false);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doEvaluate(changeSet, dr, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    private void addErrorMessage(ChangeSet changeSet, boolean value, DynamicRule instance, boolean isRollback) {
        this.addFailureRuleIteration(changeSet, String.format("Changeset has a runInTransaction value of '%s'.", value), instance, isRollback);
    }

    @Override
    public String getDescription() {
        return " This check triggers when a changeset contains the user-specified runInTransactions value of 'true' or 'false'. Note: Changesets without a runInTransactions value are not checked.";
    }

    @Override
    public int getPriority() {
        return 95;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.RUN_IN_TRANSACTION_VALUE), new RuleParameter(DynamicRuleParameterEnum.MESSAGE));
    }
}

