/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionCommandStep;
import liquibase.database.Database;
import liquibase.database.core.DatabaseUtils;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.StringUtil;

public class ConnectCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"connect"};

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        return Collections.singletonList(DbUrlConnectionArgumentsCommandStep.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        DbUrlConnectionCommandStep connectionCommandStep = new DbUrlConnectionCommandStep();
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String url = JdbcConnection.sanitizeUrl((String)((String)commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG)));
        String catalog = (String)commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.DEFAULT_CATALOG_NAME_ARG);
        String schema = (String)commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.DEFAULT_SCHEMA_NAME_ARG);
        String dbInfo = this.buildDbInfoString(catalog, schema, null);
        try {
            connectionCommandStep.run(resultsBuilder);
            try (Database database = (Database)commandScope.getDependency(Database.class);){
                dbInfo = this.buildDbInfoString(catalog, schema, database);
                Scope.getCurrentScope().getUI().sendMessage("Success: The database " + dbInfo + "at url '" + url + "' is accessible with the supplied credentials.");
            }
        }
        catch (Exception e) {
            throw new CommandExecutionException("Failure: The database " + dbInfo + "at url '" + url + "' is not accessible with the supplied credentials.", (Throwable)e);
        }
    }

    private String buildDbInfoString(String catalog, String schema, Database database) {
        String info = DatabaseUtils.buildCatalogAndSchemaString((String)catalog, (String)schema);
        if (database != null) {
            String version = null;
            try {
                version = database.getDatabaseProductVersion();
            }
            catch (DatabaseException e) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to obtain database product version", (Throwable)e);
            }
            if (StringUtil.isNotEmpty((String)info)) {
                info = info + " ";
            }
            info = info + "(" + database.getDatabaseProductName();
            if (version != null) {
                info = info + " " + version;
            }
            info = info + ")";
        }
        if (StringUtil.isNotEmpty((String)info)) {
            info = "'" + info + "' ";
        }
        return info;
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Tests the connection properties (url, username, password). Returns database's response, if any, with success or failure."));
    }
}

