/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.visitor.DatabaseChangelogHistoryChangeExecListener;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeSet;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.TagCommandStep;
import liquibase.database.Database;
import liquibase.exception.CommandValidationException;
import liquibase.exception.LiquibaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;

@CommandOverride(override=TagCommandStep.class)
public class ProTagCommandStep
extends TagCommandStep {
    public static final CommandArgumentDefinition<Boolean> ADDROW_ARG;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void validate(CommandScope commandScope) throws CommandValidationException {
        boolean addRow = (Boolean)commandScope.getArgumentValue(ADDROW_ARG);
        if (addRow) {
            try {
                LicenseServiceUtils.checkProLicenseAndThrowException((String[])TagCommandStep.COMMAND_NAME);
            }
            catch (CommandValidationException cve) {
                String message = "ERROR: No valid Pro license found to enable the '<--addrow=true | LIQUIBASE_COMMAND_TAG_ADDROW=TRUE | etc>' property for the 'tag' command. Get a free trial license key at https://liquibase.com/trial and include liquibase.licenseKey in defaults file, or add via CLI or Environment variable. Learn more at https://docs.liquibase.com";
                throw new CommandValidationException(message, (Throwable)cve);
            }
        }
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        boolean addRow = (Boolean)commandScope.getArgumentValue(ADDROW_ARG);
        Database database = (Database)commandScope.getDependency(Database.class);
        String tag = (String)commandScope.getArgumentValue(TagCommandStep.TAG_ARG);
        if (!addRow) {
            Scope.child(ProTagCommandStep.getScopeValues(tag), () -> {
                try {
                    super.run(resultsBuilder);
                    new DatabaseChangelogHistoryChangeExecListener().logEvent(null, database, "success", commandScope);
                }
                catch (Exception e) {
                    new DatabaseChangelogHistoryChangeExecListener().logEvent(null, database, "fail", commandScope);
                }
            });
            return;
        }
        ChangeLogHistoryService changeLogService = ((ChangeLogHistoryServiceFactory)Scope.getCurrentScope().getSingleton(ChangeLogHistoryServiceFactory.class)).getChangeLogService(database);
        changeLogService.generateDeploymentId();
        changeLogService.init();
        this.setupExecutionServices(database);
        String epoch = Long.toString(new Date().getTime());
        ChangeSet changeSet = new ChangeSet("liquibasetagcommand-" + epoch, "liquibasetagcommand", false, false, "liquibasetagcommand", null, null, null);
        TagDatabaseChange tagDatabaseChange = new TagDatabaseChange();
        tagDatabaseChange.setTag(tag);
        changeSet.addChange((Change)tagDatabaseChange);
        Scope.child(ProTagCommandStep.getScopeValues(tag), () -> {
            try {
                database.markChangeSetExecStatus(changeSet, ChangeSet.ExecType.EXECUTED);
                String message = "Successfully added tag entry to the Database Changelog table";
                Scope.getCurrentScope().getLog(ProTagCommandStep.class).info(message);
                new DatabaseChangelogHistoryChangeExecListener().logEvent(null, database, "success", commandScope);
            }
            catch (Exception e) {
                new DatabaseChangelogHistoryChangeExecListener().logEvent(null, database, "fail", commandScope);
            }
        });
    }

    private static Map<String, Object> getScopeValues(String tag) {
        HashMap<String, Object> scopeVals = new HashMap<String, Object>();
        scopeVals.put("completeSql", new AtomicReference());
        scopeVals.put("tag", tag);
        return scopeVals;
    }

    private void setupExecutionServices(Database database) throws LiquibaseException {
        LockService lockService = LockServiceFactory.getInstance().getLockService(database);
        lockService.waitForLock();
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
        changeLogHistoryService.init();
    }

    public int getOrder(CommandDefinition commandDefinition) {
        int result = super.getOrder(commandDefinition);
        if (result < 0 && !commandDefinition.getName()[0].equals(TagCommandStep.COMMAND_NAME[0])) {
            return result;
        }
        return 1100;
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        ADDROW_ARG = builder.argument("addRow", Boolean.class).description(ProStringUtil.markWithPro("Add entry to Database Changelog table")).defaultValue((Object)false).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof String && !value.equals("")) {
                List<String> validValues = Arrays.asList("TRUE", "FALSE");
                if (!validValues.contains(((String)value).toUpperCase())) {
                    throw new IllegalArgumentException("Illegal value for `addRow'.  Valid values are 'TRUE' or 'FALSE'");
                }
                return Boolean.parseBoolean((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return null;
        }).build();
    }
}

