/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriterFactory;
import com.datical.liquibase.ext.command.AbstractSetCommandStep;
import com.datical.liquibase.ext.util.ProStringUtil;
import com.datical.liquibase.ext.visitor.ModifyChangeSetLabelsVisitor;
import java.util.Arrays;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.listener.LiquibaseListener;

public class SetLabelsCommandStep
extends AbstractSetCommandStep {
    public static final String STATUS_CODE = "statusCode";
    public static String[] COMMAND_NAME = new String[]{"setLabels"};
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> SET_AS_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_ID_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH_ARG;
    public static final CommandArgumentDefinition<String> LABEL_FILTER_ARG;
    public static final CommandArgumentDefinition<String> CONTEXTS_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_REPLACE_ARG;
    public static final CommandArgumentDefinition<String> DBMS_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Bulk set labels in the changelog file"));
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String dbms = (String)commandScope.getArgumentValue(DBMS_ARG);
        Database database = this.obtainDatabase(dbms, commandScope);
        Contexts contexts = new Contexts(this.getContextsArg(commandScope));
        LabelExpression labelExpression = new LabelExpression(this.getLabelFilterArg(commandScope));
        try {
            DatabaseChangeLog databaseChangeLog = this.parseDatabaseChangelog(this.getChangelogFileArg(commandScope), dbms, database);
            ChangeLogIterator runChangeLogIterator = this.determineChangeLogIterator(commandScope, dbms, database, contexts, labelExpression, databaseChangeLog);
            Scope.child((LiquibaseListener)null, () -> runChangeLogIterator.run((ChangeSetVisitor)new ModifyChangeSetLabelsVisitor((String)commandScope.getArgumentValue(SET_AS_ARG), (Boolean)commandScope.getArgumentValue(FORCE_REPLACE_ARG)), new RuntimeEnvironment(database, contexts, labelExpression)));
            ChangelogRewriterFactory changelogRewriterFactory = (ChangelogRewriterFactory)Scope.getCurrentScope().getSingleton(ChangelogRewriterFactory.class);
            ChangelogRewriter changelogRewriter = changelogRewriterFactory.createChangelogRewriter(this.getChangelogFileArg(commandScope), databaseChangeLog, null, ChangelogRewriter.MOD_TYPE.LABELS);
            if (changelogRewriter == null) {
                throw new LiquibaseException(String.format("Unsupported changelog type '%s'", this.getChangelogFileArg(commandScope)));
            }
            changelogRewriter.modifyChangelog();
        }
        catch (Exception e) {
            resultsBuilder.addResult(STATUS_CODE, (Object)1);
            throw e;
        }
        finally {
            this.cleanUp(resultsBuilder);
        }
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = builder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).required().description("The root changelog file").build();
        SET_AS_ARG = builder.argument("setAs", String.class).required().description("New label values").setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String valueString = (String)value;
                valueString = valueString.replace("\\\\", "");
                return valueString;
            }
            return null;
        }).build();
        CHANGESET_ID_ARG = builder.argument("changesetId", String.class).description("The id of the changeset to modify").build();
        CHANGESET_AUTHOR_ARG = builder.argument("changesetAuthor", String.class).description("The author of the changeset to modify").build();
        CHANGESET_PATH_ARG = builder.argument("changesetPath", String.class).description("The changeset path").build();
        LABEL_FILTER_ARG = builder.argument("labelFilter", String.class).addAlias("labels").description("Changeset labels to match").build();
        CONTEXTS_ARG = builder.argument("contextFilter", String.class).description("Changeset contexts to match").build();
        FORCE_REPLACE_ARG = builder.argument("forceReplace", Boolean.class).defaultValue((Object)false).description("Replace the labels if true").setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof String && !value.equals("")) {
                List<String> validValues = Arrays.asList("TRUE", "FALSE");
                if (!validValues.contains(((String)value).toUpperCase())) {
                    throw new IllegalArgumentException("Illegal value for 'forceReplace'.  Valid values are 'TRUE' or 'FALSE'");
                }
                return Boolean.parseBoolean((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return null;
        }).build();
        DBMS_ARG = builder.argument("dbms", String.class).description("The database to filter by").setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String dbmsString = (String)value;
                SetLabelsCommandStep.validateDbmsString(dbmsString);
                return dbmsString;
            }
            return null;
        }).build();
        URL_ARG = builder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL").build();
        DEFAULT_SCHEMA_NAME_ARG = builder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = builder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = builder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = builder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = builder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").build();
        PASSWORD_ARG = builder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
    }
}

