/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.resource.Resource;

public class EngineResults<T> {
    private final List<RuleCombination> skippedBecauseOfLicenceRules;
    private final LinkedHashMap<T, LiquibaseQualityCheckResult> results;
    private final List<Resource> resources;

    public EngineResults(List<Resource> resources) {
        this(Collections.emptyList(), new LinkedHashMap(), resources);
    }

    public EngineResults(List<RuleCombination> skippedBecauseOfLicenceRules, LinkedHashMap<T, LiquibaseQualityCheckResult> results, List<Resource> resources) {
        this.skippedBecauseOfLicenceRules = skippedBecauseOfLicenceRules;
        this.results = results;
        this.resources = resources;
    }

    public List<RuleCombination> getSkippedBecauseOfLicenceRules() {
        return this.skippedBecauseOfLicenceRules;
    }

    public List<RuleCombination> getSkippedBecauseOfLicenceRules(String checkSettingsConfigFilename) {
        return this.skippedBecauseOfLicenceRules.stream().filter(rc -> {
            AbstractConfigurableRule configurableRule = rc.configurableRule;
            return configurableRule.checkSettingsConfigFilenameMatches(checkSettingsConfigFilename);
        }).collect(Collectors.toList());
    }

    public void addResults(EngineResults<T> mergeFrom) {
        LinkedHashMap<T, LiquibaseQualityCheckResult> mergeFromResults = mergeFrom.getResults();
        for (Map.Entry<T, LiquibaseQualityCheckResult> entry : mergeFromResults.entrySet()) {
            LiquibaseQualityCheckResult mergeToResult = this.getResults().get(entry.getKey());
            if (mergeToResult == null) continue;
            List<LiquibaseRuleResult> resultsToAdd = entry.getValue().getRuleResults();
            mergeToResult.addResults(resultsToAdd);
            mergeToResult.addExecutedRules(entry.getValue().getExecutedRules());
        }
    }

    public LinkedHashMap<T, LiquibaseQualityCheckResult> getResults() {
        return this.results;
    }

    public LinkedHashSet<String> getAllChecksSettingsConfigFilenames() {
        return this.resources.stream().map(Resource::getPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<RuleCombination> getExecutedRules() {
        LinkedHashSet<RuleCombination> executedRuleNames = new LinkedHashSet<RuleCombination>();
        this.getResults().forEach((changeSet, changeSetCheckResult) -> executedRuleNames.addAll(changeSetCheckResult.getExecutedRules()));
        return executedRuleNames;
    }

    public Set<RuleCombination> getExecutedRules(String checkSettingsConfigFilename) {
        LinkedHashSet<RuleCombination> executedRuleNames = new LinkedHashSet<RuleCombination>();
        this.getResults().forEach((changeSet, changeSetCheckResult) -> executedRuleNames.addAll(changeSetCheckResult.getExecutedRules(checkSettingsConfigFilename)));
        return executedRuleNames;
    }
}

