/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Arrays;
import java.util.Locale;
import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.core.Table;
import liquibase.util.ValueHandlerUtil;

public class DatabaseChangelogHistoryConfiguration
implements AutoloadedConfigurations {
    private static final ConfigurationDefinition<Boolean> ENABLED;
    private static final ConfigurationDefinition<String> TABLE_NAME;
    public static final ConfigurationDefinition<Integer> SEVERITY;
    public static final ConfigurationDefinition<Boolean> CAPTURE_SQL;
    public static final ConfigurationDefinition<Boolean> CAPTURE_EXTENSIONS;
    private static final String DEFAULT_TABLE_NAME = "DATABASECHANGELOGHISTORY";

    public static String getTableName(Database database) {
        String tableName = (String)TABLE_NAME.getCurrentValue();
        if (database instanceof PostgresDatabase) {
            tableName = tableName.toLowerCase(Locale.US);
        }
        return database.correctObjectName(tableName, Table.class);
    }

    public static boolean isHistoryEnabled() {
        return LicenseServiceUtils.isProLicenseValid() && Boolean.TRUE.equals(ENABLED.getCurrentValue());
    }

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase");
        ENABLED = builder.define("dbclhistory.enabled", Boolean.class).setDescription(ProStringUtil.markWithPro("This property enables Liquibase Pro users to store a record of all database changing liquibase operations in a new table DATABASECHANGELOGHISTORY. This table includes records of rollback, dropalls, and repeated runOnChange type activity, which is not available in the standard DATABASECHANGELOG table.")).setDefaultValue((Object)false).addAliasKey("databasechangeloghistory.enabled").build();
        TABLE_NAME = builder.define("dbclhistory.tableName", String.class).setHidden(true).setDefaultValue((Object)DEFAULT_TABLE_NAME).addAliasKey("databasechangeloghistory.tableName").build();
        SEVERITY = builder.define("dbclhistory.severity", Integer.class).setDefaultValue((Object)1).setValueHandler(input -> ValueHandlerUtil.getIntegerWithConstraints((Object)input, (String)"The severity must be set to one of the allowed values: ", Arrays.asList(0, 1, 2, 3, 4))).addAliasKey("databasechangeloghistory.severity").setDescription("The exit code to use if an exception is encountered while recording history events").build();
        CAPTURE_SQL = builder.define("dbclhistory.captureSql", Boolean.class).setDefaultValue((Object)true).setValueHandler(ValueHandlerUtil::booleanValueHandler).addAliasKey("databasechangeloghistory.captureSql").setDescription("If true, executed SQL is captured in the history table").build();
        CAPTURE_EXTENSIONS = builder.define("dbclhistory.captureExtensions", Boolean.class).setDefaultValue((Object)true).setValueHandler(ValueHandlerUtil::booleanValueHandler).addAliasKey("dbclhistory.captureExts").addAliasKey("databasechangeloghistory.captureExtensions").addAliasKey("databasechangeloghistory.captureExts").setDescription("If true, extensions are captured in the history table").build();
    }
}

