/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DisableCheckConstraintStatement;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DisableCheckConstraintGenerator
extends AbstractSqlGenerator<DisableCheckConstraintStatement> {
    public boolean supports(DisableCheckConstraintStatement disableCheckConstraintStatement, Database database) {
        return (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database) && !(database instanceof Db2zDatabase);
    }

    public ValidationErrors validate(DisableCheckConstraintStatement disableCheckConstraintStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)disableCheckConstraintStatement.getTableName());
        validationErrors.checkRequiredField("constraintName", (Object)disableCheckConstraintStatement.getConstraintName());
        return validationErrors;
    }

    public Sql[] generateSql(DisableCheckConstraintStatement disableCheckConstraintStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(database.escapeTableName(disableCheckConstraintStatement.getCatalogName(), disableCheckConstraintStatement.getSchemaName(), disableCheckConstraintStatement.getTableName()));
        if (database instanceof OracleDatabase) {
            sql.append(" DISABLE CONSTRAINT ").append(disableCheckConstraintStatement.getConstraintName());
        } else if (database instanceof AbstractDb2Database) {
            sql.append(" ALTER CHECK ").append(disableCheckConstraintStatement.getConstraintName()).append(" NOT ENFORCED");
        } else {
            sql.append(" NOCHECK CONSTRAINT ").append(disableCheckConstraintStatement.getConstraintName());
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

