/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;

public class MissingStoredProcedureChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (StoredProcedure.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        StoredProcedure storedProcedure = (StoredProcedure)databaseObject;
        CreateProcedureChange createProcedureChange = new CreateProcedureChange();
        createProcedureChange.setProcedureText(storedProcedure.getBody());
        createProcedureChange.setProcedureName(storedProcedure.getName());
        if (diffOutputControl.getIncludeCatalog()) {
            createProcedureChange.setCatalogName(storedProcedure.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            createProcedureChange.setSchemaName(storedProcedure.getSchema().getName());
        }
        if (database instanceof MSSQLDatabase && !storedProcedure.getBody().toUpperCase().contains("AS EXTERNAL NAME")) {
            createProcedureChange.setReplaceIfExists(Boolean.valueOf(true));
        }
        return MissingStoredProcedureChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{createProcedureChange});
    }
}

