/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.difflib.patch;

import java.util.List;
import liquibase.repackaged.com.github.difflib.patch.AbstractDelta;
import liquibase.repackaged.com.github.difflib.patch.Chunk;
import liquibase.repackaged.com.github.difflib.patch.DeltaType;
import liquibase.repackaged.com.github.difflib.patch.PatchFailedException;

public final class InsertDelta<T>
extends AbstractDelta<T> {
    public InsertDelta(Chunk<T> original, Chunk<T> revised) {
        super(DeltaType.INSERT, original, revised);
    }

    @Override
    protected void applyTo(List<T> target) throws PatchFailedException {
        int position = this.getSource().getPosition();
        List lines = this.getTarget().getLines();
        for (int i = 0; i < lines.size(); ++i) {
            target.add(position + i, lines.get(i));
        }
    }

    @Override
    protected void restore(List<T> target) {
        int position = this.getTarget().getPosition();
        int size = this.getTarget().size();
        for (int i = 0; i < size; ++i) {
            target.remove(position);
        }
    }

    public String toString() {
        return "[InsertDelta, position: " + this.getSource().getPosition() + ", lines: " + this.getTarget().getLines() + "]";
    }

    @Override
    public AbstractDelta<T> withChunks(Chunk<T> original, Chunk<T> revised) {
        return new InsertDelta<T>(original, revised);
    }
}

