/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.expression.MySQLIndexHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.SQLServerHints;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Database;
import liquibase.repackaged.net.sf.jsqlparser.schema.MultiPartName;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.IntoTableVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Pivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SampleClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.UnPivot;

public class Table
extends ASTNodeAccessImpl
implements FromItem,
MultiPartName {
    private static final int NAME_IDX = 0;
    private static final int SCHEMA_IDX = 1;
    private static final int DATABASE_IDX = 2;
    private static final int SERVER_IDX = 3;
    private List<String> partItems = new ArrayList<String>();
    private Alias alias;
    private SampleClause sampleClause;
    private Pivot pivot;
    private UnPivot unpivot;
    private MySQLIndexHint mysqlHints;
    private SQLServerHints sqlServerHints;

    public Table() {
    }

    public Table(String name) {
        this.setName(name);
    }

    public Table(String schemaName, String name) {
        this.setName(name);
        this.setSchemaName(schemaName);
    }

    public Table(Database database, String schemaName, String name) {
        this.setName(name);
        this.setSchemaName(schemaName);
        this.setDatabase(database);
    }

    public Table(List<String> partItems) {
        this.partItems = new ArrayList<String>(partItems);
        Collections.reverse(this.partItems);
    }

    public Database getDatabase() {
        return new Database(this.getIndex(2));
    }

    public Table withDatabase(Database database) {
        this.setDatabase(database);
        return this;
    }

    public void setDatabase(Database database) {
        this.setIndex(2, database.getDatabaseName());
        if (database.getServer() != null) {
            this.setIndex(3, database.getServer().getFullyQualifiedName());
        }
    }

    public String getSchemaName() {
        return this.getIndex(1);
    }

    public Table withSchemaName(String schemaName) {
        this.setSchemaName(schemaName);
        return this;
    }

    public void setSchemaName(String schemaName) {
        this.setIndex(1, schemaName);
    }

    public String getName() {
        int pos;
        String name = this.getIndex(0);
        if (name != null && name.contains("@") && (pos = name.lastIndexOf(64)) > 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public String getDBLinkName() {
        int pos;
        String name = this.getIndex(0);
        if (name != null && name.contains("@") && (pos = name.lastIndexOf(64)) > 0 && name.length() > 1) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    public Table withName(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        this.setIndex(0, name);
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    private void setIndex(int idx, String value) {
        int size = this.partItems.size();
        for (int i = 0; i < idx - size + 1; ++i) {
            this.partItems.add(null);
        }
        if (value == null && idx == this.partItems.size() - 1) {
            this.partItems.remove(idx);
        } else {
            this.partItems.set(idx, value);
        }
    }

    private String getIndex(int idx) {
        if (idx < this.partItems.size()) {
            return this.partItems.get(idx);
        }
        return null;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder fqn = new StringBuilder();
        for (int i = this.partItems.size() - 1; i >= 0; --i) {
            String part = this.partItems.get(i);
            if (part == null) {
                part = "";
            }
            fqn.append(part);
            if (i == 0) continue;
            fqn.append(".");
        }
        return fqn.toString();
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public void accept(IntoTableVisitor intoTableVisitor) {
        intoTableVisitor.visit(this);
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    @Override
    public UnPivot getUnPivot() {
        return this.unpivot;
    }

    @Override
    public void setUnPivot(UnPivot unpivot) {
        this.unpivot = unpivot;
    }

    public MySQLIndexHint getIndexHint() {
        return this.mysqlHints;
    }

    public Table withHint(MySQLIndexHint hint) {
        this.setHint(hint);
        return this;
    }

    public void setHint(MySQLIndexHint hint) {
        this.mysqlHints = hint;
    }

    public SQLServerHints getSqlServerHints() {
        return this.sqlServerHints;
    }

    public void setSqlServerHints(SQLServerHints sqlServerHints) {
        this.sqlServerHints = sqlServerHints;
    }

    public SampleClause getSampleClause() {
        return this.sampleClause;
    }

    public Table setSampleClause(SampleClause sampleClause) {
        this.sampleClause = sampleClause;
        return this;
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append(this.getFullyQualifiedName());
        if (this.alias != null) {
            builder.append(this.alias);
        }
        if (this.sampleClause != null) {
            this.sampleClause.appendTo(builder);
        }
        if (this.pivot != null) {
            builder.append(" ").append(this.pivot);
        }
        if (this.unpivot != null) {
            builder.append(" ").append(this.unpivot);
        }
        if (this.mysqlHints != null) {
            builder.append(this.mysqlHints);
        }
        if (this.sqlServerHints != null) {
            builder.append(this.sqlServerHints);
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public Table withUnPivot(UnPivot unpivot) {
        return (Table)FromItem.super.withUnPivot(unpivot);
    }

    @Override
    public Table withAlias(Alias alias) {
        return (Table)FromItem.super.withAlias(alias);
    }

    @Override
    public Table withPivot(Pivot pivot) {
        return (Table)FromItem.super.withPivot(pivot);
    }

    public Table withSqlServerHints(SQLServerHints sqlServerHints) {
        this.setSqlServerHints(sqlServerHints);
        return this;
    }

    public List<String> getNameParts() {
        return this.partItems;
    }
}

