/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationException;

public class ValidationError {
    private final String statements;
    private Statement parsedStatement;
    private Set<ValidationException> errors = new HashSet<ValidationException>();
    private ValidationCapability capability;

    public ValidationError(String statements) {
        this.statements = statements;
    }

    public ValidationError addError(ValidationException error) {
        this.errors.add(error);
        return this;
    }

    public ValidationError addErrors(Collection<ValidationException> errors) {
        this.errors.addAll(errors);
        return this;
    }

    public Set<ValidationException> getErrors() {
        return this.errors;
    }

    public ValidationCapability getCapability() {
        return this.capability;
    }

    public Statement getParsedStatement() {
        return this.parsedStatement;
    }

    public String getStatements() {
        return this.statements;
    }

    public void setCapability(ValidationCapability databaseType) {
        this.capability = databaseType;
    }

    public void setParsedStatement(Statement parsedStatement) {
        this.parsedStatement = parsedStatement;
    }

    public ValidationError withCapability(ValidationCapability databaseType) {
        this.setCapability(databaseType);
        return this;
    }

    public ValidationError withParsedStatement(Statement parsedStatement) {
        this.setParsedStatement(parsedStatement);
        return this;
    }

    public String toString() {
        return "ValidationError [\nstatement=" + this.statements + "\ncapability=" + (this.capability != null ? this.capability.getName() : "<null>") + "\nerrors=" + this.errors + "\n]";
    }
}

