/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.io.Sink;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.io.Transformation;

@Immutable
final class V1Compression
implements Transformation {
    V1Compression() {
    }

    @Override
    public Sink apply(final Sink sink) {
        return new Sink(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OutputStream output() throws IOException {
                OutputStream outputStream = sink.output();
                try {
                    return new GZIPOutputStream(outputStream, 8192);
                }
                catch (IOException iOException) {
                    try {
                        outputStream.close();
                    }
                    finally {
                        throw iOException;
                    }
                }
            }
        };
    }

    @Override
    public Source unapply(final Source source) {
        return new Source(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputStream input() throws IOException {
                InputStream inputStream = source.input();
                try {
                    return new GZIPInputStream(inputStream, 8192);
                }
                catch (IOException iOException) {
                    try {
                        inputStream.close();
                    }
                    finally {
                        throw iOException;
                    }
                }
            }
        };
    }
}

