/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.io;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import net.java.truelicense.core.io.Source;

public class Sources {
    public static Source input() {
        return Sources.uncloseable(System.in);
    }

    public static Source uncloseable(final InputStream inputStream) {
        return new Source(){

            @Override
            public InputStream input() {
                return new FilterInputStream(inputStream){

                    @Override
                    public void close() throws IOException {
                    }
                };
            }
        };
    }

    public static Source forResource(final String string, final Class<?> clazz) {
        return new Source(){

            @Override
            public InputStream input() throws IOException {
                return Sources.check(clazz.getResourceAsStream(string), string);
            }
        };
    }

    public static Source forResource(final String string, final @CheckForNull ClassLoader classLoader) {
        return new Source(){

            @Override
            public InputStream input() throws IOException {
                return Sources.check(null != classLoader ? classLoader.getResourceAsStream(string) : ClassLoader.getSystemResourceAsStream(string), string);
            }
        };
    }

    static InputStream check(@CheckForNull InputStream inputStream, String string) throws FileNotFoundException {
        if (null == inputStream) {
            throw new FileNotFoundException(string);
        }
        return inputStream;
    }

    private Sources() {
    }
}

