/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.config.CompositeOperation;
import org.ocpsoft.rewrite.config.ConditionVisit;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationVisit;
import org.ocpsoft.rewrite.config.ParameterizedCallback;
import org.ocpsoft.rewrite.config.ParameterizedConditionVisitor;
import org.ocpsoft.rewrite.config.ParameterizedOperationVisitor;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleBuilder;
import org.ocpsoft.rewrite.context.ContextBase;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.context.RewriteState;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.Transposition;
import org.ocpsoft.rewrite.util.ParameterUtils;

public class Subset
extends DefaultOperationBuilder
implements CompositeOperation,
Parameterized {
    private static Logger log = Logger.getLogger(Subset.class);
    private final Configuration config;

    private Subset(Configuration config) {
        Assert.notNull(config, "Configuration must not be null.");
        this.config = config;
    }

    public static Subset evaluate(Configuration config) {
        return new Subset(config);
    }

    @Override
    public void perform(Rewrite rewrite, EvaluationContext context) {
        Rewrite event = rewrite;
        ArrayList<Rule> cacheable = new ArrayList<Rule>();
        List<Rule> rules = this.config.getRules();
        EvaluationContextImpl subContext = new EvaluationContextImpl();
        for (int i = 0; i < rules.size(); ++i) {
            Rule rule = rules.get(i);
            subContext.clear();
            subContext.put(ParameterStore.class, context.get(ParameterStore.class));
            ParameterValueStore values = (ParameterValueStore)context.get(ParameterValueStore.class);
            subContext.put(ParameterValueStore.class, values);
            subContext.setState(RewriteState.EVALUATING);
            if (!rule.evaluate(event, subContext) || !this.handleBindings(event, subContext, values)) continue;
            subContext.setState(RewriteState.PERFORMING);
            log.debug("Rule [" + rule + "] matched and will be performed.");
            cacheable.add(rule);
            List<Operation> preOperations = subContext.getPreOperations();
            for (int k = 0; k < preOperations.size(); ++k) {
                preOperations.get(k).perform(event, subContext);
            }
            if (event.getFlow().isHandled()) break;
            rule.perform(event, subContext);
            if (event.getFlow().isHandled()) break;
            List<Operation> postOperations = subContext.getPostOperations();
            for (int k = 0; k < postOperations.size(); ++k) {
                postOperations.get(k).perform(event, subContext);
            }
            if (event.getFlow().isHandled()) break;
        }
    }

    private boolean handleBindings(Rewrite event, EvaluationContextImpl context, ParameterValueStore values) {
        boolean result = true;
        ParameterStore store = (ParameterStore)context.get(ParameterStore.class);
        for (Map.Entry entry : store) {
            String value;
            Parameter parameter = (Parameter)entry.getValue();
            if (ParameterUtils.enqueueSubmission(event, context, parameter, value = values.retrieve(parameter))) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public List<Operation> getOperations() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        return Collections.emptySet();
    }

    @Override
    public void setParameterStore(final ParameterStore parent) {
        for (final Rule rule : this.config.getRules()) {
            if (!(rule instanceof RuleBuilder)) continue;
            ParameterizedCallback callback = new ParameterizedCallback(){

                @Override
                public void call(Parameterized parameterized) {
                    Set<String> names = parameterized.getRequiredParameterNames();
                    if (rule instanceof RuleBuilder) {
                        ParameterStore store = ((RuleBuilder)rule).getParameterStore();
                        for (Map.Entry entry : parent) {
                            String name = (String)entry.getKey();
                            Parameter parentParam = (Parameter)entry.getValue();
                            if (!store.contains(name)) {
                                store.get(name, parentParam);
                                continue;
                            }
                            Parameter<?> parameter = store.get(name);
                            for (Binding binding : parameter.getBindings()) {
                                if (parentParam.getBindings().contains(binding)) continue;
                                this.throwRedefinitionError(rule, name);
                            }
                            for (Constraint constraint : parameter.getConstraints()) {
                                if (parentParam.getConstraints().contains(constraint)) continue;
                                this.throwRedefinitionError(rule, name);
                            }
                            for (Transposition transposition : parameter.getTranspositions()) {
                                if (parentParam.getTranspositions().contains(transposition)) continue;
                                this.throwRedefinitionError(rule, name);
                            }
                            if (parentParam.getConverter() != null && !parentParam.getConverter().equals(parameter.getConverter())) {
                                this.throwRedefinitionError(rule, name);
                            }
                            if (parentParam.getValidator() == null || parentParam.getValidator().equals(parameter.getValidator())) continue;
                            this.throwRedefinitionError(rule, name);
                        }
                        for (String name : names) {
                            Parameter<?> parameter = store.get(name, new DefaultParameter(name));
                            if (!(parameter instanceof ConfigurableParameter)) continue;
                            ((ConfigurableParameter)parameter).bindsTo(Evaluation.property(name));
                        }
                        parameterized.setParameterStore(store);
                    }
                }

                private void throwRedefinitionError(Rule rule2, String name) {
                    throw new IllegalStateException("Subset cannot re-configure parameter [" + name + "] that was configured in parent Configuration. Re-definition was attempted at [" + rule2 + "] ");
                }
            };
            ParameterizedConditionVisitor conditionVisitor = new ParameterizedConditionVisitor(callback);
            new ConditionVisit(rule).accept(conditionVisitor);
            ParameterizedOperationVisitor operationVisitor = new ParameterizedOperationVisitor(callback);
            new OperationVisit(rule).accept(operationVisitor);
        }
    }

    class EvaluationContextImpl
    extends ContextBase
    implements EvaluationContext {
        private final List<Operation> preOperations = new ArrayList<Operation>();
        private final List<Operation> postOperations = new ArrayList<Operation>();
        private RewriteState state;

        public EvaluationContextImpl() {
            this.put(ParameterStore.class, new DefaultParameterStore());
        }

        @Override
        public void addPreOperation(Operation operation) {
            this.preOperations.add(operation);
        }

        @Override
        public void addPostOperation(Operation operation) {
            this.preOperations.add(operation);
        }

        public List<Operation> getPreOperations() {
            return Collections.unmodifiableList(this.preOperations);
        }

        public List<Operation> getPostOperations() {
            return Collections.unmodifiableList(this.postOperations);
        }

        @Override
        public String toString() {
            return "EvaluationContextImpl [preOperations=" + this.preOperations + ", postOperations=" + this.postOperations + "]";
        }

        public void clear() {
            this.postOperations.clear();
            this.postOperations.clear();
        }

        @Override
        public RewriteState getState() {
            return this.state;
        }

        public void setState(RewriteState state) {
            this.state = state;
        }
    }
}

