/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.config.response.ResponseStreamWrapper;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class GZipResponseStreamWrapper
implements ResponseStreamWrapper {
    public static final String STREAM_KEY = GZipResponseStreamWrapper.class.getName() + "_STREAM";

    @Override
    public OutputStream wrap(HttpServletRewrite rewrite, OutputStream outputStream) {
        ((HttpServletResponse)rewrite.getResponse()).setHeader("Content-Encoding", "gzip");
        try {
            GZIPOutputStream stream = new GZIPOutputStream(outputStream);
            ((HttpServletRequest)rewrite.getRequest()).setAttribute(STREAM_KEY, (Object)stream);
            return stream;
        }
        catch (IOException e) {
            throw new RewriteException("Could not wrap OutputStream", e);
        }
    }

    @Override
    public void finish(HttpServletRewrite rewrite) {
        try {
            GZIPOutputStream stream = (GZIPOutputStream)((HttpServletRequest)rewrite.getRequest()).getAttribute(STREAM_KEY);
            if (stream != null) {
                stream.flush();
                stream.finish();
            }
        }
        catch (IOException e) {
            throw new RewriteException("Could not finish GZip Encoding", e);
        }
    }
}

