/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.dependencies.UpgradeDependencyVersion;
import org.openrewrite.java.dependencies.UpgradeTransitiveDependencyVersion;
import org.openrewrite.java.dependencies.Vulnerability;
import org.openrewrite.java.dependencies.internal.StaticVersionComparator;
import org.openrewrite.java.dependencies.internal.VersionParser;
import org.openrewrite.java.dependencies.table.VulnerabilityReport;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.marker.CommitMessage;
import org.openrewrite.maven.AddManagedDependency;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.xml.tree.Xml;

public final class DependencyVulnerabilityCheck
extends ScanningRecipe<Accumulator> {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    private final transient VersionParser versionParser = new VersionParser();
    private final transient VulnerabilityReport report = new VulnerabilityReport((Recipe)this);
    @Option(displayName="Scope", description="Match dependencies with the specified scope. Default is `compile`.", valid={"compile", "test", "runtime", "provided"}, example="compile", required=false)
    private final @Nullable String scope;
    @Option(displayName="Override transitives", description="When enabled transitive dependencies with vulnerabilities will have their versions overridden. By default only direct dependencies have their version numbers upgraded.", example="false", required=false)
    private final @Nullable Boolean overrideTransitive;

    public String getDisplayName() {
        return "Find and fix vulnerable dependencies";
    }

    public String getDescription() {
        return "This software composition analysis (SCA) tool detects and upgrades dependencies with publicly disclosed vulnerabilities. This recipe both generates a report of vulnerable dependencies and upgrades to newer versions with fixes. This recipe **only** upgrades to the latest **patch** version.  If a minor or major upgrade is required to reach the fixed version, this recipe will not make any changes. Vulnerability information comes from the [GitHub Security Advisory Database](https://docs.github.com/en/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database), which aggregates vulnerability data from several public databases, including the [National Vulnerability Database](https://nvd.nist.gov/) maintained by the United States government. Dependencies following [Semantic Versioning](https://semver.org/) will see their _patch_ version updated where applicable.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> {
            try {
                Scope.fromName((String)s);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }));
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        Scope parsedScope = Scope.fromName((String)this.scope);
        CsvMapper csvMapper = new CsvMapper();
        csvMapper.registerModule((Module)new JavaTimeModule());
        HashMap<GroupArtifact, List<Vulnerability>> db = new HashMap<GroupArtifact, List<Vulnerability>>();
        try (InputStream resourceAsStream = DependencyVulnerabilityCheck.class.getResourceAsStream("/advisories-maven.csv");
             MappingIterator vs = csvMapper.readerWithSchemaFor(Vulnerability.class).readValues(resourceAsStream);){
            vs.forEachRemaining(v -> {
                String[] ga = v.getGroupArtifact().split(":");
                db.computeIfAbsent(new GroupArtifact(ga[0], ga[1]), g -> new ArrayList()).add(v);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Accumulator(db, parsedScope, new UpgradeDependencyVersion("", "", "", null, null, null).getInitialValue(ctx), new UpgradeTransitiveDependencyVersion("", "", "", null, null, null, null, null, null, null, true).getInitialValue(ctx));
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                acc.repositoriesFrom((SourceFile)tree);
                DependencyVulnerabilityCheck.this.scanMaven(acc.getDb(), acc.getProjectToVulnerabilities(), acc.getScope()).visitNonNull(tree, (Object)ctx);
                DependencyVulnerabilityCheck.this.scanGradleGroovy(acc.getDb(), acc.getProjectToVulnerabilities(), acc.getScope()).visitNonNull(tree, (Object)ctx);
                new UpgradeDependencyVersion("", "", "", null, null, null).getScanner(acc.getDependencyAcc()).visit(tree, (Object)ctx);
                new UpgradeTransitiveDependencyVersion("", "", "", null, null, null, null, null, null, null, true).getScanner(acc.getTransitiveAcc()).visit(tree, (Object)ctx);
                return tree;
            }
        };
    }

    public Collection<SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        for (Map.Entry<String, Vulnerabilities> projectToVulnerabilities : acc.getProjectToVulnerabilities().entrySet()) {
            String projectName = projectToVulnerabilities.getKey();
            for (Map.Entry<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilitiesByGav : projectToVulnerabilities.getValue().getGavToVulnerabilities().entrySet()) {
                for (MinimumDepthVulnerability vDepth : vulnerabilitiesByGav.getValue()) {
                    Vulnerability v = vDepth.getVulnerability();
                    ResolvedGroupArtifactVersion gav = vulnerabilitiesByGav.getKey();
                    boolean fixWithVersionUpdateOnly = new LatestPatch(null).isValid(gav.getVersion(), v.getFixedVersion());
                    this.report.insertRow(ctx, new VulnerabilityReport.Row(projectName, v.getCve(), gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), v.getFixedVersion(), fixWithVersionUpdateOnly, v.getSummary(), v.getSeverity().toString(), vDepth.getMinDepth(), v.getCwes()));
                }
            }
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                Tree t = tree;
                Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> upgradeableVulnerabilities = acc.upgradeableVulnerabilities();
                for (Map.Entry<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> gavToUpgradeableVulnerabilities : upgradeableVulnerabilities.entrySet()) {
                    ResolvedGroupArtifactVersion gav = gavToUpgradeableVulnerabilities.getKey();
                    Set<MinimumDepthVulnerability> vulnerabilities = gavToUpgradeableVulnerabilities.getValue();
                    String versionToRequest = DependencyVulnerabilityCheck.this.versionToRequest(vulnerabilities, acc.getRepositories(), ctx);
                    Tree t2 = new UpgradeDependencyVersion(gav.getGroupId(), gav.getArtifactId(), versionToRequest, null, DependencyVulnerabilityCheck.this.overrideTransitive, null).getVisitor(acc.getDependencyAcc()).visitNonNull(t, (Object)ctx);
                    String because = null;
                    if (t2 == t) {
                        because = DependencyVulnerabilityCheck.because(vulnerabilities);
                        t2 = new UpgradeTransitiveDependencyVersion(gav.getGroupId(), gav.getArtifactId(), versionToRequest, DependencyVulnerabilityCheck.this.scope, null, null, null, because, null, null, true).getVisitor(acc.getTransitiveAcc()).visitNonNull(t2, (Object)ctx);
                    }
                    if ((t = t2) == tree) continue;
                    if (because == null) {
                        because = DependencyVulnerabilityCheck.because(vulnerabilities);
                    }
                    CommitMessage.message((Tree)t2, (Recipe)DependencyVulnerabilityCheck.this, (String)because);
                }
                return t;
            }
        };
    }

    private String versionToRequest(Set<MinimumDepthVulnerability> vulnerabilities, List<MavenRepository> repositories, ExecutionContext ctx) {
        StaticVersionComparator vc = new StaticVersionComparator();
        Vulnerability highestFix = vulnerabilities.stream().max(Comparator.comparing(it -> this.versionParser.transform(DependencyVulnerabilityCheck.stripExtraneousVersionSuffix(it.getVulnerability().getFixedVersion())), vc)).map(MinimumDepthVulnerability::getVulnerability).orElse(null);
        if (highestFix != null) {
            String[] groupArtifact = highestFix.getGroupArtifact().split(":");
            String groupId = groupArtifact[0];
            String artifactId = groupArtifact[1];
            try {
                MavenMetadata metadata = this.metadataFailures.insertRows(ctx, () -> new MavenPomDownloader(ctx).downloadMetadata(new GroupArtifact(groupId, artifactId), null, repositories));
                List versions = metadata.getVersioning().getVersions();
                if (versions.contains(highestFix.getFixedVersion())) {
                    return highestFix.getFixedVersion();
                }
            }
            catch (MavenDownloadingException e) {
                return "latest.patch";
            }
        }
        return "latest.patch";
    }

    private static @Nullable String because(Collection<MinimumDepthVulnerability> reasons) {
        String because = reasons.stream().map(MinimumDepthVulnerability::getVulnerability).map(Vulnerability::getCve).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.joining(", "));
        return StringUtils.isBlank((String)because) ? null : because;
    }

    private MavenVisitor<ExecutionContext> scanMaven(final Map<GroupArtifact, List<Vulnerability>> db, final Map<String, Vulnerabilities> projectToVulnerabilities, final Scope aScope) {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                List scopeDependencies = (List)this.getResolutionResult().getDependencies().get(aScope);
                if (scopeDependencies != null) {
                    String projectName = DependencyVulnerabilityCheck.projectName((Tree)document);
                    for (ResolvedDependency resolvedDependency : scopeDependencies) {
                        DependencyVulnerabilityCheck.this.analyzeDependency(db, projectToVulnerabilities.computeIfAbsent(projectName, p -> new Vulnerabilities(new LinkedHashMap<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>>())), resolvedDependency);
                    }
                }
                return document;
            }
        };
    }

    private static String projectName(Tree t) {
        return t.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
    }

    private static boolean scopeExcludesConfiguration(GradleDependencyConfiguration configuration, Scope scope) {
        switch (scope) {
            case Test: {
                return !configuration.getName().contains("test");
            }
            case Compile: 
            case Runtime: {
                return configuration.getName().contains("test");
            }
            case Provided: {
                return !configuration.getName().contains("provided") && !configuration.getName().contains("compileOnly");
            }
        }
        return false;
    }

    private GroovyVisitor<ExecutionContext> scanGradleGroovy(final Map<GroupArtifact, List<Vulnerability>> db, final Map<String, Vulnerabilities> projectToVulnerabilities, final Scope aScope) {
        return new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                cu.getMarkers().findFirst(GradleProject.class).ifPresent(gradleProject -> {
                    String projectName = DependencyVulnerabilityCheck.projectName((Tree)cu);
                    for (GradleDependencyConfiguration configuration : gradleProject.getConfigurations()) {
                        if (DependencyVulnerabilityCheck.scopeExcludesConfiguration(configuration, aScope)) continue;
                        for (ResolvedDependency resolvedDependency : configuration.getResolved()) {
                            if (StringUtils.isBlank((String)resolvedDependency.getVersion())) continue;
                            DependencyVulnerabilityCheck.this.analyzeDependency(db, projectToVulnerabilities.computeIfAbsent(projectName, p -> new Vulnerabilities(new LinkedHashMap<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>>())), resolvedDependency);
                        }
                    }
                });
                return cu;
            }
        };
    }

    private void analyzeDependency(Map<GroupArtifact, List<Vulnerability>> db, Vulnerabilities vulnerabilities, ResolvedDependency resolvedDependency) {
        List<Vulnerability> vs = db.get(new GroupArtifact(resolvedDependency.getGroupId(), resolvedDependency.getArtifactId()));
        if (vs != null) {
            Set<MinimumDepthVulnerability> gavVs = null;
            StaticVersionComparator vc = new StaticVersionComparator();
            block0: for (Vulnerability v : vs) {
                boolean isLessThanFixed = StringUtils.isBlank((String)v.getFixedVersion());
                if (!isLessThanFixed && vc.compare(this.versionParser.transform(DependencyVulnerabilityCheck.stripExtraneousVersionSuffix(v.getFixedVersion())), this.versionParser.transform(DependencyVulnerabilityCheck.stripExtraneousVersionSuffix(resolvedDependency.getVersion()))) > 0) {
                    isLessThanFixed = true;
                }
                if (!isLessThanFixed || vc.compare(this.versionParser.transform(DependencyVulnerabilityCheck.stripExtraneousVersionSuffix(v.getIntroducedVersion())), this.versionParser.transform(DependencyVulnerabilityCheck.stripExtraneousVersionSuffix(resolvedDependency.getVersion()))) > 0) continue;
                if (gavVs == null) {
                    gavVs = vulnerabilities.computeIfAbsent(resolvedDependency.getGav(), ga -> new TreeSet<MinimumDepthVulnerability>(Comparator.comparing(vDep -> vDep.getVulnerability().getSeverity()).reversed().thenComparing(vDep -> vDep.getVulnerability().getCve())));
                }
                for (MinimumDepthVulnerability vDep : gavVs) {
                    if (!vDep.getVulnerability().equals(v)) continue;
                    vDep.minDepth = Math.min(vDep.minDepth, resolvedDependency.getDepth());
                    continue block0;
                }
                gavVs.add(new MinimumDepthVulnerability(resolvedDependency.getDepth(), v));
            }
        }
    }

    private static String stripExtraneousVersionSuffix(String version) {
        if (version.endsWith(".RELEASE")) {
            return version.substring(0, version.length() - ".RELEASE".length());
        }
        return version;
    }

    @ConstructorProperties(value={"scope", "overrideTransitive"})
    @Generated
    public DependencyVulnerabilityCheck(@Nullable String scope, @Nullable Boolean overrideTransitive) {
        this.scope = scope;
        this.overrideTransitive = overrideTransitive;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public VersionParser getVersionParser() {
        return this.versionParser;
    }

    @Generated
    public VulnerabilityReport getReport() {
        return this.report;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable Boolean getOverrideTransitive() {
        return this.overrideTransitive;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyVulnerabilityCheck(metadataFailures=" + this.getMetadataFailures() + ", versionParser=" + this.getVersionParser() + ", report=" + (Object)((Object)this.getReport()) + ", scope=" + this.getScope() + ", overrideTransitive=" + this.getOverrideTransitive() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyVulnerabilityCheck)) {
            return false;
        }
        DependencyVulnerabilityCheck other = (DependencyVulnerabilityCheck)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideTransitive = this.getOverrideTransitive();
        Boolean other$overrideTransitive = other.getOverrideTransitive();
        if (this$overrideTransitive == null ? other$overrideTransitive != null : !((Object)this$overrideTransitive).equals(other$overrideTransitive)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyVulnerabilityCheck;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideTransitive = this.getOverrideTransitive();
        result = result * 59 + ($overrideTransitive == null ? 43 : ((Object)$overrideTransitive).hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    public static final class Vulnerabilities {
        private final Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> gavToVulnerabilities;

        public Set<MinimumDepthVulnerability> computeIfAbsent(ResolvedGroupArtifactVersion gav, Function<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> mappingFunction) {
            return this.gavToVulnerabilities.computeIfAbsent(gav, mappingFunction);
        }

        @ConstructorProperties(value={"gavToVulnerabilities"})
        @Generated
        public Vulnerabilities(Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> gavToVulnerabilities) {
            this.gavToVulnerabilities = gavToVulnerabilities;
        }

        @Generated
        public Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> getGavToVulnerabilities() {
            return this.gavToVulnerabilities;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vulnerabilities)) {
                return false;
            }
            Vulnerabilities other = (Vulnerabilities)o;
            Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> this$gavToVulnerabilities = this.getGavToVulnerabilities();
            Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> other$gavToVulnerabilities = other.getGavToVulnerabilities();
            return !(this$gavToVulnerabilities == null ? other$gavToVulnerabilities != null : !((Object)this$gavToVulnerabilities).equals(other$gavToVulnerabilities));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> $gavToVulnerabilities = this.getGavToVulnerabilities();
            result = result * 59 + ($gavToVulnerabilities == null ? 43 : ((Object)$gavToVulnerabilities).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyVulnerabilityCheck.Vulnerabilities(gavToVulnerabilities=" + this.getGavToVulnerabilities() + ")";
        }
    }

    public static class Accumulator {
        final Map<GroupArtifact, List<Vulnerability>> db;
        final Scope scope;
        final UpgradeDependencyVersion.Accumulator dependencyAcc;
        final AddManagedDependency.Scanned transitiveAcc;
        Map<String, Vulnerabilities> projectToVulnerabilities = new LinkedHashMap<String, Vulnerabilities>();
        private Set<MavenRepository> repositories = new LinkedHashSet<MavenRepository>();
        private @Nullable List<MavenRepository> allRepositories = null;
        private @Nullable Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> upgradeableVulnerabilities = null;

        public void repositoriesFrom(SourceFile s) {
            s.getMarkers().findFirst(MavenResolutionResult.class).ifPresent(mrr -> this.repositories.addAll(mrr.getPom().getRepositories()));
            s.getMarkers().findFirst(GradleProject.class).ifPresent(gradleProject -> this.repositories.addAll(gradleProject.getMavenRepositories()));
        }

        public List<MavenRepository> getRepositories() {
            if (this.allRepositories == null) {
                this.allRepositories = new ArrayList<MavenRepository>(this.repositories);
            }
            return this.allRepositories;
        }

        public Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> upgradeableVulnerabilities() {
            if (this.upgradeableVulnerabilities == null) {
                this.upgradeableVulnerabilities = new LinkedHashMap<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>>();
                for (Vulnerabilities vuln : this.projectToVulnerabilities.values()) {
                    for (Map.Entry<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> resolvedGroupArtifactVersionSetEntry : vuln.getGavToVulnerabilities().entrySet()) {
                        ResolvedGroupArtifactVersion gav = resolvedGroupArtifactVersionSetEntry.getKey();
                        Set<MinimumDepthVulnerability> vulnerabilities = resolvedGroupArtifactVersionSetEntry.getValue();
                        this.upgradeableVulnerabilities.compute(gav, (k, upgradeableSoFar) -> {
                            Set newUpgradableVulnerabilities = vulnerabilities.stream().filter(it -> StringUtils.isNotEmpty((String)((MinimumDepthVulnerability)it).vulnerability.getFixedVersion())).filter(it -> new LatestPatch(null).isValid(gav.getVersion(), ((MinimumDepthVulnerability)it).vulnerability.getFixedVersion())).collect(Collectors.toCollection(LinkedHashSet::new));
                            if (newUpgradableVulnerabilities.isEmpty()) {
                                return upgradeableSoFar;
                            }
                            if (upgradeableSoFar == null) {
                                upgradeableSoFar = newUpgradableVulnerabilities;
                            } else {
                                upgradeableSoFar.addAll(newUpgradableVulnerabilities);
                            }
                            return upgradeableSoFar;
                        });
                    }
                }
            }
            return this.upgradeableVulnerabilities;
        }

        @Generated
        public Map<GroupArtifact, List<Vulnerability>> getDb() {
            return this.db;
        }

        @Generated
        public Scope getScope() {
            return this.scope;
        }

        @Generated
        public UpgradeDependencyVersion.Accumulator getDependencyAcc() {
            return this.dependencyAcc;
        }

        @Generated
        public AddManagedDependency.Scanned getTransitiveAcc() {
            return this.transitiveAcc;
        }

        @Generated
        public Map<String, Vulnerabilities> getProjectToVulnerabilities() {
            return this.projectToVulnerabilities;
        }

        @Generated
        public @Nullable List<MavenRepository> getAllRepositories() {
            return this.allRepositories;
        }

        @Generated
        public @Nullable Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> getUpgradeableVulnerabilities() {
            return this.upgradeableVulnerabilities;
        }

        @ConstructorProperties(value={"db", "scope", "dependencyAcc", "transitiveAcc"})
        @Generated
        public Accumulator(Map<GroupArtifact, List<Vulnerability>> db, Scope scope, UpgradeDependencyVersion.Accumulator dependencyAcc, AddManagedDependency.Scanned transitiveAcc) {
            this.db = db;
            this.scope = scope;
            this.dependencyAcc = dependencyAcc;
            this.transitiveAcc = transitiveAcc;
        }
    }

    public static final class MinimumDepthVulnerability {
        private int minDepth;
        private final Vulnerability vulnerability;

        @ConstructorProperties(value={"minDepth", "vulnerability"})
        @Generated
        public MinimumDepthVulnerability(int minDepth, Vulnerability vulnerability) {
            this.minDepth = minDepth;
            this.vulnerability = vulnerability;
        }

        @Generated
        public int getMinDepth() {
            return this.minDepth;
        }

        @Generated
        public Vulnerability getVulnerability() {
            return this.vulnerability;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MinimumDepthVulnerability)) {
                return false;
            }
            MinimumDepthVulnerability other = (MinimumDepthVulnerability)o;
            if (this.getMinDepth() != other.getMinDepth()) {
                return false;
            }
            Vulnerability this$vulnerability = this.getVulnerability();
            Vulnerability other$vulnerability = other.getVulnerability();
            return !(this$vulnerability == null ? other$vulnerability != null : !((Object)this$vulnerability).equals(other$vulnerability));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinDepth();
            Vulnerability $vulnerability = this.getVulnerability();
            result = result * 59 + ($vulnerability == null ? 43 : ((Object)$vulnerability).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyVulnerabilityCheck.MinimumDepthVulnerability(minDepth=" + this.getMinDepth() + ", vulnerability=" + this.getVulnerability() + ")";
        }
    }
}

