/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp.dependencies.trait;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.trait.Trait;
import org.openrewrite.xml.ChangeTagAttribute;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class PackageReference
implements Trait<Xml.Tag> {
    private final Cursor cursor;
    private final String include;
    private final String version;

    public Xml.Tag withVersion(String newVersion) {
        Xml.Tag tag = (Xml.Tag)this.getTree();
        if (!Objects.equals(this.version, newVersion)) {
            InMemoryExecutionContext ctx = new InMemoryExecutionContext();
            tag = (Xml.Tag)new ChangeTagAttribute("//PackageReference", "Version", newVersion, this.version, null).getVisitor().visitNonNull((Tree)tag, (Object)ctx);
            tag = (Xml.Tag)new ChangeTagAttribute("//package", "version", newVersion, this.version, null).getVisitor().visitNonNull((Tree)tag, (Object)ctx);
        }
        return tag;
    }

    @ConstructorProperties(value={"cursor", "include", "version"})
    @Generated
    public PackageReference(Cursor cursor, String include, String version) {
        this.cursor = cursor;
        this.include = include;
        this.version = version;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public String getInclude() {
        return this.include;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackageReference)) {
            return false;
        }
        PackageReference other = (PackageReference)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        String this$include = this.getInclude();
        String other$include = other.getInclude();
        if (this$include == null ? other$include != null : !this$include.equals(other$include)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        String $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : $include.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "PackageReference(cursor=" + this.getCursor() + ", include=" + this.getInclude() + ", version=" + this.getVersion() + ")";
    }

    public static class Matcher
    extends SimpleTraitMatcher<PackageReference> {
        XPathMatcher packageReference = new XPathMatcher("//PackageReference");
        XPathMatcher packageConfig = new XPathMatcher("/packages/package");

        protected PackageReference test(Cursor cursor) {
            Object value = cursor.getValue();
            if (value instanceof Xml.Tag) {
                Xml.Tag tag = (Xml.Tag)value;
                if (this.packageReference.matches(cursor)) {
                    Map<String, String> attrs = Matcher.asMap(tag.getAttributes());
                    String include = attrs.get("Include");
                    String version = attrs.get("Version");
                    if (include != null && version != null) {
                        return new PackageReference(cursor, include, version);
                    }
                } else if (this.packageConfig.matches(cursor)) {
                    Map<String, String> attrs = Matcher.asMap(tag.getAttributes());
                    String id = attrs.get("id");
                    String version = attrs.get("version");
                    if (id != null && version != null) {
                        return new PackageReference(cursor, id, version);
                    }
                }
            }
            return null;
        }

        private static Map<String, String> asMap(List<Xml.Attribute> attributes) {
            return attributes.stream().collect(Collectors.toMap(attr -> attr.getKey().getName(), attr -> attr.getValue().getValue()));
        }
    }
}

