/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jenkins.Jenkins;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class IsJenkinsPlugin
extends Recipe {
    @Option(displayName="Jenkins version", description="The value of the `<jenkins.version>` property.", example="[1,)")
    private final String version;

    public String getDisplayName() {
        return "Is the project a Jenkins plugin?";
    }

    public String getDescription() {
        return "Checks if the project is a Jenkins plugin by the presence of a managed version of jenkins-core";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.or(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        VersionComparator versionComparator;
        Validated versionValidation = Semver.validate((String)this.version, null);
        if (versionValidation.isValid() && (versionComparator = (VersionComparator)versionValidation.getValue()) != null) {
            return new XmlVisitor<ExecutionContext>(){

                public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                    String jenkinsVersion = Jenkins.isJenkinsPluginPom((SourceFile)document);
                    if (jenkinsVersion != null && versionComparator.isValid(null, jenkinsVersion) && !document.getMarkers().findFirst(SearchResult.class).isPresent()) {
                        return (Xml)SearchResult.found((Tree)document, (String)jenkinsVersion);
                    }
                    return document;
                }
            };
        }
        return TreeVisitor.noop();
    }

    @ConstructorProperties(value={"version"})
    @Generated
    public IsJenkinsPlugin(String version) {
        this.version = version;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @NonNull
    @Generated
    public String toString() {
        return "IsJenkinsPlugin(version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IsJenkinsPlugin)) {
            return false;
        }
        IsJenkinsPlugin other = (IsJenkinsPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof IsJenkinsPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

