/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public final class JenkinsfileAsGroovy
extends Recipe {
    @Option(displayName="File pattern", description="A glob pattern to match Jenkinsfile paths. Defaults to `**/Jenkinsfile*`.", example="**/Jenkinsfile*", required=false)
    private final @Nullable String filePattern;

    public String getDisplayName() {
        return "Parse `Jenkinsfile` as Groovy";
    }

    public String getDescription() {
        return "Parse any `Jenkinsfile` as Groovy code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        String paths = Optional.ofNullable(this.filePattern).orElse("**/Jenkinsfile*");
        return Preconditions.check((Recipe)new FindSourceFiles(paths), (TreeVisitor)new PlainTextVisitor<ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof PlainText) {
                    PlainText pt = (PlainText)tree;
                    return (Tree)GroovyParser.builder().build().parse(new String[]{pt.getText()}).findFirst().map(sourceFile -> ((SourceFile)((SourceFile)sourceFile.withId(pt.getId())).withMarkers(pt.getMarkers())).withSourcePath(pt.getSourcePath())).orElse((SourceFile)pt);
                }
                return super.visit(tree, (Object)ctx);
            }
        });
    }

    @ConstructorProperties(value={"filePattern"})
    @Generated
    public JenkinsfileAsGroovy(@Nullable String filePattern) {
        this.filePattern = filePattern;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "JenkinsfileAsGroovy(filePattern=" + this.getFilePattern() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JenkinsfileAsGroovy)) {
            return false;
        }
        JenkinsfileAsGroovy other = (JenkinsfileAsGroovy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof JenkinsfileAsGroovy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

