/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.log4j;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NullMarked
public class LoggerSetLevelToConfiguratorRecipe
extends Recipe {
    public String getDisplayName() {
        return "Convert Log4j `Logger.setLevel` to Log4j2 `Configurator.setLevel`";
    }

    public String getDescription() {
        return "Converts `org.apache.log4j.Logger.setLevel` to `org.apache.logging.log4j.core.config.Configurator.setLevel`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            JavaTemplate before;
            JavaTemplate after;

            public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (this.before == null) {
                    this.before = JavaTemplate.builder((String)"#{logger:any(org.apache.log4j.Logger)}.setLevel(#{level:any(org.apache.log4j.Level)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"log4j-1"})).build();
                }
                if ((matcher = this.before.matcher(this.getCursor())).find()) {
                    this.maybeRemoveImport("org.apache.log4j.Logger");
                    this.maybeRemoveImport("org.apache.log4j.Level");
                    if (this.after == null) {
                        this.after = JavaTemplate.builder((String)"org.apache.logging.log4j.core.config.Configurator.setLevel(#{logger:any(org.apache.logging.log4j.Logger)}, #{level:any(org.apache.logging.log4j.Level)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"log4j-api-2", "log4j-core-2"})).build();
                    }
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                }
                return super.visitMethodInvocation(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.log4j.Level", Boolean.valueOf(true)), new UsesType("org.apache.log4j.Logger", Boolean.valueOf(true)), new UsesMethod("org.apache.log4j.Category setLevel(..)", true)}), (TreeVisitor)javaVisitor);
    }
}

