/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class UseCollectionInterfaces
extends Recipe {
    static final Map<String, String> rspecRulesReplaceTypeMap = new HashMap<String, String>();

    public String getDisplayName() {
        return "Use `Collection` interfaces";
    }

    public String getDescription() {
        return "Use `Deque`, `List`, `Map`, `ConcurrentMap`, `Queue`, and `Set` instead of implemented collections. Replaces the return type of public method declarations and the variable type public variable declarations.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1319");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return super.isAcceptable(sourceFile, (Object)ctx) && !(sourceFile instanceof G.CompilationUnit);
            }

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    if (((AtomicBoolean)new InterfaceIncompatibleMethodDetector().reduce(tree, new AtomicBoolean(false))).get()) {
                        return cu;
                    }
                    for (JavaType type : cu.getTypesInUse().getTypesInUse()) {
                        JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)type);
                        if (fq == null || !rspecRulesReplaceTypeMap.containsKey(fq.getFullyQualifiedName())) continue;
                        return (J)super.visit((Tree)cu, (Object)ctx);
                    }
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                JavaType.FullyQualified newType;
                String fullyQualifiedName;
                JavaType originalType;
                JavaType.FullyQualified fullyQualified;
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if ((mi.getSelect() instanceof J.Identifier || mi.getSelect() instanceof J.FieldAccess) && mi.getSelect().getType() != null && (fullyQualified = TypeUtils.asFullyQualified((JavaType)(originalType = mi.getSelect().getType()))) != null && rspecRulesReplaceTypeMap.containsKey(fullyQualifiedName = fullyQualified.getFullyQualifiedName()) && (newType = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)rspecRulesReplaceTypeMap.get(fullyQualifiedName)))) != null) {
                    if (originalType instanceof JavaType.Parameterized) {
                        newType = new JavaType.Parameterized(null, newType, ((JavaType.Parameterized)originalType).getTypeParameters());
                    }
                    return this.updateMethodInvocation(mi, newType);
                }
                return mi;
            }

            private J.MethodInvocation updateMethodInvocation(J.MethodInvocation mi, JavaType.FullyQualified newType) {
                if (mi.getSelect() != null && (mi = mi.withSelect((Expression)mi.getSelect().withType((JavaType)newType))).getSelect() instanceof J.FieldAccess) {
                    J.FieldAccess fieldAccess = (J.FieldAccess)mi.getSelect();
                    mi = mi.withSelect((Expression)fieldAccess.withName(fieldAccess.getName().withType((JavaType)newType)));
                }
                if (mi.getMethodType() != null) {
                    mi = mi.withMethodType(mi.getMethodType().withDeclaringType(newType));
                }
                return mi;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                JavaType.FullyQualified newType;
                JavaType.FullyQualified originalType;
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if ((m.hasModifier(J.Modifier.Type.Public) || m.hasModifier(J.Modifier.Type.Private) || m.getModifiers().isEmpty()) && m.getReturnTypeExpression() != null && (originalType = TypeUtils.asFullyQualified((JavaType)m.getReturnTypeExpression().getType())) != null && rspecRulesReplaceTypeMap.containsKey(originalType.getFullyQualifiedName()) && (newType = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)rspecRulesReplaceTypeMap.get(originalType.getFullyQualifiedName())))) != null) {
                    this.maybeRemoveImport(originalType);
                    this.maybeAddImport(newType);
                    m = m.withReturnTypeExpression(this.getTypeTree(m.getReturnTypeExpression(), newType));
                }
                return m;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                JavaType.FullyQualified originalType = TypeUtils.asFullyQualified((JavaType)mv.getType());
                if ((mv.hasModifier(J.Modifier.Type.Public) || mv.hasModifier(J.Modifier.Type.Private) || mv.getModifiers().isEmpty()) && originalType != null && rspecRulesReplaceTypeMap.containsKey(originalType.getFullyQualifiedName())) {
                    if (mv.getTypeExpression() instanceof J.Identifier && "var".equals(((J.Identifier)mv.getTypeExpression()).getSimpleName())) {
                        return mv;
                    }
                    JavaType.FullyQualified newType = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)rspecRulesReplaceTypeMap.get(originalType.getFullyQualifiedName())));
                    if (newType != null) {
                        this.maybeRemoveImport(originalType);
                        this.maybeAddImport(newType);
                        mv = mv.withTypeExpression(this.getTypeTree(mv.getTypeExpression(), newType));
                        mv = mv.withVariables(ListUtils.map((List)mv.getVariables(), var -> {
                            JavaType.FullyQualified varType = TypeUtils.asFullyQualified((JavaType)var.getType());
                            if (varType != null && !varType.equals(newType)) {
                                return var.withType((JavaType)newType).withName(var.getName().withType((JavaType)newType));
                            }
                            return var;
                        }));
                    }
                }
                return mv;
            }

            @Contract(value="null, _ -> null")
            private @Nullable TypeTree getTypeTree(@Nullable TypeTree inputTypeExpression, JavaType.FullyQualified newType) {
                if (inputTypeExpression == null) {
                    return null;
                }
                if (inputTypeExpression instanceof J.Identifier) {
                    return new J.Identifier(Tree.randomId(), inputTypeExpression.getPrefix(), Markers.EMPTY, Collections.emptyList(), newType.getClassName(), (JavaType)newType, null);
                }
                if (inputTypeExpression instanceof J.FieldAccess) {
                    return new J.Identifier(Tree.randomId(), inputTypeExpression.getPrefix(), Markers.EMPTY, Collections.emptyList(), newType.getClassName(), (JavaType)newType, null);
                }
                if (inputTypeExpression instanceof J.AnnotatedType) {
                    J.AnnotatedType annotatedType = (J.AnnotatedType)inputTypeExpression;
                    TypeTree annotatedTypeExpression = annotatedType.getTypeExpression();
                    if (annotatedTypeExpression instanceof J.Identifier || annotatedTypeExpression instanceof J.FieldAccess) {
                        return annotatedType.withTypeExpression((TypeTree)new J.Identifier(Tree.randomId(), annotatedTypeExpression.getPrefix(), Markers.EMPTY, Collections.emptyList(), newType.getClassName(), (JavaType)newType, null));
                    }
                    J.ParameterizedType parameterizedType = (J.ParameterizedType)annotatedTypeExpression;
                    return annotatedType.withTypeExpression(this.removeFromParameterizedType(newType, parameterizedType));
                }
                J.ParameterizedType parameterizedType = (J.ParameterizedType)inputTypeExpression;
                return this.removeFromParameterizedType(newType, parameterizedType);
            }

            private TypeTree removeFromParameterizedType(JavaType.FullyQualified newType, J.ParameterizedType parameterizedType) {
                J.Identifier returnType = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), newType.getClassName(), (JavaType)newType, null);
                JavaType.Parameterized javaType = (JavaType.Parameterized)parameterizedType.getType();
                return parameterizedType.withClazz((NameTree)returnType).withType((JavaType)(javaType != null ? javaType.withType(newType) : new JavaType.Parameterized(null, newType, null)));
            }
        };
    }

    static {
        rspecRulesReplaceTypeMap.put("java.util.ArrayDeque", "java.util.Deque");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentLinkedDeque", "java.util.Deque");
        rspecRulesReplaceTypeMap.put("java.util.AbstractList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.AbstractSequentialList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.ArrayList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.CopyOnWriteArrayList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.LinkedList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.Stack", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.Vector", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.AbstractMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.EnumMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.HashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.Hashtable", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.IdentityHashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.LinkedHashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.TreeMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.WeakHashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentMap");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentSkipListMap", "java.util.concurrent.ConcurrentMap");
        rspecRulesReplaceTypeMap.put("java.util.AbstractQueue", "java.util.Queue");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentLinkedQueue", "java.util.Queue");
        rspecRulesReplaceTypeMap.put("java.util.PriorityQueue", "java.util.Queue");
        rspecRulesReplaceTypeMap.put("java.util.AbstractSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.HashSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.LinkedHashSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.TreeSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.CopyOnWriteArraySet", "java.util.Set");
    }

    private static class InterfaceIncompatibleMethodDetector
    extends JavaIsoVisitor<AtomicBoolean> {
        private static final Map<String, Set<String>> nonInterfaceMethods = new HashMap<String, Set<String>>();

        private InterfaceIncompatibleMethodDetector() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean foundNonInterfaceMethod) {
            JavaType.FullyQualified fqType;
            if (foundNonInterfaceMethod.get()) {
                return method;
            }
            if (method.getSelect() != null && (fqType = TypeUtils.asFullyQualified((JavaType)method.getSelect().getType())) != null && nonInterfaceMethods.getOrDefault(fqType.getFullyQualifiedName(), Collections.emptySet()).contains(method.getSimpleName())) {
                foundNonInterfaceMethod.set(true);
                return method;
            }
            return super.visitMethodInvocation(method, (Object)foundNonInterfaceMethod);
        }

        static {
            nonInterfaceMethods.put("java.util.Hashtable", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("contains", "elements", "keys"))));
            nonInterfaceMethods.put("java.util.Vector", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("addElement", "capacity", "copyInto", "elementAt", "elements", "ensureCapacity", "insertElementAt", "removeAllElements", "removeElement", "removeElementAt", "setElementAt", "setSize", "trimToSize"))));
            nonInterfaceMethods.put("java.util.ArrayList", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ensureCapacity", "trimToSize"))));
            nonInterfaceMethods.put("java.util.LinkedList", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("addFirst", "addLast", "getFirst", "getLast", "removeFirst", "removeLast", "descendingIterator", "offerFirst", "offerLast", "peekFirst", "peekLast", "pollFirst", "pollLast", "pop", "push", "removeFirstOccurrence", "removeLastOccurrence"))));
            nonInterfaceMethods.put("java.util.Stack", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("empty", "peek", "pop", "push", "search"))));
            nonInterfaceMethods.put("java.util.TreeMap", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ceilingEntry", "ceilingKey", "descendingKeySet", "descendingMap", "firstEntry", "firstKey", "floorEntry", "floorKey", "headMap", "higherEntry", "higherKey", "lastEntry", "lastKey", "lowerEntry", "lowerKey", "navigableKeySet", "pollFirstEntry", "pollLastEntry", "subMap", "tailMap"))));
            nonInterfaceMethods.put("java.util.TreeSet", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ceiling", "descendingIterator", "descendingSet", "first", "floor", "headSet", "higher", "last", "lower", "pollFirst", "pollLast", "subSet", "tailSet"))));
        }
    }
}

