/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="2.17.0")
public class CollapseConsecutiveAssertThatStatements
extends Recipe {
    private static final MethodMatcher ASSERT_THAT = new MethodMatcher("org.assertj.core.api.Assertions assertThat(..)");

    public String getDisplayName() {
        return "Collapse consecutive `assertThat` statements";
    }

    public String getDescription() {
        return "Collapse consecutive `assertThat` statements into single `assertThat` chained statement. This recipe ignores `assertThat` statements that have method invocation as parameter.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_THAT), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block bl = super.visitBlock(block, (Object)ctx);
                ArrayList<Object> statementsCollapsed = new ArrayList<Object>();
                for (List<Statement> group : this.getGroupedStatements(bl)) {
                    if (group.size() <= 1) {
                        statementsCollapsed.addAll(group);
                        continue;
                    }
                    statementsCollapsed.add(this.getCollapsedAssertThat(group));
                }
                return bl.withStatements(statementsCollapsed);
            }

            private List<List<Statement>> getGroupedStatements(J.Block bl) {
                List originalStatements = bl.getStatements();
                ArrayList<List<Statement>> groupedStatements = new ArrayList<List<Statement>>();
                Expression currentActual = null;
                ArrayList<Statement> currentGroup = new ArrayList<Statement>();
                for (Statement statement : originalStatements) {
                    J.MethodInvocation assertion;
                    if (statement instanceof J.MethodInvocation && this.isGroupableAssertion(assertion = (J.MethodInvocation)statement)) {
                        J.MethodInvocation assertThat = (J.MethodInvocation)assertion.getSelect();
                        assert (assertThat != null);
                        Expression actual = (Expression)assertThat.getArguments().get(0);
                        if (currentActual == null || !SemanticallyEqual.areEqual(currentActual, (J)actual)) {
                            groupedStatements.add(currentGroup);
                            currentGroup = new ArrayList();
                            currentActual = actual;
                        }
                        currentGroup.add(statement);
                        continue;
                    }
                    groupedStatements.add(currentGroup);
                    currentGroup = new ArrayList();
                    currentActual = null;
                    groupedStatements.add(Collections.singletonList(statement));
                }
                if (!currentGroup.isEmpty()) {
                    groupedStatements.add(currentGroup);
                }
                return groupedStatements;
            }

            private boolean isGroupableAssertion(J.MethodInvocation assertion) {
                J.MethodInvocation assertThat;
                if (ASSERT_THAT.matches(assertion.getSelect()) && (assertThat = (J.MethodInvocation)assertion.getSelect()) != null && !(assertThat.getArguments().get(0) instanceof MethodCall)) {
                    return TypeUtils.isOfType((JavaType)assertThat.getType(), (JavaType)assertion.getType());
                }
                return false;
            }

            private J.MethodInvocation getCollapsedAssertThat(List<Statement> consecutiveAssertThatStatement) {
                assert (!consecutiveAssertThatStatement.isEmpty());
                Space originalPrefix = consecutiveAssertThatStatement.get(0).getPrefix();
                String continuationIndent = originalPrefix.getIndent().contains("\t") ? "\t\t" : "        ";
                Space indentedNewline = Space.format((String)(originalPrefix.getLastWhitespace().replaceAll("^\\s+\n", "\n") + continuationIndent));
                J.MethodInvocation collapsed = null;
                for (Statement st : consecutiveAssertThatStatement) {
                    J.MethodInvocation assertion = (J.MethodInvocation)st;
                    J.MethodInvocation assertThat = (J.MethodInvocation)assertion.getSelect();
                    assert (assertThat != null);
                    J.MethodInvocation newSelect = collapsed == null ? assertThat : collapsed;
                    collapsed = assertion.getPadding().withSelect(JRightPadded.build((Object)newSelect.withPrefix(Space.EMPTY)).withAfter(indentedNewline));
                }
                return collapsed.withPrefix(originalPrefix);
            }
        });
    }
}

