/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Adopt AssertJ Short Assertions", description="Adopt AssertJ Short Assertions. Favor semantically explicit methods (e.g. `myShort.isZero()` over `myShort.isEqualTo(0)`).")
public class AssertJShortRules {

    @RecipeDescriptor(name="Replace `isEqualTo(1)` with `isOne()`", description="Replace `isEqualTo(1)` with `isOne()`.")
    static final class AbstractShortAssertIsOne {
        AbstractShortAssertIsOne() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isEqualTo((short)1);
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isOne();
        }
    }

    @RecipeDescriptor(name="Replace `isNotEqualTo(0)` with `isNotZero()`", description="Replace `isNotEqualTo(0)` with `isNotZero()`.")
    static final class AbstractShortAssertIsNotZero {
        AbstractShortAssertIsNotZero() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isNotEqualTo((short)0);
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isNotZero();
        }
    }

    @RecipeDescriptor(name="Replace `isEqualTo(0)` with `isZero()`", description="Replace `isEqualTo(0)` with `isZero()`.")
    static final class AbstractShortAssertIsZero {
        AbstractShortAssertIsZero() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isEqualTo((short)0);
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {
            return shortAssert.isZero();
        }
    }

    @RecipeDescriptor(name="Replace `isNotCloseTo` with `isNotEqualTo`", description="Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractShortAssertIsNotEqualTo {
        AbstractShortAssertIsNotEqualTo() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert, short n) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{shortAssert.isNotCloseTo(n, Offset.offset((Number)0)), shortAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert, short n) {
            return shortAssert.isNotEqualTo(n);
        }
    }

    @RecipeDescriptor(name="Replace `isCloseTo` with `isEqualTo`", description="Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractShortAssertIsEqualTo {
        AbstractShortAssertIsEqualTo() {
        }

        AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert, short n) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{shortAssert.isCloseTo(n, Offset.offset((Number)0)), shortAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert, short n) {
            return shortAssert.isEqualTo(n);
        }
    }
}

