/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class SimplifyRedundantAssertJChains
extends Recipe {
    private static final MethodMatcher hasSizeMatcher = new MethodMatcher("org.assertj.core.api..* hasSize(..)");
    private static final MethodMatcher exactSizeImplyingMatchers = new MethodMatcher("org.assertj.core.api..* containsExactly*(..)");
    private static final MethodMatcher isNotNullMatcher = new MethodMatcher("org.assertj.core.api..* isNotNull()");
    private static final MethodMatcher[] nonNullImplyingMatchers = new MethodMatcher[]{new MethodMatcher("org.assertj.core.api..* isNotEmpty()"), new MethodMatcher("org.assertj.core.api..* isEmpty()"), new MethodMatcher("org.assertj.core.api..* isBlank()"), new MethodMatcher("org.assertj.core.api..* isNotBlank()"), new MethodMatcher("org.assertj.core.api..* hasSize(..)"), new MethodMatcher("org.assertj.core.api..* contains(..)"), new MethodMatcher("org.assertj.core.api..* startsWith(..)"), new MethodMatcher("org.assertj.core.api..* endsWith(..)"), new MethodMatcher("org.assertj.core.api..* matches(..)"), new MethodMatcher("org.assertj.core.api..* isEqualToIgnoringCase(..)"), exactSizeImplyingMatchers, new MethodMatcher("org.assertj.core.api..* containsOnly(..)"), new MethodMatcher("org.assertj.core.api..* containsAll(..)"), new MethodMatcher("org.assertj.core.api..* containsKey(..)"), new MethodMatcher("org.assertj.core.api..* containsKeys(..)"), new MethodMatcher("org.assertj.core.api..* containsValue(..)"), new MethodMatcher("org.assertj.core.api..* containsEntry(..)"), new MethodMatcher("org.assertj.core.api..* isPresent()"), new MethodMatcher("org.assertj.core.api..* isNotPresent()"), new MethodMatcher("org.assertj.core.api..* isTrue()"), new MethodMatcher("org.assertj.core.api..* isFalse()"), new MethodMatcher("org.assertj.core.api..* isNotEqualTo(..)"), new MethodMatcher("org.assertj.core.api..* isNotSameAs(..)"), new MethodMatcher("org.assertj.core.api..* isInstanceOf(..)"), new MethodMatcher("org.assertj.core.api..* hasSameClassAs(..)"), new MethodMatcher("org.assertj.core.api..* hasToString(..)"), new MethodMatcher("org.assertj.core.api..* isZero()"), new MethodMatcher("org.assertj.core.api..* isNotZero()"), new MethodMatcher("org.assertj.core.api..* isPositive()"), new MethodMatcher("org.assertj.core.api..* isNegative()"), new MethodMatcher("org.assertj.core.api..* exists()"), new MethodMatcher("org.assertj.core.api..* isFile()"), new MethodMatcher("org.assertj.core.api..* isDirectory()"), new MethodMatcher("org.assertj.core.api..* isRegularFile()"), new MethodMatcher("org.assertj.core.api..* canRead()"), new MethodMatcher("org.assertj.core.api..* canWrite()")};
    private static final MethodMatcher isNotEmptyMatcher = new MethodMatcher("org.assertj.core.api..* isNotEmpty()");
    private static final MethodMatcher containsMatcher = new MethodMatcher("org.assertj.core.api..* contains*(..)");
    private static final MethodMatcher isPresentMatcher = new MethodMatcher("org.assertj.core.api..* isPresent()");

    public String getDisplayName() {
        return "Simplify redundant AssertJ assertion chains";
    }

    public String getDescription() {
        return "Removes redundant AssertJ assertions when chained methods already provide the same or stronger guarantees.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(hasSizeMatcher), new UsesMethod(isNotNullMatcher), new UsesMethod(isNotEmptyMatcher), new UsesMethod(isPresentMatcher)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!(mi.getSelect() instanceof J.MethodInvocation)) {
                    return mi;
                }
                J.MethodInvocation select = (J.MethodInvocation)mi.getSelect();
                if (isNotNullMatcher.matches((MethodCall)select)) {
                    for (MethodMatcher matcher : nonNullImplyingMatchers) {
                        if (!matcher.matches((MethodCall)mi)) continue;
                        return mi.withSelect(select.getSelect());
                    }
                }
                if (isNotEmptyMatcher.matches((MethodCall)select) && containsMatcher.matches((MethodCall)mi)) {
                    return mi.withSelect(select.getSelect());
                }
                if (isPresentMatcher.matches((MethodCall)select) && containsMatcher.matches((MethodCall)mi)) {
                    return mi.withSelect(select.getSelect());
                }
                if (hasSizeMatcher.matches((MethodCall)select) && exactSizeImplyingMatchers.matches((MethodCall)mi)) {
                    return mi.withSelect(select.getSelect());
                }
                return mi;
            }
        });
    }
}

