/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.IsLikelyNotTest;
import org.openrewrite.java.search.IsLikelyTest;
import org.openrewrite.java.testing.search.FindUnitTestTable;
import org.openrewrite.java.testing.search.UnitTest;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public class FindUnitTests
extends ScanningRecipe<Accumulator> {
    private transient @Nullable Accumulator acc = new Accumulator();
    transient FindUnitTestTable unitTestTable = new FindUnitTestTable((Recipe)this);

    public FindUnitTests() {
    }

    @JsonIgnore
    public FindUnitTests(Accumulator acc) {
        this.acc = acc;
    }

    public String getDisplayName() {
        return "Find unit tests";
    }

    public String getDescription() {
        return "Produces a data table showing how methods are used in unit tests.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        if (this.acc != null) {
            return this.acc;
        }
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        JavaVisitor<ExecutionContext> scanningVisitor = new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                if (methodDeclaration != null && methodDeclaration.getLeadingAnnotations().stream().filter(o -> o.getAnnotationType() instanceof J.Identifier).anyMatch(o -> "Test".equals(o.getSimpleName()))) {
                    String clazz = ((J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class)).getType().getFullyQualifiedName();
                    String testName = methodDeclaration.getSimpleName();
                    String testBody = methodDeclaration.printTrimmed(this.getCursor());
                    acc.addMethodInvocation(clazz, testName, testBody, method);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)new IsLikelyTest().getVisitor(), (TreeVisitor)scanningVisitor);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        JavaVisitor<ExecutionContext> tableRowVisitor = new JavaVisitor<ExecutionContext>(){

            public J visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext ctx) {
                for (AccumulatorValue value : acc.getUnitTestsByKey().values()) {
                    UnitTest unitTest = value.getUnitTest();
                    for (J.MethodInvocation invocation : value.getMethodInvocations()) {
                        if (!invocation.getSimpleName().equals(methodDeclaration.getSimpleName())) continue;
                        FindUnitTests.this.unitTestTable.insertRow(ctx, new FindUnitTestTable.Row(methodDeclaration.getName().toString(), methodDeclaration.getSimpleName(), invocation.printTrimmed(this.getCursor()), unitTest.getClazz(), unitTest.getUnitTestName()));
                    }
                }
                SearchResult.found((Tree)methodDeclaration);
                return super.visitMethodDeclaration(methodDeclaration, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)new IsLikelyNotTest().getVisitor(), (TreeVisitor)tableRowVisitor);
    }

    public static class Accumulator {
        private final Map<String, AccumulatorValue> unitTestsByKey = new HashMap<String, AccumulatorValue>();

        public void addMethodInvocation(String clazz, String testName, String testBody, J.MethodInvocation invocation) {
            String key = clazz + "#" + testName;
            AccumulatorValue value = this.unitTestsByKey.get(key);
            if (value == null) {
                UnitTest unitTest = new UnitTest(clazz, testName, testBody);
                value = new AccumulatorValue(unitTest, new HashSet<J.MethodInvocation>());
                this.unitTestsByKey.put(key, value);
            }
            value.getMethodInvocations().add(invocation);
        }

        @Generated
        public Map<String, AccumulatorValue> getUnitTestsByKey() {
            return this.unitTestsByKey;
        }
    }

    public static final class AccumulatorValue {
        private final UnitTest unitTest;
        private final Set<J.MethodInvocation> methodInvocations;

        @ConstructorProperties(value={"unitTest", "methodInvocations"})
        @Generated
        public AccumulatorValue(UnitTest unitTest, Set<J.MethodInvocation> methodInvocations) {
            this.unitTest = unitTest;
            this.methodInvocations = methodInvocations;
        }

        @Generated
        public UnitTest getUnitTest() {
            return this.unitTest;
        }

        @Generated
        public Set<J.MethodInvocation> getMethodInvocations() {
            return this.methodInvocations;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccumulatorValue)) {
                return false;
            }
            AccumulatorValue other = (AccumulatorValue)o;
            UnitTest this$unitTest = this.getUnitTest();
            UnitTest other$unitTest = other.getUnitTest();
            if (this$unitTest == null ? other$unitTest != null : !((Object)this$unitTest).equals(other$unitTest)) {
                return false;
            }
            Set<J.MethodInvocation> this$methodInvocations = this.getMethodInvocations();
            Set<J.MethodInvocation> other$methodInvocations = other.getMethodInvocations();
            return !(this$methodInvocations == null ? other$methodInvocations != null : !((Object)this$methodInvocations).equals(other$methodInvocations));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UnitTest $unitTest = this.getUnitTest();
            result = result * 59 + ($unitTest == null ? 43 : ((Object)$unitTest).hashCode());
            Set<J.MethodInvocation> $methodInvocations = this.getMethodInvocations();
            result = result * 59 + ($methodInvocations == null ? 43 : ((Object)$methodInvocations).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "FindUnitTests.AccumulatorValue(unitTest=" + this.getUnitTest() + ", methodInvocations=" + this.getMethodInvocations() + ")";
        }
    }
}

