/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.semver.Semver;

public final class ChangePluginVersion
extends Recipe {
    private static final String GRADLE_PROPERTIES_FILE_NAME = "gradle.properties";
    @Option(displayName="Plugin id", description="The `ID` part of `plugin { ID }`, as a glob expression.", example="com.jfrog.bintray")
    private final String pluginIdPattern;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="29.X", required=false)
    private final @Nullable String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;

    public String getDisplayName() {
        return "Change a Gradle plugin version by id";
    }

    public String getDescription() {
        return "Change a Gradle plugin by id to a later version.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        final MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        GroovyVisitor<ExecutionContext> groovyVisitor = new GroovyVisitor<ExecutionContext>(){
            private @Nullable GradleProject gradleProject;
            private @Nullable GradleSettings gradleSettings;

            public J visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                this.gradleProject = cu.getMarkers().findFirst(GradleProject.class).orElse(null);
                this.gradleSettings = cu.getMarkers().findFirst(GradleSettings.class).orElse(null);
                if (this.gradleProject == null && this.gradleSettings == null) {
                    return cu;
                }
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (!(versionMatcher.matches((MethodCall)m) && m.getSelect() instanceof J.MethodInvocation && pluginMatcher.matches(m.getSelect()))) {
                    return m;
                }
                List pluginArgs = ((J.MethodInvocation)m.getSelect()).getArguments();
                if (!(pluginArgs.get(0) instanceof J.Literal)) {
                    return m;
                }
                String pluginId = (String)((J.Literal)pluginArgs.get(0)).getValue();
                if (pluginId == null || !StringUtils.matchesGlob((String)pluginId, (String)ChangePluginVersion.this.pluginIdPattern)) {
                    return m;
                }
                List versionArgs = m.getArguments();
                String currentVersion = "0";
                if (versionArgs.get(0) instanceof J.Literal && (currentVersion = (String)((J.Literal)versionArgs.get(0)).getValue()) == null) {
                    currentVersion = "0";
                }
                String selectedNewVersion = ChangePluginVersion.this.newVersion;
                if (currentVersion.equals("0") && "latest.patch".equals(ChangePluginVersion.this.newVersion)) {
                    selectedNewVersion = "latest.release";
                }
                try {
                    String resolvedVersion = new DependencyVersionSelector(null, this.gradleProject, this.gradleSettings).select(new GroupArtifactVersion(pluginId, pluginId + ".gradle.plugin", currentVersion), "classpath", selectedNewVersion, ChangePluginVersion.this.versionPattern, ctx);
                    if (resolvedVersion == null) {
                        return m;
                    }
                    return m.withArguments(ListUtils.map((List)versionArgs, v -> new J.Literal(Tree.randomId(), v.getPrefix(), v.getMarkers(), (Object)resolvedVersion, "'" + resolvedVersion + "'", null, JavaType.Primitive.String)));
                }
                catch (MavenDownloadingException e) {
                    return (J)Markup.warn((Tree)m, (Throwable)e);
                }
            }
        };
        return Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)groovyVisitor)});
    }

    @Generated
    public ChangePluginVersion(String pluginIdPattern, @Nullable String newVersion, @Nullable String versionPattern) {
        this.pluginIdPattern = pluginIdPattern;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    @Generated
    public String getPluginIdPattern() {
        return this.pluginIdPattern;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePluginVersion(pluginIdPattern=" + this.getPluginIdPattern() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePluginVersion)) {
            return false;
        }
        ChangePluginVersion other = (ChangePluginVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginIdPattern = this.getPluginIdPattern();
        String other$pluginIdPattern = other.getPluginIdPattern();
        if (this$pluginIdPattern == null ? other$pluginIdPattern != null : !this$pluginIdPattern.equals(other$pluginIdPattern)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePluginVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginIdPattern = this.getPluginIdPattern();
        result = result * 59 + ($pluginIdPattern == null ? 43 : $pluginIdPattern.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

