/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.toml.TomlParser;
import org.openrewrite.toml.tree.Toml;

public final class MigrateDependenciesToVersionCatalog
extends ScanningRecipe<DependencyAccumulator> {
    private static final MethodMatcher DEPENDENCY_DSL_MATCHER = new MethodMatcher("DependencyHandlerSpec *(..)");
    private static final MethodMatcher PROJECT_MATCHER = new MethodMatcher("DependencyHandlerSpec project(..)");
    private static final Pattern DEPENDENCY_STRING_PATTERN = Pattern.compile("([^:]+):([^:]+):([^:@]+)(@.+)?");
    private static final Pattern DEPENDENCY_MAP_PATTERN = Pattern.compile("group:\\s*['\"]([^'\"]+)['\"],\\s*name:\\s*['\"]([^'\"]+)['\"],\\s*version:\\s*['\"]([^'\"]+)['\"]");
    private static final String CATALOG_PATH = "gradle/libs.versions.toml";
    private static final String GRADLE_PROPERTIES = "gradle.properties";

    public String getDisplayName() {
        return "Migrate Gradle project dependencies to version catalog";
    }

    public String getDescription() {
        return "Migrates Gradle project dependencies to use the [version catalog](https://docs.gradle.org/current/userguide/platforms.html) feature. Supports migrating dependency declarations of various forms:\n * `String` notation: `\"group:artifact:version\"`\n * `Map` notation: `group: 'group', name: 'artifact', version: 'version'`\n * Property references: `\"group:artifact:$version\"` or `\"group:artifact:${version}\"`\n\nThe recipe will:\n * Create a `gradle/libs.versions.toml` file with version declarations\n * Replace dependency declarations with catalog references (e.g., `libs.springCore`)\n * Migrate version properties from `gradle.properties` to the version catalog\n * Preserve project dependencies unchanged\n\n**Note:** If a version catalog already exists, the recipe will not modify it.";
    }

    public DependencyAccumulator getInitialValue(ExecutionContext ctx) {
        return new DependencyAccumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final DependencyAccumulator acc) {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile;
                Path path;
                if (tree instanceof SourceFile && ((path = (sourceFile = (SourceFile)tree).getSourcePath()).endsWith(MigrateDependenciesToVersionCatalog.GRADLE_PROPERTIES) || path.endsWith(MigrateDependenciesToVersionCatalog.CATALOG_PATH))) {
                    return SearchResult.found((Tree)tree);
                }
                return tree;
            }
        }}), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                if (sourceFile.getSourcePath().endsWith(MigrateDependenciesToVersionCatalog.CATALOG_PATH)) {
                    acc.catalogExists = true;
                    return tree;
                }
                if (sourceFile.getSourcePath().endsWith(MigrateDependenciesToVersionCatalog.GRADLE_PROPERTIES) && sourceFile instanceof Properties.File) {
                    Properties.File propertiesFile = (Properties.File)sourceFile;
                    for (Properties.Content content : propertiesFile.getContent()) {
                        if (!(content instanceof Properties.Entry)) continue;
                        Properties.Entry entry = (Properties.Entry)content;
                        acc.propertyValues.put(entry.getKey(), entry.getValue().getText());
                    }
                    return tree;
                }
                if (sourceFile.getSourcePath().toString().endsWith(".gradle")) {
                    String sourceText = sourceFile.printAll();
                    Pattern propRefPattern = Pattern.compile("\\$\\{?([a-zA-Z][a-zA-Z0-9_]*)\\}?");
                    Matcher propMatcher = propRefPattern.matcher(sourceText);
                    while (propMatcher.find()) {
                        String propName = propMatcher.group(1);
                        acc.propertyNamesToRemove.add(propName);
                    }
                    GradleDependency.Matcher matcher = new GradleDependency.Matcher();
                    return matcher.asVisitor((dep, ctx2) -> {
                        if (!PROJECT_MATCHER.matches((MethodCall)dep.getTree())) {
                            String groupId = dep.getDeclaredGroupId();
                            String artifactId = dep.getDeclaredArtifactId();
                            String version = dep.getDeclaredVersion();
                            String configurationName = dep.getConfigurationName();
                            if (groupId != null && artifactId != null && version != null) {
                                acc2.configurations.add(configurationName);
                                String versionVariable = dep.getVersionVariable();
                                if (versionVariable != null) {
                                    acc2.propertyNamesToRemove.add(versionVariable);
                                }
                                String depKey = groupId + ":" + artifactId + ":" + version;
                                DependencyInfo depInfo = new DependencyInfo(groupId, artifactId, version, configurationName);
                                acc2.dependencies.put(depKey, depInfo);
                            }
                        }
                        return dep.getTree();
                    }).visitNonNull((Tree)sourceFile, (Object)ctx);
                }
                if (sourceFile.getSourcePath().toString().endsWith(".gradle.kts")) {
                    String sourceText = sourceFile.printAll();
                    Pattern propRefPattern = Pattern.compile("\\$\\{?([a-zA-Z][a-zA-Z0-9_]*)\\}?");
                    Matcher propMatcher = propRefPattern.matcher(sourceText);
                    while (propMatcher.find()) {
                        String propName = propMatcher.group(1);
                        acc.propertyNamesToRemove.add(propName);
                    }
                    GradleDependency.Matcher matcher = new GradleDependency.Matcher();
                    return matcher.asVisitor((dep, ctx2) -> {
                        if (!PROJECT_MATCHER.matches((MethodCall)dep.getTree()) && !"project".equals(((J.MethodInvocation)dep.getTree()).getSimpleName())) {
                            String groupId = dep.getDeclaredGroupId();
                            String artifactId = dep.getDeclaredArtifactId();
                            String version = dep.getDeclaredVersion();
                            String configurationName = dep.getConfigurationName();
                            if (groupId != null && artifactId != null && version != null) {
                                acc2.configurations.add(configurationName);
                                String versionVariable = dep.getVersionVariable();
                                if (versionVariable != null) {
                                    acc2.propertyNamesToRemove.add(versionVariable);
                                }
                                String depKey = groupId + ":" + artifactId + ":" + version;
                                DependencyInfo depInfo = new DependencyInfo(groupId, artifactId, version, configurationName);
                                acc2.dependencies.put(depKey, depInfo);
                            }
                        }
                        return dep.getTree();
                    }).visitNonNull((Tree)sourceFile, (Object)ctx);
                }
                return tree;
            }
        });
    }

    private static String extractStringValue(Expression expr) {
        if (expr instanceof J.Literal) {
            J.Literal literal = (J.Literal)expr;
            if (literal.getValue() instanceof String) {
                return (String)literal.getValue();
            }
        } else if (expr instanceof J.Identifier) {
            return ((J.Identifier)expr).getSimpleName();
        }
        return null;
    }

    private static void extractDependencyCoordinate(String key, String value, DependencyCoordinates coords) {
        if ("group".equals(key)) {
            coords.group = value;
        } else if ("name".equals(key)) {
            coords.artifact = value;
        } else if ("version".equals(key)) {
            coords.version = value;
        }
    }

    public Collection<? extends SourceFile> generate(DependencyAccumulator acc, ExecutionContext ctx) {
        if (acc.dependencies.isEmpty() || acc.catalogExists) {
            return Collections.emptyList();
        }
        String tomlContent = this.generateVersionCatalogContent(acc);
        TomlParser parser = TomlParser.builder().build();
        Toml.Document versionCatalog = parser.parse(ctx, new String[]{tomlContent}).findFirst().map(sourceFile -> (Toml.Document)sourceFile).map(doc -> doc.withSourcePath(Paths.get(CATALOG_PATH, new String[0]))).orElseThrow(() -> new IllegalStateException("Failed to create version catalog file"));
        return Collections.singletonList(versionCatalog);
    }

    private String generateVersionCatalogContent(DependencyAccumulator acc) {
        DependencyInfo dep;
        StringBuilder sb = new StringBuilder();
        sb.append("[versions]\n");
        LinkedHashMap<String, String> versionRefs = new LinkedHashMap<String, String>();
        LinkedHashMap<String, DependencyInfo> uniqueDeps = new LinkedHashMap<String, DependencyInfo>();
        for (Map.Entry<String, DependencyInfo> entry : acc.dependencies.entrySet()) {
            dep = entry.getValue();
            String key = dep.gav.getGroupId() + ":" + dep.gav.getArtifactId();
            if (uniqueDeps.containsKey(key)) continue;
            String resolvedVersion = dep.gav.getVersion();
            if (acc.propertyValues.containsKey(dep.gav.getVersion())) {
                resolvedVersion = acc.propertyValues.get(dep.gav.getVersion());
            }
            DependencyInfo resolvedDep = new DependencyInfo(dep.gav.getGroupId(), dep.gav.getArtifactId(), resolvedVersion, dep.configuration);
            uniqueDeps.put(key, resolvedDep);
            String versionKey = resolvedDep.getTomlAliasName();
            versionRefs.put(key, versionKey);
            sb.append(versionKey).append(" = \"").append(resolvedVersion).append("\"\n");
        }
        sb.append("\n[libraries]\n");
        for (Map.Entry<String, DependencyInfo> entry : uniqueDeps.entrySet()) {
            dep = entry.getValue();
            String alias = dep.getTomlAliasName();
            String versionRef = (String)versionRefs.get(entry.getKey());
            sb.append(alias).append(" = { ");
            sb.append("group = \"").append(dep.gav.getGroupId()).append("\", ");
            sb.append("name = \"").append(dep.gav.getArtifactId()).append("\", ");
            sb.append("version.ref = \"").append(versionRef).append("\"");
            sb.append(" }\n");
        }
        return sb.toString();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final DependencyAccumulator acc) {
        if (acc.dependencies.isEmpty()) {
            return TreeVisitor.noop();
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    if (sourceFile.getSourcePath().toString().endsWith(MigrateDependenciesToVersionCatalog.GRADLE_PROPERTIES) && sourceFile instanceof Properties.File) {
                        return new PropertiesFileVisitor(acc).visitNonNull((Tree)sourceFile, ctx);
                    }
                    if (sourceFile.getSourcePath().toString().endsWith(".gradle")) {
                        return new GradleFileVisitor(acc).visitNonNull((Tree)sourceFile, ctx);
                    }
                    if (sourceFile.getSourcePath().toString().endsWith(".gradle.kts")) {
                        return new KotlinGradleFileVisitor(acc).visitNonNull((Tree)sourceFile, ctx);
                    }
                }
                return tree;
            }
        };
    }

    @Generated
    public MigrateDependenciesToVersionCatalog() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "MigrateDependenciesToVersionCatalog()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateDependenciesToVersionCatalog)) {
            return false;
        }
        MigrateDependenciesToVersionCatalog other = (MigrateDependenciesToVersionCatalog)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof MigrateDependenciesToVersionCatalog;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    static class DependencyCoordinates {
        String group;
        String artifact;
        String version;

        DependencyCoordinates() {
        }

        boolean isComplete() {
            return this.group != null && this.artifact != null && this.version != null;
        }
    }

    static class DependencyAccumulator {
        final Map<String, DependencyInfo> dependencies = new LinkedHashMap<String, DependencyInfo>();
        final Set<String> configurations = new LinkedHashSet<String>();
        final Set<String> propertyNamesToRemove = new LinkedHashSet<String>();
        final Map<String, String> propertyValues = new LinkedHashMap<String, String>();
        boolean catalogExists = false;

        DependencyAccumulator() {
        }
    }

    static class DependencyInfo {
        final GroupArtifactVersion gav;
        final String configuration;

        DependencyInfo(String group, String artifact, String version, String configuration) {
            this.gav = new GroupArtifactVersion(group, artifact, version);
            this.configuration = configuration;
        }

        String getTomlAliasName() {
            return this.gav.getArtifactId().toLowerCase().replaceAll("[^a-z0-9-]", "-").replaceAll("-+", "-").replaceAll("^-|-$", "");
        }

        String getAliasName() {
            String cleaned = this.getTomlAliasName();
            String[] parts = cleaned.split("-");
            StringBuilder result = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i].length() <= 0) continue;
                result.append(Character.toUpperCase(parts[i].charAt(0)));
                if (parts[i].length() <= 1) continue;
                result.append(parts[i].substring(1));
            }
            return result.toString();
        }
    }

    private class PropertiesFileVisitor
    extends PropertiesVisitor<ExecutionContext> {
        private final DependencyAccumulator acc;

        PropertiesFileVisitor(DependencyAccumulator acc) {
            this.acc = acc;
        }

        public Properties visitFile(Properties.File file, ExecutionContext ctx) {
            Properties.File f = (Properties.File)super.visitFile(file, (Object)ctx);
            if (this.acc.propertyNamesToRemove.isEmpty()) {
                return f;
            }
            Properties.File mapped = f.withContent(ListUtils.map((List)f.getContent(), content -> {
                Properties.Entry entry;
                if (content instanceof Properties.Entry && this.acc.propertyNamesToRemove.contains((entry = (Properties.Entry)content).getKey())) {
                    return null;
                }
                return content;
            }));
            if (f != mapped) {
                return mapped.withContent(ListUtils.mapFirst((List)mapped.getContent(), c -> (Properties.Content)c.withPrefix("")));
            }
            return mapped;
        }
    }

    private class KotlinGradleFileVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final DependencyAccumulator acc;
        private boolean removedPropertyDelegations = false;

        KotlinGradleFileVisitor(DependencyAccumulator acc) {
            this.acc = acc;
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J.VariableDeclarations vd = super.visitVariableDeclarations(multiVariable, (Object)ctx);
            for (J.VariableDeclarations.NamedVariable variable : vd.getVariables()) {
                J.Identifier init;
                String propertyName = variable.getSimpleName();
                if (!this.acc.propertyNamesToRemove.contains(propertyName) || !(variable.getInitializer() instanceof J.Identifier) || !"project".equals((init = (J.Identifier)variable.getInitializer()).getSimpleName())) continue;
                this.removedPropertyDelegations = true;
                return null;
            }
            return vd;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            String methodName;
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (this.removedPropertyDelegations) {
                Space prefix = m.getPrefix();
                String whitespace = prefix.getWhitespace();
                int newlineCount = 0;
                int lastNewlineIndex = -1;
                for (int i = 0; i < whitespace.length(); ++i) {
                    if (whitespace.charAt(i) == '\n') {
                        ++newlineCount;
                        lastNewlineIndex = i;
                        continue;
                    }
                    if (whitespace.charAt(i) != '\r') break;
                }
                if (newlineCount >= 2) {
                    String remainingWhitespace = lastNewlineIndex + 1 < whitespace.length() ? whitespace.substring(lastNewlineIndex + 1) : "";
                    String normalized = "\n" + remainingWhitespace;
                    m = m.withPrefix(prefix.withWhitespace(normalized));
                    this.removedPropertyDelegations = false;
                }
            }
            if (m.getMethodType() != null && PROJECT_MATCHER.matches((MethodCall)m)) {
                return m;
            }
            if (m.getMethodType() == null && "project".equals(m.getSimpleName())) {
                return m;
            }
            if (m.getMethodType() != null && !DEPENDENCY_DSL_MATCHER.matches((MethodCall)m)) {
                return m;
            }
            if (m.getArguments() != null && !m.getArguments().isEmpty() && this.acc.configurations.contains(methodName = m.getSimpleName())) {
                DependencyCoordinates coords = new DependencyCoordinates();
                boolean isMapNotation = false;
                for (Expression arg : m.getArguments()) {
                    if (!(arg instanceof J.Assignment)) continue;
                    isMapNotation = true;
                    J.Assignment assignment = (J.Assignment)arg;
                    if (!(assignment.getVariable() instanceof J.Identifier)) continue;
                    String key = ((J.Identifier)assignment.getVariable()).getSimpleName();
                    String value = MigrateDependenciesToVersionCatalog.extractStringValue(assignment.getAssignment());
                    MigrateDependenciesToVersionCatalog.extractDependencyCoordinate(key, value, coords);
                }
                if (isMapNotation && coords.isComplete()) {
                    String depKey = coords.group + ":" + coords.artifact + ":" + coords.version;
                    DependencyInfo dep = this.acc.dependencies.get(depKey);
                    if (dep == null) {
                        for (DependencyInfo candidate : this.acc.dependencies.values()) {
                            if (!candidate.gav.getGroupId().equals(coords.group) || !candidate.gav.getArtifactId().equals(coords.artifact)) continue;
                            dep = candidate;
                            break;
                        }
                    }
                    if (dep != null) {
                        Space prefixSpace = m.getArguments().isEmpty() ? Space.EMPTY : ((Expression)m.getArguments().get(0)).getPrefix();
                        J.Identifier libs = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "libs", null, null);
                        J.FieldAccess catalogRef = new J.FieldAccess(Tree.randomId(), prefixSpace, Markers.EMPTY, (Expression)libs, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), dep.getAliasName(), null, null), Markers.EMPTY), null);
                        m = m.withArguments(Collections.singletonList(catalogRef));
                    }
                } else {
                    ArrayList<Expression> newArgs = new ArrayList<Expression>();
                    boolean changed = false;
                    for (Expression arg : m.getArguments()) {
                        Expression newArg = this.transformDependencyToVersionCatalog(arg, m, this.acc);
                        if (newArg != arg) {
                            changed = true;
                        }
                        newArgs.add(newArg);
                    }
                    if (changed) {
                        m = m.withArguments(newArgs);
                    }
                }
            }
            return m;
        }

        private Expression transformDependencyToVersionCatalog(Expression arg, J.MethodInvocation methodInvocation, DependencyAccumulator acc) {
            String firstPart;
            String[] parts;
            K.StringTemplate template;
            List strings;
            if (arg instanceof J.Literal) {
                String depString;
                DependencyInfo dep;
                J.Literal literal = (J.Literal)arg;
                if (literal.getValue() instanceof String && (dep = acc.dependencies.get(depString = (String)literal.getValue())) != null) {
                    J.Identifier libs = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "libs", null, null);
                    return new J.FieldAccess(Tree.randomId(), literal.getPrefix(), Markers.EMPTY, (Expression)libs, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), dep.getAliasName(), null, null), Markers.EMPTY), null);
                }
            } else if (arg instanceof K.StringTemplate && (strings = (template = (K.StringTemplate)arg).getStrings()).size() >= 2 && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null && (parts = (firstPart = (String)((J.Literal)strings.get(0)).getValue()).split(":", -1)).length >= 2) {
                String group = parts[0];
                String artifact = parts[1];
                for (DependencyInfo dep : acc.dependencies.values()) {
                    if (!dep.gav.getGroupId().equals(group) || !dep.gav.getArtifactId().equals(artifact)) continue;
                    J.Identifier libs = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "libs", null, null);
                    return new J.FieldAccess(Tree.randomId(), template.getPrefix(), Markers.EMPTY, (Expression)libs, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), dep.getAliasName(), null, null), Markers.EMPTY), null);
                }
            }
            return arg;
        }
    }

    private class GradleFileVisitor
    extends GroovyIsoVisitor<ExecutionContext> {
        private final DependencyAccumulator acc;

        GradleFileVisitor(DependencyAccumulator acc) {
            this.acc = acc;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            String methodName;
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (PROJECT_MATCHER.matches((MethodCall)m)) {
                return m;
            }
            if (!DEPENDENCY_DSL_MATCHER.matches((MethodCall)m)) {
                return m;
            }
            if (m.getArguments() != null && !m.getArguments().isEmpty() && this.acc.configurations.contains(methodName = m.getSimpleName())) {
                DependencyCoordinates coords = new DependencyCoordinates();
                boolean isMapNotation = false;
                for (Expression arg : m.getArguments()) {
                    if (!(arg instanceof G.MapEntry)) continue;
                    isMapNotation = true;
                    G.MapEntry entry = (G.MapEntry)arg;
                    String key = MigrateDependenciesToVersionCatalog.extractStringValue(entry.getKey());
                    String value = MigrateDependenciesToVersionCatalog.extractStringValue(entry.getValue());
                    MigrateDependenciesToVersionCatalog.extractDependencyCoordinate(key, value, coords);
                }
                if (isMapNotation && coords.isComplete()) {
                    String depKey = coords.group + ":" + coords.artifact + ":" + coords.version;
                    DependencyInfo dep = this.acc.dependencies.get(depKey);
                    if (dep == null) {
                        for (DependencyInfo candidate : this.acc.dependencies.values()) {
                            if (!candidate.gav.getGroupId().equals(coords.group) || !candidate.gav.getArtifactId().equals(coords.artifact)) continue;
                            dep = candidate;
                            break;
                        }
                    }
                    if (dep != null) {
                        Space prefixSpace = m.getArguments().isEmpty() ? Space.EMPTY : ((Expression)m.getArguments().get(0)).getPrefix();
                        J.Identifier libs = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "libs", null, null);
                        J.FieldAccess catalogRef = new J.FieldAccess(Tree.randomId(), prefixSpace, new Markers(Tree.randomId(), Collections.singletonList(new OmitParentheses(Tree.randomId()))), (Expression)libs, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), dep.getAliasName(), null, null), Markers.EMPTY), null);
                        m = m.withArguments(Collections.singletonList(catalogRef));
                    }
                } else {
                    ArrayList<Expression> newArgs = new ArrayList<Expression>();
                    boolean changed = false;
                    for (Expression arg : m.getArguments()) {
                        Expression newArg = this.transformDependencyToVersionCatalog(arg, m, this.acc);
                        if (newArg != arg) {
                            changed = true;
                        }
                        newArgs.add(newArg);
                    }
                    if (changed) {
                        m = m.withArguments(newArgs);
                    }
                }
            }
            return m;
        }

        private Expression transformDependencyToVersionCatalog(Expression arg, J.MethodInvocation methodInvocation, DependencyAccumulator acc) {
            if (arg instanceof J.Literal) {
                String depString;
                DependencyInfo dep;
                J.Literal literal = (J.Literal)arg;
                if (literal.getValue() instanceof String && (dep = acc.dependencies.get(depString = (String)literal.getValue())) != null) {
                    boolean hasMultipleArgs = methodInvocation.getArguments().size() > 1;
                    Expression catalogRef = (Expression)JavaTemplate.builder((String)"libs.#{}").build().apply(new Cursor(this.getCursor(), (Object)arg), arg.getCoordinates().replace(), new Object[]{dep.getAliasName()});
                    catalogRef = (Expression)catalogRef.withPrefix(literal.getPrefix());
                    if (!hasMultipleArgs) {
                        catalogRef = (Expression)catalogRef.withMarkers(catalogRef.getMarkers().add((Marker)new OmitParentheses(Tree.randomId())));
                    }
                    return catalogRef;
                }
            } else if (arg instanceof G.GString) {
                String firstPart;
                String[] parts;
                G.GString gstring = (G.GString)arg;
                List strings = gstring.getStrings();
                if (strings.size() >= 2 && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null && (parts = (firstPart = (String)((J.Literal)strings.get(0)).getValue()).split(":", -1)).length >= 2) {
                    String group = parts[0];
                    String artifact = parts[1];
                    for (DependencyInfo dep : acc.dependencies.values()) {
                        if (!dep.gav.getGroupId().equals(group) || !dep.gav.getArtifactId().equals(artifact)) continue;
                        boolean hasMultipleArgs = methodInvocation.getArguments().size() > 1;
                        Expression catalogRef = (Expression)JavaTemplate.builder((String)"libs.#{}").build().apply(new Cursor(this.getCursor(), (Object)arg), arg.getCoordinates().replace(), new Object[]{dep.getAliasName()});
                        catalogRef = (Expression)catalogRef.withPrefix(gstring.getPrefix());
                        if (!hasMultipleArgs) {
                            catalogRef = (Expression)catalogRef.withMarkers(catalogRef.getMarkers().add((Marker)new OmitParentheses(Tree.randomId())));
                        }
                        return catalogRef;
                    }
                }
            } else if (arg instanceof G.MapLiteral) {
                G.MapLiteral map = (G.MapLiteral)arg;
                DependencyCoordinates coords = new DependencyCoordinates();
                for (G.MapEntry entry : map.getElements()) {
                    String key = MigrateDependenciesToVersionCatalog.extractStringValue(entry.getKey());
                    String value = MigrateDependenciesToVersionCatalog.extractStringValue(entry.getValue());
                    MigrateDependenciesToVersionCatalog.extractDependencyCoordinate(key, value, coords);
                }
                if (coords.isComplete()) {
                    String depKey = coords.group + ":" + coords.artifact + ":" + coords.version;
                    DependencyInfo dep = acc.dependencies.get(depKey);
                    if (dep == null) {
                        for (DependencyInfo candidate : acc.dependencies.values()) {
                            if (!candidate.gav.getGroupId().equals(coords.group) || !candidate.gav.getArtifactId().equals(coords.artifact)) continue;
                            dep = candidate;
                            break;
                        }
                    }
                    if (dep != null) {
                        boolean hasMultipleArgs = methodInvocation.getArguments().size() > 1;
                        J.Identifier libs = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "libs", null, null);
                        Markers markers = hasMultipleArgs ? Markers.EMPTY : new Markers(Tree.randomId(), Collections.singletonList(new OmitParentheses(Tree.randomId())));
                        return new J.FieldAccess(Tree.randomId(), map.getPrefix(), markers, (Expression)libs, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), dep.getAliasName(), null, null), Markers.EMPTY), null);
                    }
                }
            }
            return arg;
        }
    }
}

