/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.tree.K;

public final class ReplaceCharToIntWithCode
extends Recipe {
    private static final MethodMatcher CHAR_TO_INT_METHOD_MATCHER = new MethodMatcher("kotlin.Char toInt()");
    @Nullable
    private static J.FieldAccess charCodeTemplate;

    public String getDisplayName() {
        return "Replace `Char#toInt()` with `Char#code`";
    }

    public String getDescription() {
        return "Replace the usage of the deprecated `Char#toInt()` with `Char#code`. Please ensure that your Kotlin version is 1.5 or later to support the `Char#code` property. Note that the current implementation does not perform a Kotlin version check.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (CHAR_TO_INT_METHOD_MATCHER.matches((MethodCall)method) && method.getSelect() != null) {
                    J.FieldAccess codeTemplate = ReplaceCharToIntWithCode.getCharCodeTemplate();
                    return codeTemplate.withTarget(method.getSelect()).withPrefix(method.getPrefix());
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    private static J.FieldAccess getCharCodeTemplate() {
        if (charCodeTemplate == null) {
            K.CompilationUnit kcu = KotlinParser.builder().build().parse("fun method(c : Char) {c.code}").map(K.CompilationUnit.class::cast).findFirst().get();
            charCodeTemplate = (J.FieldAccess)((J.MethodDeclaration)kcu.getStatements().get(0)).getBody().getStatements().get(0);
        }
        return charCodeTemplate;
    }

    public String toString() {
        return "ReplaceCharToIntWithCode()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceCharToIntWithCode)) {
            return false;
        }
        ReplaceCharToIntWithCode other = (ReplaceCharToIntWithCode)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplaceCharToIntWithCode;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

