/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.java.tree.VariableDeclarator;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KContainer;
import org.openrewrite.kotlin.tree.KLeftPadded;
import org.openrewrite.kotlin.tree.KRightPadded;
import org.openrewrite.kotlin.tree.KSpace;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class MergeSpacesVisitor
extends KotlinVisitor<Object> {
    @Override
    public J visitCompilationUnit(K.CompilationUnit cu, @Nullable Object ctx) {
        if (cu == ctx || !(ctx instanceof K.CompilationUnit)) {
            return cu;
        }
        K.CompilationUnit newCu = (K.CompilationUnit)ctx;
        K.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, (Object)newCu.getPrefix()));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), newCu.getMarkers()));
        if ((c = c.withAnnotations(ListUtils.map(c.getAnnotations(), (index, e) -> (J.Annotation)this.visitAndCast((Tree)e, newCu.getAnnotations().get((int)index))))).getPadding().getPackageDeclaration() != null) {
            c = c.getPadding().withPackageDeclaration(this.visitRightPadded(c.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, newCu.getPadding().getPackageDeclaration()));
        }
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), (index, t) -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, (Object)newCu.getPadding().getImports().get((int)index))));
        c = c.getPadding().withStatements(ListUtils.map(c.getPadding().getStatements(), (index, rp) -> rp.withElement((Object)Objects.requireNonNull((Statement)this.visitAndCast((Tree)rp.getElement(), newCu.getPadding().getStatements().get((int)index).getElement()))).withAfter(this.visitSpace(rp.getAfter(), Space.Location.BLOCK_STATEMENT_SUFFIX, (Object)newCu.getPadding().getStatements().get((int)index).getAfter()))));
        return c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, (Object)newCu.getEof()));
    }

    @Override
    public J visitAnnotatedExpression(K.AnnotatedExpression annotatedExpression, @Nullable Object ctx) {
        if (annotatedExpression == ctx || !(ctx instanceof K.AnnotatedExpression)) {
            return annotatedExpression;
        }
        K.AnnotatedExpression newAnnotatedExpression = (K.AnnotatedExpression)ctx;
        K.AnnotatedExpression ae = annotatedExpression;
        ae = ae.withMarkers(this.visitMarkers(ae.getMarkers(), newAnnotatedExpression.getMarkers()));
        Expression temp = (Expression)this.visitExpression(ae = ae.withAnnotations(ListUtils.map(ae.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newAnnotatedExpression.getAnnotations().get((int)index)))), newAnnotatedExpression);
        if (!(temp instanceof K.AnnotatedExpression)) {
            return temp;
        }
        ae = (K.AnnotatedExpression)temp;
        return ae;
    }

    @Override
    public J visitAnnotationType(K.AnnotationType annotationType, @Nullable Object ctx) {
        if (annotationType == ctx || !(ctx instanceof K.AnnotationType)) {
            return annotationType;
        }
        K.AnnotationType newAnnotationType = (K.AnnotationType)ctx;
        K.AnnotationType a = annotationType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATION_PREFIX, (Object)newAnnotationType.getPrefix()));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAnnotationType.getMarkers()));
        a = a.getPadding().withUseSite(this.visitRightPadded(a.getPadding().getUseSite(), JRightPadded.Location.ANNOTATION_ARGUMENT, newAnnotationType.getPadding().getUseSite()));
        return a.withCallee((J.Annotation)this.visitAndCast((Tree)a.getCallee(), newAnnotationType.getCallee()));
    }

    @Override
    public J visitBinary(K.Binary binary, @Nullable Object ctx) {
        if (binary == ctx || !(ctx instanceof K.Binary)) {
            return binary;
        }
        K.Binary newBinary = (K.Binary)ctx;
        K.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), KSpace.Location.BINARY_PREFIX, (Object)newBinary.getPrefix()));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), newBinary.getMarkers())), newBinary);
        if (!(temp instanceof K.Binary)) {
            return temp;
        }
        b = (K.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), newBinary.getLeft()));
        b = b.getPadding().withOperator(this.visitLeftPadded((JLeftPadded<T>)((JLeftPadded)b.getPadding().getOperator()), KLeftPadded.Location.BINARY_OPERATOR, (Object)newBinary.getPadding().getOperator()));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), newBinary.getRight()));
        return b.withType(this.visitType(b.getType(), newBinary.getType()));
    }

    @Override
    public J visitClassDeclaration(K.ClassDeclaration classDeclaration, @Nullable Object ctx) {
        if (classDeclaration == ctx || !(ctx instanceof K.ClassDeclaration)) {
            return classDeclaration;
        }
        K.ClassDeclaration newClassDeclaration = (K.ClassDeclaration)ctx;
        K.ClassDeclaration c = classDeclaration;
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), newClassDeclaration.getMarkers()));
        c = c.withClassDeclaration((J.ClassDeclaration)this.visitAndCast((Tree)c.getClassDeclaration(), newClassDeclaration.getClassDeclaration()));
        return c.withTypeConstraints((K.TypeConstraints)this.visitAndCast((Tree)c.getTypeConstraints(), newClassDeclaration.getTypeConstraints()));
    }

    @Override
    public J visitConstructor(K.Constructor constructor, @Nullable Object ctx) {
        if (constructor == ctx || !(ctx instanceof K.Constructor)) {
            return constructor;
        }
        K.Constructor newConstructor = (K.Constructor)ctx;
        K.Constructor c = constructor;
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), newConstructor.getMarkers()));
        c = c.withMethodDeclaration((J.MethodDeclaration)this.visitAndCast((Tree)c.getMethodDeclaration(), newConstructor.getMethodDeclaration()));
        return c.getPadding().withInvocation(this.visitLeftPadded((JLeftPadded<T>)((JLeftPadded)c.getPadding().getInvocation()), newConstructor.getPadding().getInvocation()));
    }

    @Override
    public J visitConstructorInvocation(K.ConstructorInvocation constructorInvocation, @Nullable Object ctx) {
        if (constructorInvocation == ctx || !(ctx instanceof K.ConstructorInvocation)) {
            return constructorInvocation;
        }
        K.ConstructorInvocation newConstructorInvocation = (K.ConstructorInvocation)ctx;
        K.ConstructorInvocation d = constructorInvocation;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), KSpace.Location.CONSTRUCTOR_INVOCATION_PREFIX, (Object)newConstructorInvocation.getPrefix()));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), newConstructorInvocation.getMarkers()));
        d = d.withTypeTree((TypeTree)this.visitAndCast((Tree)d.getTypeTree(), newConstructorInvocation.getTypeTree()));
        return d.getPadding().withArguments(this.visitContainer(d.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, newConstructorInvocation.getPadding().getArguments()));
    }

    @Override
    public J visitDelegatedSuperType(K.DelegatedSuperType delegatedSuperType, @Nullable Object ctx) {
        if (delegatedSuperType == ctx || !(ctx instanceof K.DelegatedSuperType)) {
            return delegatedSuperType;
        }
        K.DelegatedSuperType newDelegatedSuperType = (K.DelegatedSuperType)ctx;
        K.DelegatedSuperType d = delegatedSuperType;
        d = d.withBy(this.visitSpace(d.getBy(), KSpace.Location.DELEGATED_SUPER_TYPE_BY, (Object)newDelegatedSuperType.getBy()));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), newDelegatedSuperType.getMarkers()));
        d = d.withTypeTree((TypeTree)this.visitAndCast((Tree)d.getTypeTree(), newDelegatedSuperType.getTypeTree()));
        return d.withDelegate((Expression)this.visitAndCast((Tree)d.getDelegate(), newDelegatedSuperType.getDelegate()));
    }

    @Override
    public J visitDestructuringDeclaration(K.DestructuringDeclaration destructuringDeclaration, @Nullable Object ctx) {
        if (destructuringDeclaration == ctx || !(ctx instanceof K.DestructuringDeclaration)) {
            return destructuringDeclaration;
        }
        K.DestructuringDeclaration newDestructuringDeclaration = (K.DestructuringDeclaration)ctx;
        K.DestructuringDeclaration d = destructuringDeclaration;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), KSpace.Location.DESTRUCTURING_DECLARATION_PREFIX, (Object)newDestructuringDeclaration.getPrefix()));
        Statement temp = (Statement)this.visitStatement(d = d.withMarkers(this.visitMarkers(d.getMarkers(), newDestructuringDeclaration.getMarkers())), newDestructuringDeclaration);
        if (!(temp instanceof K.DestructuringDeclaration)) {
            return temp;
        }
        d = (K.DestructuringDeclaration)temp;
        d = d.withInitializer((J.VariableDeclarations)this.visitAndCast((Tree)d.getInitializer(), newDestructuringDeclaration.getInitializer()));
        return d.getPadding().withDestructAssignments(this.visitContainer((JContainer<J2>)((JContainer)d.getPadding().getDestructAssignments()), KContainer.Location.DESTRUCT_ASSIGNMENTS, (Object)newDestructuringDeclaration.getPadding().getDestructAssignments()));
    }

    @Override
    public J visitFunctionType(K.FunctionType functionType2, @Nullable Object ctx) {
        if (functionType2 == ctx || !(ctx instanceof K.FunctionType)) {
            return functionType2;
        }
        K.FunctionType newFunctionType = (K.FunctionType)ctx;
        K.FunctionType f2 = functionType2;
        f2 = f2.withPrefix(this.visitSpace(f2.getPrefix(), KSpace.Location.FUNCTION_TYPE_PREFIX, (Object)newFunctionType.getPrefix()));
        f2 = f2.withMarkers(this.visitMarkers(f2.getMarkers(), newFunctionType.getMarkers()));
        f2 = f2.withLeadingAnnotations(ListUtils.map(f2.getLeadingAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newFunctionType.getLeadingAnnotations().get((int)index))));
        f2 = f2.withModifiers(ListUtils.map(f2.getModifiers(), (index, e) -> (J.Modifier)this.visitAndCast((Tree)e, newFunctionType.getModifiers().get((int)index))));
        if ((f2 = f2.withReceiver(this.visitRightPadded((JRightPadded<T>)((JRightPadded)f2.getReceiver()), newFunctionType.getReceiver()))).getPadding().getParameters() != null) {
            f2 = f2.getPadding().withParameters(this.visitContainer((JContainer<J2>)((JContainer)f2.getPadding().getParameters()), KContainer.Location.FUNCTION_TYPE_PARAMETERS, (Object)newFunctionType.getPadding().getParameters()));
        }
        return f2.withReturnType(this.visitRightPadded((JRightPadded<T>)((JRightPadded)f2.getReturnType()), newFunctionType.getReturnType()));
    }

    @Override
    public J visitFunctionTypeParameter(K.FunctionType.Parameter parameter, @Nullable Object ctx) {
        if (parameter == ctx || !(ctx instanceof K.FunctionType.Parameter)) {
            return parameter;
        }
        K.FunctionType.Parameter newParameter = (K.FunctionType.Parameter)ctx;
        K.FunctionType.Parameter pa = parameter;
        if ((pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), newParameter.getMarkers()))).getName() != null) {
            pa = pa.withName((J.Identifier)this.visitAndCast((Tree)pa.getName(), newParameter.getName()));
        }
        return pa.withParameterType((TypeTree)this.visitAndCast((Tree)pa.getParameterType(), newParameter.getParameterType()));
    }

    @Override
    public J visitListLiteral(K.ListLiteral listLiteral, @Nullable Object ctx) {
        if (listLiteral == ctx || !(ctx instanceof K.ListLiteral)) {
            return listLiteral;
        }
        K.ListLiteral newListLiteral = (K.ListLiteral)ctx;
        K.ListLiteral l = listLiteral;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), KSpace.Location.LIST_LITERAL_PREFIX, (Object)newListLiteral.getPrefix()));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), newListLiteral.getMarkers())), newListLiteral);
        if (!(temp instanceof K.ListLiteral)) {
            return temp;
        }
        l = (K.ListLiteral)temp;
        l = l.getPadding().withElements(this.visitContainer((JContainer<J2>)((JContainer)l.getPadding().getElements()), KContainer.Location.LIST_LITERAL_ELEMENTS, (Object)newListLiteral.getPadding().getElements()));
        return l.withType(this.visitType(l.getType(), newListLiteral.getType()));
    }

    @Override
    public J visitMethodDeclaration(K.MethodDeclaration methodDeclaration, @Nullable Object ctx) {
        if (methodDeclaration == ctx || !(ctx instanceof K.MethodDeclaration)) {
            return methodDeclaration;
        }
        K.MethodDeclaration newMethodDeclaration = (K.MethodDeclaration)ctx;
        K.MethodDeclaration m = methodDeclaration;
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMethodDeclaration.getMarkers()));
        m = m.withMethodDeclaration((J.MethodDeclaration)this.visitAndCast((Tree)m.getMethodDeclaration(), newMethodDeclaration.getMethodDeclaration()));
        return m.withTypeConstraints((K.TypeConstraints)this.visitAndCast((Tree)m.getTypeConstraints(), newMethodDeclaration.getTypeConstraints()));
    }

    @Override
    public J visitMultiAnnotationType(K.MultiAnnotationType multiAnnotationType, @Nullable Object ctx) {
        if (multiAnnotationType == ctx || !(ctx instanceof K.MultiAnnotationType)) {
            return multiAnnotationType;
        }
        K.MultiAnnotationType newMultiAnnotationType = (K.MultiAnnotationType)ctx;
        K.MultiAnnotationType m = multiAnnotationType;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.ANNOTATION_PREFIX, (Object)newMultiAnnotationType.getPrefix()));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMultiAnnotationType.getMarkers()));
        m = m.getPadding().withUseSite(this.visitRightPadded(m.getPadding().getUseSite(), JRightPadded.Location.ANNOTATION_ARGUMENT, newMultiAnnotationType.getPadding().getUseSite()));
        return m.withAnnotations(this.visitContainer((JContainer<J2>)((JContainer)m.getAnnotations()), newMultiAnnotationType.getAnnotations()));
    }

    @Override
    public J visitProperty(K.Property property, @Nullable Object ctx) {
        if (property == ctx || !(ctx instanceof K.Property)) {
            return property;
        }
        K.Property newProperty = (K.Property)ctx;
        K.Property pr = property;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), KSpace.Location.PROPERTY_PREFIX, (Object)newProperty.getPrefix()));
        Statement temp = (Statement)this.visitStatement(pr = pr.withMarkers(this.visitMarkers(pr.getMarkers(), newProperty.getMarkers())), newProperty);
        if (!(temp instanceof K.Property)) {
            return temp;
        }
        pr = (K.Property)temp;
        pr = pr.getPadding().withVariableDeclarations(this.visitRightPadded((JRightPadded<T>)((JRightPadded)pr.getPadding().getVariableDeclarations()), newProperty.getPadding().getVariableDeclarations()));
        pr = pr.getPadding().withReceiver(this.visitRightPadded((JRightPadded<T>)((JRightPadded)pr.getPadding().getReceiver()), newProperty.getPadding().getReceiver()));
        return pr.withAccessors(this.visitContainer((JContainer<J2>)((JContainer)pr.getAccessors()), newProperty.getAccessors()));
    }

    @Override
    public J visitReturn(K.Return return_, @Nullable Object ctx) {
        if (return_ == ctx || !(ctx instanceof K.Return)) {
            return return_;
        }
        K.Return newReturn_ = (K.Return)ctx;
        K.Return r = return_;
        r = (K.Return)r.withPrefix(this.visitSpace(r.getPrefix(), KSpace.Location.RETURN_PREFIX, (Object)newReturn_.getPrefix()));
        Statement temp = (Statement)this.visitStatement(r = (K.Return)r.withMarkers(this.visitMarkers(r.getMarkers(), newReturn_.getMarkers())), newReturn_);
        if (!(temp instanceof K.Return)) {
            return temp;
        }
        r = (K.Return)temp;
        Expression temp2 = (Expression)this.visitExpression(r, newReturn_);
        if (!(temp2 instanceof K.Return)) {
            return temp2;
        }
        r = (K.Return)temp2;
        r = r.withExpression((J.Return)this.visitAndCast((Tree)r.getExpression(), newReturn_.getExpression()));
        return r.withLabel((J.Identifier)this.visitAndCast((Tree)r.getLabel(), newReturn_.getLabel()));
    }

    @Override
    public J visitSpreadArgument(K.SpreadArgument spreadArgument, @Nullable Object ctx) {
        if (spreadArgument == ctx || !(ctx instanceof K.SpreadArgument)) {
            return spreadArgument;
        }
        K.SpreadArgument newSpreadArgument = (K.SpreadArgument)ctx;
        K.SpreadArgument s = spreadArgument;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), KSpace.Location.SPREAD_ARGUMENT_PREFIX, (Object)newSpreadArgument.getPrefix()));
        Expression temp = (Expression)this.visitExpression(s = s.withMarkers(this.visitMarkers(s.getMarkers(), newSpreadArgument.getMarkers())), newSpreadArgument);
        if (!(temp instanceof K.SpreadArgument)) {
            return temp;
        }
        s = (K.SpreadArgument)temp;
        return s.withExpression((Expression)this.visitAndCast((Tree)s.getExpression(), newSpreadArgument.getExpression()));
    }

    @Override
    public J visitStringTemplate(K.StringTemplate stringTemplate, @Nullable Object ctx) {
        if (stringTemplate == ctx || !(ctx instanceof K.StringTemplate)) {
            return stringTemplate;
        }
        K.StringTemplate newStringTemplate = (K.StringTemplate)ctx;
        K.StringTemplate k = stringTemplate;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), KSpace.Location.STRING_TEMPLATE_PREFIX, (Object)newStringTemplate.getPrefix()));
        Expression temp = (Expression)this.visitExpression(k = k.withMarkers(this.visitMarkers(k.getMarkers(), newStringTemplate.getMarkers())), newStringTemplate);
        if (!(temp instanceof K.StringTemplate)) {
            return temp;
        }
        k = (K.StringTemplate)temp;
        k = k.withStrings(ListUtils.map(k.getStrings(), (index, s) -> (J)this.visit((Tree)s, newStringTemplate.getStrings().get((int)index))));
        return k.withType(this.visitType(k.getType(), newStringTemplate.getType()));
    }

    @Override
    public J visitStringTemplateExpression(K.StringTemplate.Expression expression, @Nullable Object ctx) {
        if (expression == ctx || !(ctx instanceof K.StringTemplate.Expression)) {
            return expression;
        }
        K.StringTemplate.Expression newExpression = (K.StringTemplate.Expression)ctx;
        K.StringTemplate.Expression v = expression;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), KSpace.Location.STRING_TEMPLATE_EXPRESSION_PREFIX, (Object)newExpression.getPrefix()));
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), newExpression.getMarkers()));
        v = v.withTree((J)this.visit((Tree)v.getTree(), newExpression.getTree()));
        return v.withAfter(this.visitSpace(v.getAfter(), KSpace.Location.STRING_TEMPLATE_EXPRESSION_AFTER, (Object)newExpression.getAfter()));
    }

    @Override
    public J visitThis(K.This aThis, @Nullable Object ctx) {
        if (aThis == ctx || !(ctx instanceof K.This)) {
            return aThis;
        }
        K.This newAThis = (K.This)ctx;
        K.This k = aThis;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), KSpace.Location.THIS_PREFIX, (Object)newAThis.getPrefix()));
        Expression temp = (Expression)this.visitExpression(k = k.withMarkers(this.visitMarkers(k.getMarkers(), newAThis.getMarkers())), newAThis);
        if (!(temp instanceof K.This)) {
            return temp;
        }
        k = (K.This)temp;
        return k.withType(this.visitType(k.getType(), newAThis.getType()));
    }

    @Override
    public J visitTypeAlias(K.TypeAlias typeAlias, @Nullable Object ctx) {
        if (typeAlias == ctx || !(ctx instanceof K.TypeAlias)) {
            return typeAlias;
        }
        K.TypeAlias newTypeAlias = (K.TypeAlias)ctx;
        K.TypeAlias t = typeAlias;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), KSpace.Location.TYPE_ALIAS_PREFIX, (Object)newTypeAlias.getPrefix()));
        Statement temp = (Statement)this.visitStatement(t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTypeAlias.getMarkers())), newTypeAlias);
        if (!(temp instanceof K.TypeAlias)) {
            return temp;
        }
        t = (K.TypeAlias)temp;
        t = t.withLeadingAnnotations(ListUtils.map(t.getLeadingAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newTypeAlias.getLeadingAnnotations().get((int)index))));
        t = t.withModifiers(ListUtils.map(t.getModifiers(), (index, mod) -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, (Object)newTypeAlias.getModifiers().get((int)index).getPrefix()))));
        t = t.withModifiers(ListUtils.map(t.getModifiers(), (index, m) -> (J.Modifier)this.visitAndCast((Tree)m, newTypeAlias.getModifiers().get((int)index))));
        if ((t = t.withName((J.Identifier)this.visitAndCast((Tree)t.getName(), newTypeAlias.getName()))).getPadding().getTypeParameters() != null) {
            t = t.getPadding().withTypeParameters(this.visitContainer(t.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, newTypeAlias.getPadding().getTypeParameters()));
        }
        if (t.getPadding().getInitializer() != null) {
            t = t.getPadding().withInitializer(this.visitLeftPadded((JLeftPadded<T>)((JLeftPadded)t.getPadding().getInitializer()), KLeftPadded.Location.TYPE_ALIAS_INITIALIZER, (Object)newTypeAlias.getPadding().getInitializer()));
        }
        return t.withType(this.visitType(t.getType(), newTypeAlias.getType()));
    }

    @Override
    public J visitTypeConstraints(K.TypeConstraints typeConstraints, @Nullable Object ctx) {
        if (typeConstraints == ctx || !(ctx instanceof K.TypeConstraints)) {
            return typeConstraints;
        }
        K.TypeConstraints newTypeConstraints = (K.TypeConstraints)ctx;
        K.TypeConstraints t = typeConstraints;
        t = (K.TypeConstraints)t.withPrefix(this.visitSpace(t.getPrefix(), KSpace.Location.TYPE_CONSTRAINT_PREFIX, (Object)newTypeConstraints.getPrefix()));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTypeConstraints.getMarkers()));
        return t.getPadding().withConstraints(this.visitContainer((JContainer<J2>)((JContainer)t.getPadding().getConstraints()), newTypeConstraints.getPadding().getConstraints()));
    }

    @Override
    public J visitUnary(K.Unary unary, @Nullable Object ctx) {
        if (unary == ctx || !(ctx instanceof K.Unary)) {
            return unary;
        }
        K.Unary newUnary = (K.Unary)ctx;
        K.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), KSpace.Location.UNARY_PREFIX, (Object)newUnary.getPrefix()));
        Statement temp = (Statement)this.visitStatement(u = u.withMarkers(this.visitMarkers(u.getMarkers(), newUnary.getMarkers())), newUnary);
        if (!(temp instanceof K.Unary)) {
            return temp;
        }
        u = (K.Unary)temp;
        Expression temp2 = (Expression)this.visitExpression(u, newUnary);
        if (!(temp2 instanceof K.Unary)) {
            return temp2;
        }
        u = (K.Unary)temp2;
        u = u.getPadding().withOperator(this.visitLeftPadded(u.getPadding().getOperator(), JLeftPadded.Location.UNARY_OPERATOR, newUnary.getPadding().getOperator()));
        u = u.withExpression((Expression)this.visitAndCast((Tree)u.getExpression(), newUnary.getExpression()));
        return u.withType(this.visitType(u.getType(), newUnary.getType()));
    }

    @Override
    public J visitWhen(K.When when, @Nullable Object ctx) {
        if (when == ctx || !(ctx instanceof K.When)) {
            return when;
        }
        K.When newWhen = (K.When)ctx;
        K.When w = when;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_PREFIX, (Object)newWhen.getPrefix()));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), newWhen.getMarkers())), newWhen);
        if (!(temp instanceof K.When)) {
            return temp;
        }
        w = (K.When)temp;
        w = w.withSelector((J.ControlParentheses<J>)((J.ControlParentheses)this.visitAndCast((Tree)w.getSelector(), newWhen.getSelector())));
        w = w.withBranches((J.Block)this.visitAndCast((Tree)w.getBranches(), newWhen.getBranches()));
        return w.withType(this.visitType(w.getType(), newWhen.getType()));
    }

    @Override
    public J visitWhenBranch(K.WhenBranch whenBranch, @Nullable Object ctx) {
        if (whenBranch == ctx || !(ctx instanceof K.WhenBranch)) {
            return whenBranch;
        }
        K.WhenBranch newWhenBranch = (K.WhenBranch)ctx;
        K.WhenBranch w = whenBranch;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_BRANCH_PREFIX, (Object)newWhenBranch.getPrefix()));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), newWhenBranch.getMarkers())), newWhenBranch);
        if (!(temp instanceof K.WhenBranch)) {
            return temp;
        }
        w = (K.WhenBranch)temp;
        w = w.getPadding().withExpressions(this.visitContainer((JContainer<J2>)((JContainer)w.getPadding().getExpressions()), KContainer.Location.WHEN_BRANCH_EXPRESSION, (Object)newWhenBranch.getPadding().getExpressions()));
        return w.getPadding().withBody(this.visitRightPadded(w.getPadding().getBody(), JRightPadded.Location.CASE_BODY, newWhenBranch.getPadding().getBody()));
    }

    @Override
    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, @Nullable Object ctx) {
        if (right == ctx || !(ctx instanceof JRightPadded)) {
            return right;
        }
        JRightPadded newRight = (JRightPadded)ctx;
        return this.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, (Object)newRight);
    }

    @Override
    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, @Nullable Object ctx) {
        if (left == ctx || !(ctx instanceof JLeftPadded)) {
            return left;
        }
        JLeftPadded newLeft = (JLeftPadded)ctx;
        return this.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, (Object)newLeft);
    }

    @Override
    public Space visitSpace(Space space, KSpace.Location loc, @Nullable Object ctx) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, ctx);
    }

    @Override
    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, @Nullable Object ctx) {
        if (container == ctx || !(ctx instanceof JContainer)) {
            return container;
        }
        JContainer newContainer = (JContainer)ctx;
        return this.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, (Object)newContainer);
    }

    @Override
    public <J2 extends J> @Nullable JContainer<J2> visitContainer(@Nullable JContainer<J2> container, KContainer.Location loc, @Nullable Object ctx) {
        if (container == ctx || !(ctx instanceof JContainer)) {
            return container;
        }
        JContainer newContainer = (JContainer)ctx;
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), (Object)newContainer.getBefore());
        List js = ListUtils.map((List)container.getPadding().getElements(), (index, t) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)t), loc.getElementLocation(), newContainer.getPadding().getElements().get((int)index)));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build((Space)before, (List)js, (Markers)container.getMarkers());
    }

    @Override
    public <T> @Nullable JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, KLeftPadded.Location loc, @Nullable Object ctx) {
        if (left == ctx || !(ctx instanceof JLeftPadded)) {
            return left;
        }
        JLeftPadded newLeft = (JLeftPadded)ctx;
        if (left == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), (Object)newLeft.getBefore());
        Object t = left.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)left.getElement()), newLeft.getElement());
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            if (left.getElement() == null && before == left.getBefore()) {
                return left;
            }
            return null;
        }
        return before == left.getBefore() && t == left.getElement() ? left : new JLeftPadded(before, t, left.getMarkers());
    }

    @Override
    public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, KRightPadded.Location loc, @Nullable Object ctx) {
        if (right == ctx || !(ctx instanceof JRightPadded)) {
            return right;
        }
        JRightPadded newRight = (JRightPadded)ctx;
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)right.getElement()), newRight.getElement());
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), (Object)newRight.getAfter());
        Markers markers = this.visitMarkers(right.getMarkers(), newRight.getMarkers());
        return after == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JRightPadded<T>(t, after, markers);
    }

    @Override
    public <M extends Marker> M visitMarker(Marker marker, @Nullable Object ctx) {
        if (marker == ctx || !(ctx instanceof Marker)) {
            return (M)marker;
        }
        Marker newMarker = (Marker)ctx;
        if (marker instanceof TypeReferencePrefix && newMarker instanceof TypeReferencePrefix) {
            return super.visitMarker(newMarker, ((TypeReferencePrefix)newMarker).getPrefix());
        }
        return super.visitMarker(marker, newMarker);
    }

    public Space visitSpace(@Nullable Space space, Space.Location loc, @Nullable Object ctx) {
        if (space == ctx || !(ctx instanceof Space)) {
            return space;
        }
        Space newSpace = (Space)ctx;
        if (space == null) {
            return newSpace;
        }
        if ((space = space.withWhitespace(newSpace.getWhitespace())).getComments().isEmpty() || space.getComments().size() != newSpace.getComments().size()) {
            return space;
        }
        return space.withComments(ListUtils.map((List)space.getComments(), (index, comment) -> {
            if (comment instanceof Javadoc.DocComment) {
                Javadoc.DocComment docComment = (Javadoc.DocComment)comment;
                if (!(newSpace.getComments().get((int)index) instanceof Javadoc.DocComment)) {
                    return docComment;
                }
                Javadoc.DocComment replaceWith = (Javadoc.DocComment)newSpace.getComments().get((int)index);
                comment = docComment.withBody(ListUtils.map((List)docComment.getBody(), (i, jdoc) -> {
                    if (!(jdoc instanceof Javadoc.LineBreak) || !(replaceWith.getBody().get((int)i) instanceof Javadoc.LineBreak)) {
                        return jdoc;
                    }
                    return ((Javadoc.LineBreak)jdoc).withMargin(((Javadoc.LineBreak)replaceWith.getBody().get((int)i)).getMargin());
                }));
            } else if (comment instanceof TextComment && newSpace.getComments().get((int)index) instanceof TextComment) {
                comment = ((TextComment)comment).withText(((TextComment)newSpace.getComments().get((int)index)).getText());
            }
            return comment.withSuffix(((Comment)newSpace.getComments().get((int)index)).getSuffix());
        }));
    }

    public <N extends NameTree> N visitTypeName(N nameTree, @Nullable Object ctx) {
        NameTree newNameTree = (NameTree)ctx;
        if (nameTree == newNameTree) {
            return nameTree;
        }
        return nameTree;
    }

    private <N extends NameTree> @Nullable JLeftPadded<N> visitTypeName(@Nullable JLeftPadded<N> nameTree, @Nullable Object ctx) {
        JLeftPadded newNameTree = (JLeftPadded)ctx;
        if (nameTree == newNameTree) {
            return nameTree;
        }
        return nameTree == null ? null : nameTree.withElement((Object)this.visitTypeName((NameTree)nameTree.getElement(), newNameTree == null ? null : newNameTree.getElement()));
    }

    private <N extends NameTree> @Nullable JRightPadded<N> visitTypeName(@Nullable JRightPadded<N> nameTree, @Nullable Object ctx) {
        JRightPadded newNameTree = (JRightPadded)ctx;
        if (nameTree == newNameTree) {
            return nameTree;
        }
        return nameTree == null ? null : nameTree.withElement((Object)this.visitTypeName((NameTree)nameTree.getElement(), newNameTree == null ? null : newNameTree.getElement()));
    }

    private <J2 extends J> @Nullable JContainer<J2> visitTypeNames(@Nullable JContainer<J2> nameTrees, @Nullable Object ctx) {
        JContainer newNameTrees = (JContainer)ctx;
        if (nameTrees == newNameTrees) {
            return nameTrees;
        }
        if (nameTrees == null) {
            return null;
        }
        List js = ListUtils.map((List)nameTrees.getPadding().getElements(), (index, t) -> t.getElement() instanceof NameTree ? this.visitTypeName((JRightPadded)t, (Object)(newNameTrees == null ? null : newNameTrees.getPadding().getElements().get((int)index))) : t);
        return js == nameTrees.getPadding().getElements() ? nameTrees : JContainer.build((Space)nameTrees.getBefore(), (List)js, (Markers)Markers.EMPTY);
    }

    public J visitAnnotatedType(J.AnnotatedType annotatedType, @Nullable Object ctx) {
        if (annotatedType == ctx || !(ctx instanceof J.AnnotatedType)) {
            return annotatedType;
        }
        J.AnnotatedType newAnnotatedType = (J.AnnotatedType)ctx;
        J.AnnotatedType a = annotatedType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATED_TYPE_PREFIX, (Object)newAnnotatedType.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAnnotatedType.getMarkers()))), newAnnotatedType);
        if (!(temp instanceof J.AnnotatedType)) {
            return temp;
        }
        a = (J.AnnotatedType)temp;
        a = a.withAnnotations(ListUtils.map((List)a.getAnnotations(), (index, e) -> (J.Annotation)this.visitAndCast((Tree)e, newAnnotatedType.getAnnotations().get((int)index))));
        a = a.withTypeExpression((TypeTree)this.visitAndCast((Tree)a.getTypeExpression(), newAnnotatedType.getTypeExpression()));
        return a.withTypeExpression(this.visitTypeName(a.getTypeExpression(), (Object)newAnnotatedType.getTypeExpression()));
    }

    public J visitAnnotation(J.Annotation annotation, @Nullable Object ctx) {
        if (annotation == ctx || !(ctx instanceof J.Annotation)) {
            return annotation;
        }
        J.Annotation newAnnotation = (J.Annotation)ctx;
        J.Annotation a = annotation;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATION_PREFIX, (Object)newAnnotation.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAnnotation.getMarkers()))), newAnnotation);
        if (!(temp instanceof J.Annotation)) {
            return temp;
        }
        a = (J.Annotation)temp;
        if (a.getPadding().getArguments() != null && newAnnotation.getPadding().getArguments() != null) {
            a = a.getPadding().withArguments(this.visitContainer(a.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, (Object)newAnnotation.getPadding().getArguments()));
        }
        a = a.withAnnotationType((NameTree)this.visitAndCast((Tree)a.getAnnotationType(), newAnnotation.getAnnotationType()));
        return a.withAnnotationType(this.visitTypeName(a.getAnnotationType(), (Object)newAnnotation.getAnnotationType()));
    }

    public J visitArrayAccess(J.ArrayAccess arrayAccess, @Nullable Object ctx) {
        if (arrayAccess == ctx || !(ctx instanceof J.ArrayAccess)) {
            return arrayAccess;
        }
        J.ArrayAccess newArrayAccess = (J.ArrayAccess)ctx;
        J.ArrayAccess a = arrayAccess;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ARRAY_ACCESS_PREFIX, (Object)newArrayAccess.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newArrayAccess.getMarkers()))), newArrayAccess);
        if (!(temp instanceof J.ArrayAccess)) {
            return temp;
        }
        a = (J.ArrayAccess)temp;
        a = a.withIndexed((Expression)this.visitAndCast((Tree)a.getIndexed(), newArrayAccess.getIndexed()));
        a = a.withDimension((J.ArrayDimension)this.visitAndCast((Tree)a.getDimension(), newArrayAccess.getDimension()));
        return a.withType(this.visitType(a.getType(), newArrayAccess.getType()));
    }

    public J visitArrayDimension(J.ArrayDimension arrayDimension, @Nullable Object ctx) {
        if (arrayDimension == ctx || !(ctx instanceof J.ArrayDimension)) {
            return arrayDimension;
        }
        J.ArrayDimension newArrayDimension = (J.ArrayDimension)ctx;
        J.ArrayDimension a = arrayDimension;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.DIMENSION_PREFIX, (Object)newArrayDimension.getPrefix()));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), newArrayDimension.getMarkers()));
        return a.getPadding().withIndex(this.visitRightPadded(a.getPadding().getIndex(), JRightPadded.Location.ARRAY_INDEX, (Object)newArrayDimension.getPadding().getIndex()));
    }

    public J visitArrayType(J.ArrayType arrayType, @Nullable Object ctx) {
        if (arrayType == ctx || !(ctx instanceof J.ArrayType)) {
            return arrayType;
        }
        J.ArrayType newArrayType = (J.ArrayType)ctx;
        J.ArrayType a = arrayType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ARRAY_TYPE_PREFIX, (Object)newArrayType.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newArrayType.getMarkers()))), newArrayType);
        if (!(temp instanceof J.ArrayType)) {
            return temp;
        }
        a = (J.ArrayType)temp;
        a = a.withElementType((TypeTree)this.visitAndCast((Tree)a.getElementType(), newArrayType.getElementType()));
        a = a.withElementType(this.visitTypeName(a.getElementType(), (Object)newArrayType.getElementType()));
        if ((a = a.withAnnotations(ListUtils.map((List)a.getAnnotations(), (index, ann) -> (J.Annotation)this.visitAndCast((Tree)ann, newArrayType.getAnnotations().get((int)index))))).getDimension() != null && newArrayType.getDimension() != null) {
            a = a.withDimension(a.getDimension().withBefore(this.visitSpace(a.getDimension().getBefore(), Space.Location.DIMENSION_PREFIX, (Object)newArrayType.getDimension().getBefore())).withElement((Object)this.visitSpace((Space)a.getDimension().getElement(), Space.Location.DIMENSION, newArrayType.getDimension().getElement())));
        }
        return a.withType(this.visitType(a.getType(), newArrayType.getType()));
    }

    public J visitAssert(J.Assert assert_, @Nullable Object ctx) {
        if (assert_ == ctx || !(ctx instanceof J.Assert)) {
            return assert_;
        }
        J.Assert newAssert = (J.Assert)ctx;
        J.Assert a = assert_;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSERT_PREFIX, (Object)newAssert.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAssert.getMarkers()))), newAssert);
        if (!(temp instanceof J.Assert)) {
            return temp;
        }
        a = (J.Assert)temp;
        if ((a = a.withCondition((Expression)this.visitAndCast((Tree)a.getCondition(), newAssert.getCondition()))).getDetail() != null && newAssert.getDetail() != null) {
            a = a.withDetail(this.visitLeftPadded(a.getDetail(), JLeftPadded.Location.ASSERT_DETAIL, (Object)newAssert.getDetail()));
        }
        return a;
    }

    public J visitAssignment(J.Assignment assignment, @Nullable Object ctx) {
        if (assignment == ctx || !(ctx instanceof J.Assignment)) {
            return assignment;
        }
        J.Assignment newAssignment = (J.Assignment)ctx;
        J.Assignment a = assignment;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSIGNMENT_PREFIX, (Object)newAssignment.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAssignment.getMarkers()))), newAssignment);
        if (!(temp instanceof J.Assignment)) {
            return temp;
        }
        a = (J.Assignment)temp;
        Expression temp2 = (Expression)this.visitExpression((Expression)a, newAssignment);
        if (!(temp2 instanceof J.Assignment)) {
            return temp2;
        }
        a = (J.Assignment)temp2;
        a = a.withVariable((Expression)this.visitAndCast((Tree)a.getVariable(), newAssignment.getVariable()));
        a = a.getPadding().withAssignment(this.visitLeftPadded(a.getPadding().getAssignment(), JLeftPadded.Location.ASSIGNMENT, (Object)newAssignment.getPadding().getAssignment()));
        return a.withType(this.visitType(a.getType(), newAssignment.getType()));
    }

    public J visitAssignmentOperation(J.AssignmentOperation assignOp, @Nullable Object ctx) {
        if (assignOp == ctx || !(ctx instanceof J.AssignmentOperation)) {
            return assignOp;
        }
        J.AssignmentOperation newAssignOp = (J.AssignmentOperation)ctx;
        J.AssignmentOperation a = assignOp;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSIGNMENT_OPERATION_PREFIX, (Object)newAssignOp.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAssignOp.getMarkers()))), newAssignOp);
        if (!(temp instanceof J.AssignmentOperation)) {
            return temp;
        }
        a = (J.AssignmentOperation)temp;
        Expression temp2 = (Expression)this.visitExpression((Expression)a, newAssignOp);
        if (!(temp2 instanceof J.AssignmentOperation)) {
            return temp2;
        }
        a = (J.AssignmentOperation)temp2;
        a = a.withVariable((Expression)this.visitAndCast((Tree)a.getVariable(), newAssignOp.getVariable()));
        a = a.getPadding().withOperator(this.visitLeftPadded(a.getPadding().getOperator(), JLeftPadded.Location.ASSIGNMENT_OPERATION_OPERATOR, (Object)newAssignOp.getPadding().getOperator()));
        a = a.withAssignment((Expression)this.visitAndCast((Tree)a.getAssignment(), newAssignOp.getAssignment()));
        return a.withType(this.visitType(a.getType(), newAssignOp.getType()));
    }

    public J visitBinary(J.Binary binary, @Nullable Object ctx) {
        if (binary == ctx || !(ctx instanceof J.Binary)) {
            return binary;
        }
        J.Binary newBinary = (J.Binary)ctx;
        J.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BINARY_PREFIX, (Object)newBinary.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(b = b.withMarkers(this.visitMarkers(b.getMarkers(), newBinary.getMarkers()))), newBinary);
        if (!(temp instanceof J.Binary)) {
            return temp;
        }
        b = (J.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), newBinary.getLeft()));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), JLeftPadded.Location.BINARY_OPERATOR, (Object)newBinary.getPadding().getOperator()));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), newBinary.getRight()));
        return b.withType(this.visitType(b.getType(), newBinary.getType()));
    }

    public J visitBlock(J.Block block, @Nullable Object ctx) {
        if (block == ctx || !(ctx instanceof J.Block)) {
            return block;
        }
        J.Block newBlock = (J.Block)ctx;
        J.Block b = block;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BLOCK_PREFIX, (Object)newBlock.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(b = b.withMarkers(this.visitMarkers(b.getMarkers(), newBlock.getMarkers()))), newBlock);
        if (!(temp instanceof J.Block)) {
            return temp;
        }
        b = (J.Block)temp;
        b = b.getPadding().withStatic(this.visitRightPadded(b.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, (Object)newBlock.getPadding().getStatic()));
        b = b.getPadding().withStatements(ListUtils.map((List)b.getPadding().getStatements(), (index, t) -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.BLOCK_STATEMENT, newBlock.getPadding().getStatements().get((int)index))));
        return b.withEnd(this.visitSpace(b.getEnd(), Space.Location.BLOCK_END, (Object)newBlock.getEnd()));
    }

    public J visitBreak(J.Break breakStatement, @Nullable Object ctx) {
        if (breakStatement == ctx || !(ctx instanceof J.Break)) {
            return breakStatement;
        }
        J.Break newBreakStatement = (J.Break)ctx;
        J.Break b = breakStatement;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BREAK_PREFIX, (Object)newBreakStatement.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(b = b.withMarkers(this.visitMarkers(b.getMarkers(), newBreakStatement.getMarkers()))), newBreakStatement);
        if (!(temp instanceof J.Break)) {
            return temp;
        }
        b = (J.Break)temp;
        return b.withLabel((J.Identifier)this.visitAndCast((Tree)b.getLabel(), newBreakStatement.getLabel()));
    }

    public J visitCase(J.Case case_, @Nullable Object ctx) {
        if (case_ == ctx || !(ctx instanceof J.Case)) {
            return case_;
        }
        J.Case newCase = (J.Case)ctx;
        J.Case c = case_;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CASE_PREFIX, (Object)newCase.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(c = c.withMarkers(this.visitMarkers(c.getMarkers(), newCase.getMarkers()))), newCase);
        if (!(temp instanceof J.Case)) {
            return temp;
        }
        c = (J.Case)temp;
        c = c.getPadding().withCaseLabels(this.visitContainer(c.getPadding().getCaseLabels(), JContainer.Location.CASE_LABEL, (Object)newCase.getPadding().getCaseLabels()));
        c = c.withGuard((Expression)this.visitAndCast((Tree)c.getGuard(), newCase.getGuard()));
        c = c.getPadding().withBody(this.visitRightPadded(c.getPadding().getBody(), JRightPadded.Location.CASE_BODY, (Object)newCase.getPadding().getBody()));
        return c.getPadding().withStatements(this.visitContainer(c.getPadding().getStatements(), JContainer.Location.CASE, (Object)newCase.getPadding().getStatements()));
    }

    public J visitCatch(J.Try.Catch catch_, @Nullable Object ctx) {
        if (catch_ == ctx || !(ctx instanceof J.Try.Catch)) {
            return catch_;
        }
        J.Try.Catch newCatch = (J.Try.Catch)ctx;
        J.Try.Catch c = catch_;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CATCH_PREFIX, (Object)newCatch.getPrefix()));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), newCatch.getMarkers()));
        c = c.withParameter((J.ControlParentheses)this.visitAndCast((Tree)c.getParameter(), newCatch.getParameter()));
        return c.withBody((J.Block)this.visitAndCast((Tree)c.getBody(), newCatch.getBody()));
    }

    public J visitClassDeclaration(J.ClassDeclaration classDecl, @Nullable Object ctx) {
        if (classDecl == ctx || !(ctx instanceof J.ClassDeclaration)) {
            return classDecl;
        }
        J.ClassDeclaration newClassDecl = (J.ClassDeclaration)ctx;
        J.ClassDeclaration c = classDecl;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CLASS_DECLARATION_PREFIX, (Object)newClassDecl.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(c = c.withMarkers(this.visitMarkers(c.getMarkers(), newClassDecl.getMarkers()))), newClassDecl);
        if (!(temp instanceof J.ClassDeclaration)) {
            return temp;
        }
        c = (J.ClassDeclaration)temp;
        c = c.withLeadingAnnotations(ListUtils.map((List)c.getLeadingAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newClassDecl.getLeadingAnnotations().get((int)index))));
        c = c.withModifiers(ListUtils.map((List)c.getModifiers(), (index, m) -> (J.Modifier)this.visitAndCast((Tree)m, newClassDecl.getModifiers().get((int)index))));
        c = c.getPadding().withKind(classDecl.getPadding().getKind().withAnnotations(ListUtils.map((List)classDecl.getPadding().getKind().getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newClassDecl.getPadding().getKind().getAnnotations().get((int)index)))));
        c = c.getPadding().withKind(c.getPadding().getKind().withPrefix(this.visitSpace(c.getPadding().getKind().getPrefix(), Space.Location.CLASS_KIND, (Object)newClassDecl.getPadding().getKind().getPrefix())));
        if ((c = c.withName((J.Identifier)this.visitAndCast((Tree)c.getName(), newClassDecl.getName()))).getPadding().getTypeParameters() != null && newClassDecl.getPadding().getTypeParameters() != null) {
            c = c.getPadding().withTypeParameters(this.visitContainer(c.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, (Object)newClassDecl.getPadding().getTypeParameters()));
        }
        if (c.getPadding().getPrimaryConstructor() != null && newClassDecl.getPadding().getPrimaryConstructor() != null) {
            c = c.getPadding().withPrimaryConstructor(this.visitContainer(c.getPadding().getPrimaryConstructor(), JContainer.Location.RECORD_STATE_VECTOR, (Object)newClassDecl.getPadding().getPrimaryConstructor()));
        }
        if (c.getPadding().getExtends() != null && newClassDecl.getPadding().getExtends() != null) {
            c = c.getPadding().withExtends(this.visitLeftPadded(c.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, (Object)newClassDecl.getPadding().getExtends()));
        }
        if ((c = c.getPadding().withExtends(this.visitTypeName(c.getPadding().getExtends(), (Object)newClassDecl.getPadding().getExtends()))).getPadding().getImplements() != null && newClassDecl.getPadding().getImplements() != null) {
            c = c.getPadding().withImplements(this.visitContainer(c.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, (Object)newClassDecl.getPadding().getImplements()));
        }
        if (c.getPadding().getPermits() != null && newClassDecl.getPadding().getPermits() != null) {
            c = c.getPadding().withPermits(this.visitContainer(c.getPadding().getPermits(), JContainer.Location.PERMITS, (Object)newClassDecl.getPadding().getPermits()));
        }
        c = c.getPadding().withImplements(this.visitTypeNames(c.getPadding().getImplements(), newClassDecl.getPadding().getImplements()));
        c = c.withBody((J.Block)this.visitAndCast((Tree)c.getBody(), newClassDecl.getBody()));
        return c.withType(this.visitType((JavaType)c.getType(), newClassDecl.getType()));
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, @Nullable Object ctx) {
        if (cu == ctx || !(ctx instanceof J.CompilationUnit)) {
            return cu;
        }
        J.CompilationUnit newCu = (J.CompilationUnit)ctx;
        J.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, (Object)newCu.getPrefix()));
        if ((c = c.withMarkers(this.visitMarkers(c.getMarkers(), newCu.getMarkers()))).getPadding().getPackageDeclaration() != null && newCu.getPadding().getPackageDeclaration() != null) {
            c = c.getPadding().withPackageDeclaration(this.visitRightPadded(c.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, (Object)newCu.getPadding().getPackageDeclaration()));
        }
        c = c.getPadding().withImports(ListUtils.map((List)c.getPadding().getImports(), (index, t) -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, newCu.getPadding().getImports().get((int)index))));
        c = c.withClasses(ListUtils.map((List)c.getClasses(), (index, e) -> (J.ClassDeclaration)this.visitAndCast((Tree)e, newCu.getClasses().get((int)index))));
        return c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, (Object)newCu.getEof()));
    }

    public J visitContinue(J.Continue continueStatement, @Nullable Object ctx) {
        if (continueStatement == ctx || !(ctx instanceof J.Continue)) {
            return continueStatement;
        }
        J.Continue newContinueStatement = (J.Continue)ctx;
        J.Continue c = continueStatement;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CONTINUE_PREFIX, (Object)newContinueStatement.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(c = c.withMarkers(this.visitMarkers(c.getMarkers(), newContinueStatement.getMarkers()))), newContinueStatement);
        if (!(temp instanceof J.Continue)) {
            return temp;
        }
        c = (J.Continue)temp;
        return c.withLabel((J.Identifier)this.visitAndCast((Tree)c.getLabel(), newContinueStatement.getLabel()));
    }

    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, @Nullable Object ctx) {
        J.ControlParentheses newControlParens = (J.ControlParentheses)ctx;
        if (controlParens == newControlParens) {
            return controlParens;
        }
        J.ControlParentheses cp = controlParens;
        Expression temp = (Expression)this.visitExpression((Expression)(cp = cp.withPrefix(this.visitSpace(cp.getPrefix(), Space.Location.CONTROL_PARENTHESES_PREFIX, (Object)newControlParens.getPrefix()))), newControlParens);
        if (!(temp instanceof J.ControlParentheses)) {
            return temp;
        }
        cp = (J.ControlParentheses)temp;
        cp = cp.getPadding().withTree(this.visitRightPadded(cp.getPadding().getTree(), JRightPadded.Location.PARENTHESES, (Object)newControlParens.getPadding().getTree()));
        return cp.withMarkers(this.visitMarkers(cp.getMarkers(), newControlParens.getMarkers()));
    }

    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, @Nullable Object ctx) {
        if (doWhileLoop == ctx || !(ctx instanceof J.DoWhileLoop)) {
            return doWhileLoop;
        }
        J.DoWhileLoop newDoWhileLoop = (J.DoWhileLoop)ctx;
        J.DoWhileLoop d = doWhileLoop;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.DO_WHILE_PREFIX, (Object)newDoWhileLoop.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(d = d.withMarkers(this.visitMarkers(d.getMarkers(), newDoWhileLoop.getMarkers()))), newDoWhileLoop);
        if (!(temp instanceof J.DoWhileLoop)) {
            return temp;
        }
        d = (J.DoWhileLoop)temp;
        d = d.getPadding().withWhileCondition(this.visitLeftPadded(d.getPadding().getWhileCondition(), JLeftPadded.Location.WHILE_CONDITION, (Object)newDoWhileLoop.getPadding().getWhileCondition()));
        return d.getPadding().withBody(this.visitRightPadded(d.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, (Object)newDoWhileLoop.getPadding().getBody()));
    }

    public J visitEmpty(J.Empty empty, @Nullable Object ctx) {
        if (empty == ctx || !(ctx instanceof J.Empty)) {
            return empty;
        }
        J.Empty newEmpty = (J.Empty)ctx;
        J.Empty e = empty;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.EMPTY_PREFIX, (Object)newEmpty.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(e = e.withMarkers(this.visitMarkers(e.getMarkers(), newEmpty.getMarkers()))), newEmpty);
        if (!(temp instanceof J.Empty)) {
            return temp;
        }
        return this.visitExpression((Expression)((J.Empty)temp), newEmpty);
    }

    public J visitEnumValue(J.EnumValue enum_, @Nullable Object ctx) {
        if (enum_ == ctx || !(ctx instanceof J.EnumValue)) {
            return enum_;
        }
        J.EnumValue newEnum = (J.EnumValue)ctx;
        J.EnumValue e = enum_;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ENUM_VALUE_PREFIX, (Object)newEnum.getPrefix()));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), newEnum.getMarkers()));
        e = e.withAnnotations(ListUtils.map((List)e.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newEnum.getAnnotations().get((int)index))));
        e = e.withName((J.Identifier)this.visitAndCast((Tree)e.getName(), newEnum.getName()));
        return e.withInitializer((J.NewClass)this.visitAndCast((Tree)e.getInitializer(), newEnum.getInitializer()));
    }

    public J visitEnumValueSet(J.EnumValueSet enums, @Nullable Object ctx) {
        if (enums == ctx || !(ctx instanceof J.EnumValueSet)) {
            return enums;
        }
        J.EnumValueSet newEnums = (J.EnumValueSet)ctx;
        J.EnumValueSet e = enums;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ENUM_VALUE_SET_PREFIX, (Object)newEnums.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(e = e.withMarkers(this.visitMarkers(e.getMarkers(), newEnums.getMarkers()))), newEnums);
        if (!(temp instanceof J.EnumValueSet)) {
            return temp;
        }
        e = (J.EnumValueSet)temp;
        return e.getPadding().withEnums(ListUtils.map((List)e.getPadding().getEnums(), (index, t) -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.ENUM_VALUE, newEnums.getPadding().getEnums().get((int)index))));
    }

    public J visitFieldAccess(J.FieldAccess fieldAccess, @Nullable Object ctx) {
        if (fieldAccess == ctx || !(ctx instanceof J.FieldAccess)) {
            return fieldAccess;
        }
        J.FieldAccess newFieldAccess = (J.FieldAccess)ctx;
        J.FieldAccess f2 = fieldAccess;
        f2 = f2.withPrefix(this.visitSpace(f2.getPrefix(), Space.Location.FIELD_ACCESS_PREFIX, (Object)newFieldAccess.getPrefix()));
        f2 = f2.withMarkers(this.visitMarkers(f2.getMarkers(), newFieldAccess.getMarkers()));
        Expression temp = (Expression)this.visitExpression((Expression)(f2 = this.visitTypeName(f2, (Object)newFieldAccess)), newFieldAccess);
        if (!(temp instanceof J.FieldAccess)) {
            return temp;
        }
        f2 = (J.FieldAccess)temp;
        Statement tempStat = (Statement)this.visitStatement((Statement)f2, newFieldAccess);
        if (!(tempStat instanceof J.FieldAccess)) {
            return tempStat;
        }
        f2 = (J.FieldAccess)tempStat;
        f2 = f2.withTarget((Expression)this.visitAndCast((Tree)f2.getTarget(), newFieldAccess.getTarget()));
        f2 = f2.getPadding().withName(this.visitLeftPadded(f2.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, (Object)newFieldAccess.getPadding().getName()));
        return f2.withType(this.visitType(f2.getType(), newFieldAccess.getType()));
    }

    public J visitForEachLoop(J.ForEachLoop forLoop, @Nullable Object ctx) {
        if (forLoop == ctx || !(ctx instanceof J.ForEachLoop)) {
            return forLoop;
        }
        J.ForEachLoop newForLoop = (J.ForEachLoop)ctx;
        J.ForEachLoop f2 = forLoop;
        f2 = f2.withPrefix(this.visitSpace(f2.getPrefix(), Space.Location.FOR_EACH_LOOP_PREFIX, (Object)newForLoop.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(f2 = f2.withMarkers(this.visitMarkers(f2.getMarkers(), newForLoop.getMarkers()))), newForLoop);
        if (!(temp instanceof J.ForEachLoop)) {
            return temp;
        }
        f2 = (J.ForEachLoop)temp;
        f2 = f2.withControl((J.ForEachLoop.Control)this.visitAndCast((Tree)f2.getControl(), newForLoop.getControl()));
        return f2.getPadding().withBody(this.visitRightPadded(f2.getPadding().getBody(), JRightPadded.Location.FOR_BODY, (Object)newForLoop.getPadding().getBody()));
    }

    public J visitForEachControl(J.ForEachLoop.Control control, @Nullable Object ctx) {
        if (control == ctx || !(ctx instanceof J.ForEachLoop.Control)) {
            return control;
        }
        J.ForEachLoop.Control newControl = (J.ForEachLoop.Control)ctx;
        J.ForEachLoop.Control c = control;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, (Object)newControl.getPrefix()));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), newControl.getMarkers()));
        c = c.getPadding().withVariable(this.visitRightPadded(c.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, (Object)newControl.getPadding().getVariable()));
        return c.getPadding().withIterable(this.visitRightPadded(c.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, (Object)newControl.getPadding().getIterable()));
    }

    public J visitForLoop(J.ForLoop forLoop, @Nullable Object ctx) {
        if (forLoop == ctx || !(ctx instanceof J.ForLoop)) {
            return forLoop;
        }
        J.ForLoop newForLoop = (J.ForLoop)ctx;
        J.ForLoop f2 = forLoop;
        f2 = f2.withPrefix(this.visitSpace(f2.getPrefix(), Space.Location.FOR_PREFIX, (Object)newForLoop.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(f2 = f2.withMarkers(this.visitMarkers(f2.getMarkers(), newForLoop.getMarkers()))), newForLoop);
        if (!(temp instanceof J.ForLoop)) {
            return temp;
        }
        f2 = (J.ForLoop)temp;
        f2 = f2.withControl((J.ForLoop.Control)this.visitAndCast((Tree)f2.getControl(), newForLoop.getControl()));
        return f2.getPadding().withBody(this.visitRightPadded(f2.getPadding().getBody(), JRightPadded.Location.FOR_BODY, (Object)newForLoop.getPadding().getBody()));
    }

    public J visitForControl(J.ForLoop.Control control, @Nullable Object ctx) {
        if (control == ctx || !(ctx instanceof J.ForLoop.Control)) {
            return control;
        }
        J.ForLoop.Control newControl = (J.ForLoop.Control)ctx;
        J.ForLoop.Control c = control;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.FOR_CONTROL_PREFIX, (Object)newControl.getPrefix()));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), newControl.getMarkers()));
        c = c.getPadding().withInit(ListUtils.map((List)c.getPadding().getInit(), (index, t) -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.FOR_INIT, newControl.getPadding().getInit().get((int)index))));
        c = c.getPadding().withCondition(this.visitRightPadded(c.getPadding().getCondition(), JRightPadded.Location.FOR_CONDITION, (Object)newControl.getPadding().getCondition()));
        return c.getPadding().withUpdate(ListUtils.map((List)c.getPadding().getUpdate(), (index, t) -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.FOR_UPDATE, newControl.getPadding().getUpdate().get((int)index))));
    }

    public J visitParenthesizedTypeTree(J.ParenthesizedTypeTree parTree, @Nullable Object ctx) {
        J temp;
        if (parTree == ctx || !(ctx instanceof J.ParenthesizedTypeTree)) {
            return parTree;
        }
        J.ParenthesizedTypeTree newParTree = (J.ParenthesizedTypeTree)ctx;
        J.ParenthesizedTypeTree t = parTree;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.PARENTHESES_PREFIX, (Object)newParTree.getPrefix()));
        if ((t = t.withMarkers(this.visitMarkers(t.getMarkers(), newParTree.getMarkers()))).getAnnotations() != null && !t.getAnnotations().isEmpty()) {
            t = t.withAnnotations(ListUtils.map((List)t.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newParTree.getAnnotations().get((int)index))));
        }
        if (!((temp = this.visitParentheses(t.getParenthesizedType(), newParTree.getParenthesizedType())) instanceof J.Parentheses)) {
            return temp;
        }
        return t.withParenthesizedType((J.Parentheses)temp);
    }

    public J visitIdentifier(J.Identifier ident, @Nullable Object ctx) {
        if (ident == ctx || !(ctx instanceof J.Identifier)) {
            return ident;
        }
        J.Identifier newIdent = (J.Identifier)ctx;
        J.Identifier i = ident;
        if (i.getAnnotations() != null && !i.getAnnotations().isEmpty()) {
            i = i.withAnnotations(ListUtils.map((List)i.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newIdent.getAnnotations().get((int)index))));
        }
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IDENTIFIER_PREFIX, (Object)newIdent.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(i = i.withMarkers(this.visitMarkers(i.getMarkers(), newIdent.getMarkers()))), newIdent);
        if (!(temp instanceof J.Identifier)) {
            return temp;
        }
        i = (J.Identifier)temp;
        i = i.withType(this.visitType(i.getType(), newIdent.getType()));
        return i.withFieldType((JavaType.Variable)this.visitType((JavaType)i.getFieldType(), newIdent.getFieldType()));
    }

    public J visitElse(J.If.Else else_, @Nullable Object ctx) {
        if (else_ == ctx || !(ctx instanceof J.If.Else)) {
            return else_;
        }
        J.If.Else newElse = (J.If.Else)ctx;
        J.If.Else e = else_;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ELSE_PREFIX, (Object)newElse.getPrefix()));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), newElse.getMarkers()));
        return e.getPadding().withBody(this.visitRightPadded(e.getPadding().getBody(), JRightPadded.Location.IF_ELSE, (Object)newElse.getPadding().getBody()));
    }

    public J visitIf(J.If iff, @Nullable Object ctx) {
        if (iff == ctx || !(ctx instanceof J.If)) {
            return iff;
        }
        J.If newIff = (J.If)ctx;
        J.If i = iff;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IF_PREFIX, (Object)newIff.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(i = i.withMarkers(this.visitMarkers(i.getMarkers(), newIff.getMarkers()))), newIff);
        if (!(temp instanceof J.If)) {
            return temp;
        }
        i = (J.If)temp;
        i = i.withIfCondition((J.ControlParentheses)this.visitAndCast((Tree)i.getIfCondition(), newIff.getIfCondition()));
        i = i.getPadding().withThenPart(this.visitRightPadded(i.getPadding().getThenPart(), JRightPadded.Location.IF_THEN, (Object)newIff.getPadding().getThenPart()));
        return i.withElsePart((J.If.Else)this.visitAndCast((Tree)i.getElsePart(), newIff.getElsePart()));
    }

    public J visitImport(J.Import import_, @Nullable Object ctx) {
        if (import_ == ctx || !(ctx instanceof J.Import)) {
            return import_;
        }
        J.Import newImport = (J.Import)ctx;
        J.Import i = import_;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IMPORT_PREFIX, (Object)newImport.getPrefix()));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), newImport.getMarkers()));
        i = i.getPadding().withStatic(this.visitLeftPadded(i.getPadding().getStatic(), JLeftPadded.Location.STATIC_IMPORT, (Object)newImport.getPadding().getStatic()));
        i = i.withQualid((J.FieldAccess)this.visitAndCast((Tree)i.getQualid(), newImport.getQualid()));
        return i.getPadding().withAlias(this.visitLeftPadded(i.getPadding().getAlias(), JLeftPadded.Location.IMPORT_ALIAS_PREFIX, (Object)newImport.getPadding().getAlias()));
    }

    public J visitInstanceOf(J.InstanceOf instanceOf, @Nullable Object ctx) {
        if (instanceOf == ctx || !(ctx instanceof J.InstanceOf)) {
            return instanceOf;
        }
        J.InstanceOf newInstanceOf = (J.InstanceOf)ctx;
        J.InstanceOf i = instanceOf;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.INSTANCEOF_PREFIX, (Object)newInstanceOf.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(i = i.withMarkers(this.visitMarkers(i.getMarkers(), newInstanceOf.getMarkers()))), newInstanceOf);
        if (!(temp instanceof J.InstanceOf)) {
            return temp;
        }
        i = (J.InstanceOf)temp;
        i = i.getPadding().withExpression(this.visitRightPadded(i.getPadding().getExpression(), JRightPadded.Location.INSTANCEOF, (Object)newInstanceOf.getPadding().getExpression()));
        i = i.withClazz((J)this.visitAndCast((Tree)i.getClazz(), newInstanceOf.getClazz()));
        i = i.withPattern((J)this.visitAndCast((Tree)i.getPattern(), newInstanceOf.getPattern()));
        return i.withType(this.visitType(i.getType(), newInstanceOf.getType()));
    }

    public J visitDeconstructionPattern(J.DeconstructionPattern deconstructionPattern, @Nullable Object ctx) {
        if (deconstructionPattern == ctx || !(ctx instanceof J.DeconstructionPattern)) {
            return deconstructionPattern;
        }
        J.DeconstructionPattern newDeconstructionPattern = (J.DeconstructionPattern)ctx;
        J.DeconstructionPattern d = deconstructionPattern;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.DECONSTRUCTION_PATTERN_PREFIX, (Object)newDeconstructionPattern.getPrefix()));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), newDeconstructionPattern.getMarkers()));
        d = d.withDeconstructor((Expression)this.visitAndCast((Tree)d.getDeconstructor(), newDeconstructionPattern.getDeconstructor()));
        d = d.getPadding().withNested(this.visitContainer(d.getPadding().getNested(), JContainer.Location.DECONSTRUCTION_PATTERN_NESTED, (Object)newDeconstructionPattern.getPadding().getNested()));
        return d.withType(this.visitType(d.getType(), newDeconstructionPattern.getType()));
    }

    public J visitIntersectionType(J.IntersectionType intersectionType, @Nullable Object ctx) {
        if (intersectionType == ctx || !(ctx instanceof J.IntersectionType)) {
            return intersectionType;
        }
        J.IntersectionType newIntersectionType = (J.IntersectionType)ctx;
        J.IntersectionType i = intersectionType;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.INTERSECTION_TYPE_PREFIX, (Object)newIntersectionType.getPrefix()));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), newIntersectionType.getMarkers()));
        i = i.getPadding().withBounds(this.visitContainer(i.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, (Object)newIntersectionType.getPadding().getBounds()));
        return i.withType(this.visitType(i.getType(), newIntersectionType.getType()));
    }

    public J visitLabel(J.Label label, @Nullable Object ctx) {
        if (label == ctx || !(ctx instanceof J.Label)) {
            return label;
        }
        J.Label newLabel = (J.Label)ctx;
        J.Label l = label;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LABEL_PREFIX, (Object)newLabel.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(l = l.withMarkers(this.visitMarkers(l.getMarkers(), newLabel.getMarkers()))), newLabel);
        if (!(temp instanceof J.Label)) {
            return temp;
        }
        l = (J.Label)temp;
        l = l.getPadding().withLabel(this.visitRightPadded(l.getPadding().getLabel(), JRightPadded.Location.LABEL, (Object)newLabel.getPadding().getLabel()));
        return l.withStatement((Statement)this.visitAndCast((Tree)l.getStatement(), newLabel.getStatement()));
    }

    public J visitLambda(J.Lambda lambda, @Nullable Object ctx) {
        if (lambda == ctx || !(ctx instanceof J.Lambda)) {
            return lambda;
        }
        J.Lambda newLambda = (J.Lambda)ctx;
        J.Lambda l = lambda;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LAMBDA_PREFIX, (Object)newLambda.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(l = l.withMarkers(this.visitMarkers(l.getMarkers(), newLambda.getMarkers()))), newLambda);
        if (!(temp instanceof J.Lambda)) {
            return temp;
        }
        l = (J.Lambda)temp;
        l = l.withParameters((J.Lambda.Parameters)this.visitAndCast((Tree)l.getParameters(), newLambda.getParameters()));
        l = l.withArrow(this.visitSpace(l.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, (Object)newLambda.getArrow()));
        l = l.withBody((J)this.visitAndCast((Tree)l.getBody(), newLambda.getBody()));
        return l.withType(this.visitType(l.getType(), newLambda.getType()));
    }

    public J visitLambdaParameters(J.Lambda.Parameters parameters, @Nullable Object ctx) {
        if (parameters == ctx || !(ctx instanceof J.Lambda.Parameters)) {
            return parameters;
        }
        J.Lambda.Parameters newParameters = (J.Lambda.Parameters)ctx;
        J.Lambda.Parameters params = parameters;
        params = params.withPrefix(this.visitSpace(params.getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, (Object)newParameters.getPrefix()));
        params = params.withMarkers(this.visitMarkers(params.getMarkers(), newParameters.getMarkers()));
        return params.getPadding().withParameters(ListUtils.map((List)params.getPadding().getParameters(), (index, param) -> this.visitRightPadded((JRightPadded)param, JRightPadded.Location.LAMBDA_PARAM, newParameters.getPadding().getParameters().get((int)index))));
    }

    public J visitLiteral(J.Literal literal, @Nullable Object ctx) {
        if (literal == ctx || !(ctx instanceof J.Literal)) {
            return literal;
        }
        J.Literal newLiteral = (J.Literal)ctx;
        J.Literal l = literal;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LITERAL_PREFIX, (Object)newLiteral.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(l = l.withMarkers(this.visitMarkers(l.getMarkers(), newLiteral.getMarkers()))), newLiteral);
        if (!(temp instanceof J.Literal)) {
            return temp;
        }
        l = (J.Literal)temp;
        return l.withType(this.visitType((JavaType)l.getType(), newLiteral.getType()));
    }

    public J visitMemberReference(J.MemberReference memberRef, @Nullable Object ctx) {
        if (memberRef == ctx || !(ctx instanceof J.MemberReference)) {
            return memberRef;
        }
        J.MemberReference newMemberRef = (J.MemberReference)ctx;
        J.MemberReference m = memberRef;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MEMBER_REFERENCE_PREFIX, (Object)newMemberRef.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMemberRef.getMarkers()))), newMemberRef);
        if (!(temp instanceof J.MemberReference)) {
            return temp;
        }
        m = (J.MemberReference)temp;
        if ((m = m.getPadding().withContaining(this.visitRightPadded(m.getPadding().getContaining(), JRightPadded.Location.MEMBER_REFERENCE_CONTAINING, (Object)newMemberRef.getPadding().getContaining()))).getPadding().getTypeParameters() != null && newMemberRef.getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(this.visitContainer(m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, (Object)newMemberRef.getPadding().getTypeParameters()));
        }
        m = m.getPadding().withReference(this.visitLeftPadded(m.getPadding().getReference(), JLeftPadded.Location.MEMBER_REFERENCE_NAME, (Object)newMemberRef.getPadding().getReference()));
        m = m.withType(this.visitType(m.getType(), newMemberRef.getType()));
        m = m.withMethodType((JavaType.Method)this.visitType((JavaType)m.getMethodType(), newMemberRef.getMethodType()));
        return m.withVariableType((JavaType.Variable)this.visitType((JavaType)m.getVariableType(), newMemberRef.getVariableType()));
    }

    public J visitMethodDeclaration(J.MethodDeclaration method, @Nullable Object ctx) {
        if (method == ctx || !(ctx instanceof J.MethodDeclaration)) {
            return method;
        }
        J.MethodDeclaration newMethod = (J.MethodDeclaration)ctx;
        J.MethodDeclaration m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_DECLARATION_PREFIX, (Object)newMethod.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMethod.getMarkers()))), newMethod);
        if (!(temp instanceof J.MethodDeclaration)) {
            return temp;
        }
        m = (J.MethodDeclaration)temp;
        m = m.withLeadingAnnotations(ListUtils.map((List)m.getLeadingAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newMethod.getLeadingAnnotations().get((int)index))));
        m = m.withModifiers(ListUtils.map((List)m.getModifiers(), (index, e) -> (J.Modifier)this.visitAndCast((Tree)e, newMethod.getModifiers().get((int)index))));
        m = m.getAnnotations().withTypeParameters((J.TypeParameters)this.visit((Tree)m.getAnnotations().getTypeParameters(), newMethod.getAnnotations().getTypeParameters()));
        m = m.withReturnTypeExpression((m = m.withReturnTypeExpression((TypeTree)this.visitAndCast((Tree)m.getReturnTypeExpression(), newMethod.getReturnTypeExpression()))).getReturnTypeExpression() == null ? null : this.visitTypeName(m.getReturnTypeExpression(), (Object)newMethod.getReturnTypeExpression()));
        m = m.getAnnotations().withName(m.getAnnotations().getName().withAnnotations(ListUtils.map((List)m.getAnnotations().getName().getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newMethod.getAnnotations().getName().getAnnotations().get((int)index)))));
        m = m.withName((J.Identifier)this.visitNonNull((Tree)m.getName(), newMethod.getName()));
        if ((m = m.getPadding().withParameters(this.visitContainer(m.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, (Object)newMethod.getPadding().getParameters()))).getPadding().getThrows() != null) {
            m = m.getPadding().withThrows(this.visitContainer(m.getPadding().getThrows(), JContainer.Location.THROWS, (Object)newMethod.getPadding().getThrows()));
        }
        m = m.getPadding().withThrows(this.visitTypeNames(m.getPadding().getThrows(), newMethod.getPadding().getThrows()));
        if ((m = m.withBody((J.Block)this.visitAndCast((Tree)m.getBody(), newMethod.getBody()))).getPadding().getDefaultValue() != null) {
            m = m.getPadding().withDefaultValue(this.visitLeftPadded(m.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, (Object)newMethod.getPadding().getDefaultValue()));
        }
        return m.withMethodType((JavaType.Method)this.visitType((JavaType)m.getMethodType(), newMethod.getMethodType()));
    }

    public J visitMethodInvocation(J.MethodInvocation method, @Nullable Object ctx) {
        if (method == ctx || !(ctx instanceof J.MethodInvocation)) {
            return method;
        }
        J.MethodInvocation newMethod = (J.MethodInvocation)ctx;
        J.MethodInvocation m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_INVOCATION_PREFIX, (Object)newMethod.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMethod.getMarkers()))), newMethod);
        if (!(temp instanceof J.MethodInvocation)) {
            return temp;
        }
        m = (J.MethodInvocation)temp;
        Expression temp2 = (Expression)this.visitExpression((Expression)m, newMethod);
        if (!(temp2 instanceof J.MethodInvocation)) {
            return temp2;
        }
        m = (J.MethodInvocation)temp2;
        if (m.getPadding().getSelect() != null && m.getPadding().getSelect().getElement() instanceof NameTree && method.getMethodType() != null && method.getMethodType().hasFlags(new Flag[]{Flag.Static})) {
            m = m.getPadding().withSelect(this.visitTypeName(m.getPadding().getSelect(), (Object)newMethod.getPadding().getSelect()));
        }
        if (m.getPadding().getSelect() != null) {
            m = m.getPadding().withSelect(this.visitRightPadded(m.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, (Object)newMethod.getPadding().getSelect()));
        }
        if (m.getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(this.visitContainer(m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, (Object)newMethod.getPadding().getTypeParameters()));
        }
        m = m.getPadding().withTypeParameters(this.visitTypeNames(m.getPadding().getTypeParameters(), newMethod.getPadding().getTypeParameters()));
        m = m.withName((J.Identifier)this.visitNonNull((Tree)m.getName(), newMethod.getName()));
        m = m.getPadding().withArguments(this.visitContainer(m.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, (Object)newMethod.getPadding().getArguments()));
        return m.withMethodType((JavaType.Method)this.visitType((JavaType)m.getMethodType(), newMethod.getMethodType()));
    }

    public J visitModifier(J.Modifier modifer, @Nullable Object ctx) {
        if (modifer == ctx || !(ctx instanceof J.Modifier)) {
            return modifer;
        }
        J.Modifier newModifer = (J.Modifier)ctx;
        J.Modifier m = modifer;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MODIFIER_PREFIX, (Object)newModifer.getPrefix()));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), newModifer.getMarkers()));
        return m.withAnnotations(ListUtils.map((List)m.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newModifer.getAnnotations().get((int)index))));
    }

    public J visitMultiCatch(J.MultiCatch multiCatch, @Nullable Object ctx) {
        if (multiCatch == ctx || !(ctx instanceof J.MultiCatch)) {
            return multiCatch;
        }
        J.MultiCatch newMultiCatch = (J.MultiCatch)ctx;
        J.MultiCatch m = multiCatch;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MULTI_CATCH_PREFIX, (Object)newMultiCatch.getPrefix()));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMultiCatch.getMarkers()));
        return m.getPadding().withAlternatives(ListUtils.map((List)m.getPadding().getAlternatives(), (index, t) -> this.visitTypeName(this.visitRightPadded((JRightPadded)t, JRightPadded.Location.CATCH_ALTERNATIVE, newMultiCatch.getPadding().getAlternatives().get((int)index)), newMultiCatch.getPadding().getAlternatives().get((int)index))));
    }

    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, @Nullable Object ctx) {
        if (multiVariable == ctx || !(ctx instanceof J.VariableDeclarations)) {
            return multiVariable;
        }
        J.VariableDeclarations newMultiVariable = (J.VariableDeclarations)ctx;
        J.VariableDeclarations m = multiVariable;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.VARIABLE_DECLARATIONS_PREFIX, (Object)newMultiVariable.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMultiVariable.getMarkers()))), newMultiVariable);
        if (!(temp instanceof J.VariableDeclarations)) {
            return temp;
        }
        m = (J.VariableDeclarations)temp;
        m = m.withLeadingAnnotations(ListUtils.map((List)m.getLeadingAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newMultiVariable.getLeadingAnnotations().get((int)index))));
        m = m.withModifiers(Objects.requireNonNull(ListUtils.map((List)m.getModifiers(), (index, e) -> (J.Modifier)this.visitAndCast((Tree)e, newMultiVariable.getModifiers().get((int)index)))));
        m = m.withTypeExpression((m = m.withTypeExpression((TypeTree)this.visitAndCast((Tree)m.getTypeExpression(), newMultiVariable.getTypeExpression()))).getTypeExpression() == null ? null : this.visitTypeName(m.getTypeExpression(), (Object)newMultiVariable.getTypeExpression()));
        m = m.withVarargs(m.getVarargs() == null ? null : this.visitSpace(m.getVarargs(), Space.Location.VARARGS, (Object)newMultiVariable.getVarargs()));
        return m.getPadding().withVariables(ListUtils.map((List)m.getPadding().getVariables(), (index, t) -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.NAMED_VARIABLE, newMultiVariable.getPadding().getVariables().get((int)index))));
    }

    public J visitNewArray(J.NewArray newArray, @Nullable Object ctx) {
        if (newArray == ctx || !(ctx instanceof J.NewArray)) {
            return newArray;
        }
        J.NewArray newNewArray = (J.NewArray)ctx;
        J.NewArray n = newArray;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), Space.Location.NEW_ARRAY_PREFIX, (Object)newNewArray.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(n = n.withMarkers(this.visitMarkers(n.getMarkers(), newNewArray.getMarkers()))), newNewArray);
        if (!(temp instanceof J.NewArray)) {
            return temp;
        }
        n = (J.NewArray)temp;
        n = n.withTypeExpression((n = n.withTypeExpression((TypeTree)this.visitAndCast((Tree)n.getTypeExpression(), newNewArray.getTypeExpression()))).getTypeExpression() == null ? null : this.visitTypeName(n.getTypeExpression(), (Object)newNewArray.getTypeExpression()));
        if ((n = n.withDimensions(ListUtils.map((List)n.getDimensions(), (index, d) -> (J.ArrayDimension)this.visitAndCast((Tree)d, newNewArray.getDimensions().get((int)index))))).getPadding().getInitializer() != null) {
            n = n.getPadding().withInitializer(this.visitContainer(n.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, (Object)newNewArray.getPadding().getInitializer()));
        }
        return n.withType(this.visitType(n.getType(), newNewArray.getType()));
    }

    public J visitNewClass(J.NewClass newClass, @Nullable Object ctx) {
        Statement temp;
        if (newClass == ctx || !(ctx instanceof J.NewClass)) {
            return newClass;
        }
        J.NewClass newNewClass = (J.NewClass)ctx;
        J.NewClass n = newClass;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), Space.Location.NEW_CLASS_PREFIX, (Object)newNewClass.getPrefix()));
        if ((n = n.withMarkers(this.visitMarkers(n.getMarkers(), newNewClass.getMarkers()))).getPadding().getEnclosing() != null) {
            n = n.getPadding().withEnclosing(this.visitRightPadded(n.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, (Object)newNewClass.getPadding().getEnclosing()));
        }
        if (!((temp = (Statement)this.visitStatement((Statement)n, newNewClass)) instanceof J.NewClass)) {
            return temp;
        }
        n = (J.NewClass)temp;
        Expression temp2 = (Expression)this.visitExpression((Expression)n, newNewClass);
        if (!(temp2 instanceof J.NewClass)) {
            return temp2;
        }
        n = (J.NewClass)temp2;
        n = n.withNew(this.visitSpace(n.getNew(), Space.Location.NEW_PREFIX, (Object)newNewClass.getNew()));
        n = n.withClazz((n = n.withClazz((TypeTree)this.visitAndCast((Tree)n.getClazz(), newNewClass.getClazz()))).getClazz() == null ? null : this.visitTypeName(n.getClazz(), (Object)newNewClass.getClazz()));
        n = n.getPadding().withArguments(this.visitContainer(n.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, (Object)newNewClass.getPadding().getArguments()));
        n = n.withBody((J.Block)this.visitAndCast((Tree)n.getBody(), newNewClass.getBody()));
        return n.withConstructorType((JavaType.Method)this.visitType((JavaType)n.getConstructorType(), newNewClass.getConstructorType()));
    }

    public J visitNullableType(J.NullableType nullableType, @Nullable Object ctx) {
        if (nullableType == ctx || !(ctx instanceof J.NullableType)) {
            return nullableType;
        }
        J.NullableType newNullableType = (J.NullableType)ctx;
        J.NullableType nt = nullableType;
        nt = nt.withPrefix(this.visitSpace(nt.getPrefix(), Space.Location.NULLABLE_TYPE_PREFIX, (Object)newNullableType.getPrefix()));
        nt = nt.withMarkers(this.visitMarkers(nt.getMarkers(), newNullableType.getMarkers()));
        Expression temp = (Expression)this.visitExpression((Expression)(nt = nt.withAnnotations(ListUtils.map((List)nt.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newNullableType.getAnnotations().get((int)index))))), newNullableType);
        if (!(temp instanceof J.NullableType)) {
            return temp;
        }
        nt = (J.NullableType)temp;
        nt = nt.getPadding().withTypeTree(this.visitRightPadded(nt.getPadding().getTypeTree(), JRightPadded.Location.NULLABLE, (Object)newNullableType.getPadding().getTypeTree()));
        return nt.withType(this.visitType(nt.getType(), newNullableType.getType()));
    }

    public J visitPackage(J.Package pkg, @Nullable Object ctx) {
        if (pkg == ctx || !(ctx instanceof J.Package)) {
            return pkg;
        }
        J.Package newPkg = (J.Package)ctx;
        J.Package pa = pkg;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), Space.Location.PACKAGE_PREFIX, (Object)newPkg.getPrefix()));
        pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), newPkg.getMarkers()));
        pa = pa.withExpression((Expression)this.visitAndCast((Tree)pa.getExpression(), newPkg.getExpression()));
        return pa.withAnnotations(ListUtils.map((List)pa.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newPkg.getAnnotations().get((int)index))));
    }

    public J visitParameterizedType(J.ParameterizedType type2, @Nullable Object ctx) {
        if (type2 == ctx || !(ctx instanceof J.ParameterizedType)) {
            return type2;
        }
        J.ParameterizedType newType = (J.ParameterizedType)ctx;
        J.ParameterizedType pt = type2;
        pt = pt.withPrefix(this.visitSpace(pt.getPrefix(), Space.Location.PARAMETERIZED_TYPE_PREFIX, (Object)newType.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(pt = pt.withMarkers(this.visitMarkers(pt.getMarkers(), newType.getMarkers()))), newType);
        if (!(temp instanceof J.ParameterizedType)) {
            return temp;
        }
        pt = (J.ParameterizedType)temp;
        if ((pt = pt.withClazz((NameTree)this.visitAndCast((Tree)pt.getClazz(), newType.getClazz()))).getPadding().getTypeParameters() != null) {
            pt = pt.getPadding().withTypeParameters(this.visitContainer(pt.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, (Object)newType.getPadding().getTypeParameters()));
        }
        pt = pt.getPadding().withTypeParameters(this.visitTypeNames(pt.getPadding().getTypeParameters(), newType.getPadding().getTypeParameters()));
        return pt.withType(this.visitType(pt.getType(), newType.getType()));
    }

    public <T extends J> J visitParentheses(J.Parentheses<T> parens, @Nullable Object ctx) {
        J.Parentheses newParens = (J.Parentheses)ctx;
        if (parens == newParens) {
            return parens;
        }
        J.Parentheses pa = parens;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), Space.Location.PARENTHESES_PREFIX, (Object)newParens.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), newParens.getMarkers()))), newParens);
        if (!(temp instanceof J.Parentheses)) {
            return temp;
        }
        pa = (J.Parentheses)temp;
        return pa.getPadding().withTree(this.visitRightPadded(pa.getPadding().getTree(), JRightPadded.Location.PARENTHESES, (Object)newParens.getPadding().getTree()));
    }

    public J visitPrimitive(J.Primitive primitive, @Nullable Object ctx) {
        if (primitive == ctx || !(ctx instanceof J.Primitive)) {
            return primitive;
        }
        J.Primitive newPrimitive = (J.Primitive)ctx;
        J.Primitive pr = primitive;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), Space.Location.PRIMITIVE_PREFIX, (Object)newPrimitive.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(pr = pr.withMarkers(this.visitMarkers(pr.getMarkers(), newPrimitive.getMarkers()))), newPrimitive);
        if (!(temp instanceof J.Primitive)) {
            return temp;
        }
        pr = (J.Primitive)temp;
        return pr.withType(this.visitType((JavaType)pr.getType(), newPrimitive.getType()));
    }

    public J visitReturn(J.Return return_, @Nullable Object ctx) {
        if (return_ == ctx || !(ctx instanceof J.Return)) {
            return return_;
        }
        J.Return newReturn = (J.Return)ctx;
        J.Return r = return_;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.RETURN_PREFIX, (Object)newReturn.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(r = r.withMarkers(this.visitMarkers(r.getMarkers(), newReturn.getMarkers()))), newReturn);
        if (!(temp instanceof J.Return)) {
            return temp;
        }
        r = (J.Return)temp;
        return r.withExpression((Expression)this.visitAndCast((Tree)r.getExpression(), newReturn.getExpression()));
    }

    public J visitSwitch(J.Switch switch_, @Nullable Object ctx) {
        if (switch_ == ctx || !(ctx instanceof J.Switch)) {
            return switch_;
        }
        J.Switch newSwitch = (J.Switch)ctx;
        J.Switch s = switch_;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SWITCH_PREFIX, (Object)newSwitch.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(s = s.withMarkers(this.visitMarkers(s.getMarkers(), newSwitch.getMarkers()))), newSwitch);
        if (!(temp instanceof J.Switch)) {
            return temp;
        }
        s = (J.Switch)temp;
        s = s.withSelector((J.ControlParentheses)this.visitAndCast((Tree)s.getSelector(), newSwitch.getSelector()));
        return s.withCases((J.Block)this.visitAndCast((Tree)s.getCases(), newSwitch.getCases()));
    }

    public J visitSwitchExpression(J.SwitchExpression switch_, @Nullable Object ctx) {
        if (switch_ == ctx || !(ctx instanceof J.SwitchExpression)) {
            return switch_;
        }
        J.SwitchExpression newSwitch = (J.SwitchExpression)ctx;
        J.SwitchExpression s = switch_;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SWITCH_EXPRESSION_PREFIX, (Object)newSwitch.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(s = s.withMarkers(this.visitMarkers(s.getMarkers(), newSwitch.getMarkers()))), newSwitch);
        if (!(temp instanceof J.SwitchExpression)) {
            return temp;
        }
        s = (J.SwitchExpression)temp;
        s = s.withSelector((J.ControlParentheses)this.visitAndCast((Tree)s.getSelector(), newSwitch.getSelector()));
        return s.withCases((J.Block)this.visitAndCast((Tree)s.getCases(), newSwitch.getCases()));
    }

    public J visitSynchronized(J.Synchronized synch, @Nullable Object ctx) {
        if (synch == ctx || !(ctx instanceof J.Synchronized)) {
            return synch;
        }
        J.Synchronized newSynch = (J.Synchronized)ctx;
        J.Synchronized s = synch;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SYNCHRONIZED_PREFIX, (Object)newSynch.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(s = s.withMarkers(this.visitMarkers(s.getMarkers(), newSynch.getMarkers()))), newSynch);
        if (!(temp instanceof J.Synchronized)) {
            return temp;
        }
        s = (J.Synchronized)temp;
        s = s.withLock((J.ControlParentheses)this.visitAndCast((Tree)s.getLock(), newSynch.getLock()));
        return s.withBody((J.Block)this.visitAndCast((Tree)s.getBody(), newSynch.getBody()));
    }

    public J visitTernary(J.Ternary ternary, @Nullable Object ctx) {
        if (ternary == ctx || !(ctx instanceof J.Ternary)) {
            return ternary;
        }
        J.Ternary newTernary = (J.Ternary)ctx;
        J.Ternary t = ternary;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TERNARY_PREFIX, (Object)newTernary.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTernary.getMarkers()))), newTernary);
        if (!(temp instanceof J.Ternary)) {
            return temp;
        }
        t = (J.Ternary)temp;
        Statement tempStat = (Statement)this.visitStatement((Statement)t, newTernary);
        if (!(tempStat instanceof J.Ternary)) {
            return tempStat;
        }
        t = (J.Ternary)tempStat;
        t = t.withCondition((Expression)this.visitAndCast((Tree)t.getCondition(), newTernary.getCondition()));
        t = t.getPadding().withTruePart(this.visitLeftPadded(t.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, (Object)newTernary.getPadding().getTruePart()));
        t = t.getPadding().withFalsePart(this.visitLeftPadded(t.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, (Object)newTernary.getPadding().getFalsePart()));
        return t.withType(this.visitType(t.getType(), newTernary.getType()));
    }

    public J visitThrow(J.Throw thrown, @Nullable Object ctx) {
        if (thrown == ctx || !(ctx instanceof J.Throw)) {
            return thrown;
        }
        J.Throw newThrown = (J.Throw)ctx;
        J.Throw t = thrown;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.THROW_PREFIX, (Object)newThrown.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(t = t.withMarkers(this.visitMarkers(t.getMarkers(), newThrown.getMarkers()))), newThrown);
        if (!(temp instanceof J.Throw)) {
            return temp;
        }
        t = (J.Throw)temp;
        return t.withException((Expression)this.visitAndCast((Tree)t.getException(), newThrown.getException()));
    }

    public J visitTry(J.Try tryable, @Nullable Object ctx) {
        if (tryable == ctx || !(ctx instanceof J.Try)) {
            return tryable;
        }
        J.Try newTryable = (J.Try)ctx;
        J.Try t = tryable;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TRY_PREFIX, (Object)newTryable.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTryable.getMarkers()))), newTryable);
        if (!(temp instanceof J.Try)) {
            return temp;
        }
        t = (J.Try)temp;
        if (t.getPadding().getResources() != null) {
            t = t.getPadding().withResources(this.visitContainer(t.getPadding().getResources(), JContainer.Location.TRY_RESOURCES, (Object)newTryable.getPadding().getResources()));
        }
        t = t.withBody((J.Block)this.visitAndCast((Tree)t.getBody(), newTryable.getBody()));
        if ((t = t.withCatches(ListUtils.map((List)t.getCatches(), (index, c) -> (J.Try.Catch)this.visitAndCast((Tree)c, newTryable.getCatches().get((int)index))))).getPadding().getFinally() != null) {
            t = t.getPadding().withFinally(this.visitLeftPadded(t.getPadding().getFinally(), JLeftPadded.Location.TRY_FINALLY, (Object)newTryable.getPadding().getFinally()));
        }
        return t;
    }

    public J visitTryResource(J.Try.Resource tryResource, @Nullable Object ctx) {
        if (tryResource == ctx || !(ctx instanceof J.Try.Resource)) {
            return tryResource;
        }
        J.Try.Resource newTryResource = (J.Try.Resource)ctx;
        J.Try.Resource r = tryResource;
        r = tryResource.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.TRY_RESOURCE, (Object)newTryResource.getPrefix()));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), newTryResource.getMarkers()));
        return r.withVariableDeclarations((TypedTree)this.visitAndCast((Tree)r.getVariableDeclarations(), newTryResource.getVariableDeclarations()));
    }

    public J visitTypeCast(J.TypeCast typeCast, @Nullable Object ctx) {
        if (typeCast == ctx || !(ctx instanceof J.TypeCast)) {
            return typeCast;
        }
        J.TypeCast newTypeCast = (J.TypeCast)ctx;
        J.TypeCast t = typeCast;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_CAST_PREFIX, (Object)newTypeCast.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTypeCast.getMarkers()))), newTypeCast);
        if (!(temp instanceof J.TypeCast)) {
            return temp;
        }
        t = (J.TypeCast)temp;
        t = t.withClazz((J.ControlParentheses)this.visitAndCast((Tree)t.getClazz(), newTypeCast.getClazz()));
        t = t.withClazz(t.getClazz().withTree((J)this.visitTypeName((TypeTree)t.getClazz().getTree(), (Object)newTypeCast.getClazz().getTree())));
        return t.withExpression((Expression)this.visitAndCast((Tree)t.getExpression(), newTypeCast.getExpression()));
    }

    public J visitTypeParameter(J.TypeParameter typeParam, @Nullable Object ctx) {
        if (typeParam == ctx || !(ctx instanceof J.TypeParameter)) {
            return typeParam;
        }
        J.TypeParameter newTypeParam = (J.TypeParameter)ctx;
        J.TypeParameter t = typeParam;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_PARAMETERS_PREFIX, (Object)newTypeParam.getPrefix()));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTypeParam.getMarkers()));
        if ((t = t.withAnnotations(ListUtils.map((List)t.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newTypeParam.getAnnotations().get((int)index))))).getModifiers() != null && !t.getModifiers().isEmpty()) {
            t = t.withModifiers(ListUtils.map((List)t.getModifiers(), (index, m) -> (J.Modifier)this.visitAndCast((Tree)m, newTypeParam.getModifiers().get((int)index))));
        }
        if ((t = t.withName((Expression)this.visitAndCast((Tree)t.getName(), newTypeParam.getName()))).getName() instanceof NameTree) {
            t = t.withName((Expression)this.visitTypeName((NameTree)t.getName(), (Object)((NameTree)newTypeParam.getName())));
        }
        if (t.getPadding().getBounds() != null) {
            t = t.getPadding().withBounds(this.visitContainer(t.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, (Object)newTypeParam.getPadding().getBounds()));
        }
        return t.getPadding().withBounds(this.visitTypeNames(t.getPadding().getBounds(), newTypeParam.getPadding().getBounds()));
    }

    public J visitTypeParameters(J.TypeParameters typeParameters, @Nullable Object ctx) {
        if (typeParameters == ctx || !(ctx instanceof J.TypeParameters)) {
            return typeParameters;
        }
        J.TypeParameters newTypeParameters = (J.TypeParameters)ctx;
        J.TypeParameters t = typeParameters;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_PARAMETERS_PREFIX, (Object)newTypeParameters.getPrefix()));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTypeParameters.getMarkers()));
        t = t.withAnnotations(ListUtils.map((List)t.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newTypeParameters.getAnnotations().get((int)index))));
        return t.getPadding().withTypeParameters(ListUtils.map((List)t.getPadding().getTypeParameters(), (index, tp) -> this.visitRightPadded((JRightPadded)tp, JRightPadded.Location.TYPE_PARAMETER, newTypeParameters.getPadding().getTypeParameters().get((int)index))));
    }

    public J visitUnary(J.Unary unary, @Nullable Object ctx) {
        if (unary == ctx || !(ctx instanceof J.Unary)) {
            return unary;
        }
        J.Unary newUnary = (J.Unary)ctx;
        J.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNARY_PREFIX, (Object)newUnary.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(u = u.withMarkers(this.visitMarkers(u.getMarkers(), newUnary.getMarkers()))), newUnary);
        if (!(temp instanceof J.Unary)) {
            return temp;
        }
        u = (J.Unary)temp;
        Expression temp2 = (Expression)this.visitExpression((Expression)u, newUnary);
        if (!(temp2 instanceof J.Unary)) {
            return temp2;
        }
        u = (J.Unary)temp2;
        u = u.getPadding().withOperator(this.visitLeftPadded(u.getPadding().getOperator(), JLeftPadded.Location.UNARY_OPERATOR, (Object)newUnary.getPadding().getOperator()));
        u = u.withExpression((Expression)this.visitAndCast((Tree)u.getExpression(), newUnary.getExpression()));
        return u.withType(this.visitType(u.getType(), newUnary.getType()));
    }

    public J visitUnknown(J.Unknown unknown, @Nullable Object ctx) {
        if (unknown == ctx || !(ctx instanceof J.Unknown)) {
            return unknown;
        }
        J.Unknown newUnknown = (J.Unknown)ctx;
        J.Unknown u = unknown;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNKNOWN_PREFIX, (Object)newUnknown.getPrefix()));
        u = u.withMarkers(this.visitMarkers(u.getMarkers(), newUnknown.getMarkers()));
        return u.withSource((J.Unknown.Source)this.visitAndCast((Tree)u.getSource(), newUnknown.getSource()));
    }

    public J visitUnknownSource(J.Unknown.Source source, @Nullable Object ctx) {
        if (source == ctx || !(ctx instanceof J.Unknown.Source)) {
            return source;
        }
        J.Unknown.Source newSource = (J.Unknown.Source)ctx;
        J.Unknown.Source s = source;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.UNKNOWN_SOURCE_PREFIX, (Object)newSource.getPrefix()));
        return s.withMarkers(this.visitMarkers(s.getMarkers(), newSource.getMarkers()));
    }

    public J visitVariable(J.VariableDeclarations.NamedVariable variable, @Nullable Object ctx) {
        if (variable == ctx || !(ctx instanceof J.VariableDeclarations.NamedVariable)) {
            return variable;
        }
        J.VariableDeclarations.NamedVariable newVariable = (J.VariableDeclarations.NamedVariable)ctx;
        J.VariableDeclarations.NamedVariable v = variable;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), Space.Location.VARIABLE_PREFIX, (Object)newVariable.getPrefix()));
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), newVariable.getMarkers()));
        v = v.withDeclarator((VariableDeclarator)this.visitAndCast((Tree)v.getDeclarator(), newVariable.getDeclarator()));
        if ((v = v.withDimensionsAfterName(ListUtils.map((List)v.getDimensionsAfterName(), (index, dim) -> dim.withBefore(this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, (Object)((JLeftPadded)newVariable.getDimensionsAfterName().get((int)index)).getBefore())).withElement((Object)this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, ((JLeftPadded)newVariable.getDimensionsAfterName().get((int)index)).getElement()))))).getPadding().getInitializer() != null) {
            v = v.getPadding().withInitializer(this.visitLeftPadded(v.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, (Object)newVariable.getPadding().getInitializer()));
        }
        return v.withVariableType((JavaType.Variable)this.visitType((JavaType)v.getVariableType(), newVariable.getVariableType()));
    }

    public J visitWhileLoop(J.WhileLoop whileLoop, @Nullable Object ctx) {
        if (whileLoop == ctx || !(ctx instanceof J.WhileLoop)) {
            return whileLoop;
        }
        J.WhileLoop newWhileLoop = (J.WhileLoop)ctx;
        J.WhileLoop w = whileLoop;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), Space.Location.WHILE_PREFIX, (Object)newWhileLoop.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(w = w.withMarkers(this.visitMarkers(w.getMarkers(), newWhileLoop.getMarkers()))), newWhileLoop);
        if (!(temp instanceof J.WhileLoop)) {
            return temp;
        }
        w = (J.WhileLoop)temp;
        w = w.withCondition((J.ControlParentheses)this.visitAndCast((Tree)w.getCondition(), newWhileLoop.getCondition()));
        return w.getPadding().withBody(this.visitRightPadded(w.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, (Object)newWhileLoop.getPadding().getBody()));
    }

    public J visitWildcard(J.Wildcard wildcard, @Nullable Object ctx) {
        if (wildcard == ctx || !(ctx instanceof J.Wildcard)) {
            return wildcard;
        }
        J.Wildcard newWildcard = (J.Wildcard)ctx;
        J.Wildcard w = wildcard;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), Space.Location.WILDCARD_PREFIX, (Object)newWildcard.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(w = w.withMarkers(this.visitMarkers(w.getMarkers(), newWildcard.getMarkers()))), newWildcard);
        if (!(temp instanceof J.Wildcard)) {
            return temp;
        }
        w = (J.Wildcard)temp;
        w = w.getPadding().withBound(this.visitLeftPadded(w.getPadding().getBound(), JLeftPadded.Location.WILDCARD_BOUND, (Object)newWildcard.getPadding().getBound()));
        if ((w = w.withBoundedType((NameTree)this.visitAndCast((Tree)w.getBoundedType(), newWildcard.getBoundedType()))).getBoundedType() != null) {
            w = w.withBoundedType(this.visitTypeName(w.getBoundedType(), (Object)newWildcard.getBoundedType()));
        }
        return w;
    }

    public J visitYield(J.Yield yield, @Nullable Object ctx) {
        if (yield == ctx || !(ctx instanceof J.Yield)) {
            return yield;
        }
        J.Yield newYield = (J.Yield)ctx;
        J.Yield y = yield;
        y = y.withPrefix(this.visitSpace(y.getPrefix(), Space.Location.YIELD_PREFIX, (Object)newYield.getPrefix()));
        Statement temp = (Statement)this.visitStatement((Statement)(y = y.withMarkers(this.visitMarkers(y.getMarkers(), newYield.getMarkers()))), newYield);
        if (!(temp instanceof J.Yield)) {
            return temp;
        }
        y = (J.Yield)temp;
        return y.withValue((Expression)this.visitAndCast((Tree)y.getValue(), newYield.getValue()));
    }

    public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, @Nullable Object ctx) {
        JRightPadded newRight = (JRightPadded)ctx;
        if (right == newRight) {
            return right;
        }
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)right.getElement()), newRight.getElement());
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), (Object)newRight.getAfter());
        Markers markers = this.visitMarkers(right.getMarkers(), newRight.getMarkers());
        return after == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JRightPadded<T>(t, after, markers);
    }

    public <T> @Nullable JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, JLeftPadded.Location loc, @Nullable Object ctx) {
        JLeftPadded newLeft = (JLeftPadded)ctx;
        if (left == newLeft) {
            return left;
        }
        if (left == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), (Object)newLeft.getBefore());
        Object t = left.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)left.getElement()), newLeft.getElement());
        }
        this.setCursor(this.getCursor().getParent());
        if (left.getElement() == t && before == left.getBefore()) {
            return left;
        }
        return t == null ? null : new JLeftPadded(before, t, left.getMarkers());
    }

    public <J2 extends J> @Nullable JContainer<J2> visitContainer(@Nullable JContainer<J2> container, JContainer.Location loc, @Nullable Object ctx) {
        JContainer newContainer = (JContainer)ctx;
        if (container == newContainer) {
            return container;
        }
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), (Object)newContainer.getBefore());
        List js = ListUtils.map((List)container.getPadding().getElements(), (index, t) -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), (Object)(newContainer == null ? null : newContainer.getPadding().getElements().get((int)index))));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build((Space)before, (List)js, (Markers)container.getMarkers());
    }

    public J visitErroneous(J.Erroneous erroneous, @Nullable Object ctx) {
        if (erroneous == ctx || !(ctx instanceof J.Erroneous)) {
            return erroneous;
        }
        J.Erroneous newErroneous = (J.Erroneous)ctx;
        J.Erroneous u = erroneous;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.ERRONEOUS, (Object)newErroneous.getPrefix()));
        return u.withMarkers(this.visitMarkers(u.getMarkers(), newErroneous.getMarkers()));
    }
}

