/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.StringJoiner;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.search.EffectiveMavenRepositoriesTable;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.tree.Xml;

public final class EffectiveMavenRepositories
extends Recipe {
    @Option(displayName="Use markers", description="Whether to add markers for each effective Maven repository to the POM. Default `false`.", required=false)
    @Nullable
    private final Boolean useMarkers;
    private final transient EffectiveMavenRepositoriesTable table = new EffectiveMavenRepositoriesTable(this);

    public String getDisplayName() {
        return "List effective Maven repositories";
    }

    public String getDescription() {
        return "Lists the Maven repositories that would be used for dependency resolution, in order of precedence. This includes Maven repositories defined in the Maven settings file (and those contributed by active profiles) as determined when the LST was produced.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                StringJoiner repositories = new StringJoiner("\n");
                for (MavenRepository repository : mrr.getPom().getRepositories()) {
                    repositories.add(repository.getUri());
                    EffectiveMavenRepositories.this.table.insertRow(ctx, new EffectiveMavenRepositoriesTable.Row(PathUtils.separatorsToUnix((String)document.getSourcePath().toString()), repository.getUri()));
                }
                for (MavenRepository repository : MavenExecutionContextView.view(ctx).getRepositories(mrr.getMavenSettings(), mrr.getActiveProfiles())) {
                    repositories.add(repository.getUri());
                    EffectiveMavenRepositories.this.table.insertRow(ctx, new EffectiveMavenRepositoriesTable.Row(PathUtils.separatorsToUnix((String)document.getSourcePath().toString()), repository.getUri()));
                }
                repositories.add(MavenRepository.MAVEN_CENTRAL.getUri());
                EffectiveMavenRepositories.this.table.insertRow(ctx, new EffectiveMavenRepositoriesTable.Row(PathUtils.separatorsToUnix((String)document.getSourcePath().toString()), MavenRepository.MAVEN_CENTRAL.getUri()));
                if (Boolean.TRUE.equals(EffectiveMavenRepositories.this.useMarkers)) {
                    return (Xml.Document)SearchResult.found((Tree)document, (String)repositories.toString());
                }
                return document;
            }
        };
    }

    public EffectiveMavenRepositories(@Nullable Boolean useMarkers) {
        this.useMarkers = useMarkers;
    }

    @Nullable
    public Boolean getUseMarkers() {
        return this.useMarkers;
    }

    public EffectiveMavenRepositoriesTable getTable() {
        return this.table;
    }

    @NonNull
    public String toString() {
        return "EffectiveMavenRepositories(useMarkers=" + this.getUseMarkers() + ", table=" + (Object)((Object)this.getTable()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EffectiveMavenRepositories)) {
            return false;
        }
        EffectiveMavenRepositories other = (EffectiveMavenRepositories)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$useMarkers = this.getUseMarkers();
        Boolean other$useMarkers = other.getUseMarkers();
        return !(this$useMarkers == null ? other$useMarkers != null : !((Object)this$useMarkers).equals(other$useMarkers));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EffectiveMavenRepositories;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useMarkers = this.getUseMarkers();
        result = result * 59 + ($useMarkers == null ? 43 : ((Object)$useMarkers).hashCode());
        return result;
    }
}

