/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.table;

import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.table.DependenciesInUse;

public class ManagedDependencyGraph
extends DataTable<Row> {
    public ManagedDependencyGraph(Recipe recipe) {
        super(recipe, Row.class, DependenciesInUse.class.getName(), "Managed dependency graph", "Relationships between POMs and their ancestors that define managed dependencies.");
    }

    public static final class Row {
        @Column(displayName="From dependency", description="What depends on the 'to' dependency.")
        private final String from;
        @Column(displayName="From dependency", description="A dependency.")
        private final String to;

        @Generated
        public Row(String from, String to) {
            this.from = from;
            this.to = to;
        }

        @Generated
        public String getFrom() {
            return this.from;
        }

        @Generated
        public String getTo() {
            return this.to;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$from = this.getFrom();
            String other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            String this$to = this.getTo();
            String other$to = other.getTo();
            return !(this$to == null ? other$to != null : !this$to.equals(other$to));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            String $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ManagedDependencyGraph.Row(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }
    }

    public static enum Relationship {
        Parent,
        ManagedDependency;

    }
}

