/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.internal.storage.reftable;

import org.openrewrite.jgit.lib.Config;
import org.openrewrite.jgit.lib.Repository;

public class ReftableConfig {
    private int refBlockSize = 4096;
    private int logBlockSize;
    private int restartInterval;
    private int maxIndexLevels;
    private boolean alignBlocks = true;
    private boolean indexObjects = true;

    public ReftableConfig() {
    }

    public ReftableConfig(Repository db) {
        this.fromConfig(db.getConfig());
    }

    public ReftableConfig(Config cfg) {
        this.fromConfig(cfg);
    }

    public ReftableConfig(ReftableConfig cfg) {
        this.refBlockSize = cfg.refBlockSize;
        this.logBlockSize = cfg.logBlockSize;
        this.restartInterval = cfg.restartInterval;
        this.maxIndexLevels = cfg.maxIndexLevels;
        this.alignBlocks = cfg.alignBlocks;
        this.indexObjects = cfg.indexObjects;
    }

    public int getRefBlockSize() {
        return this.refBlockSize;
    }

    public void setRefBlockSize(int szBytes) {
        if (szBytes > 0xFFFFFF) {
            throw new IllegalArgumentException();
        }
        this.refBlockSize = Math.max(0, szBytes);
    }

    public int getLogBlockSize() {
        return this.logBlockSize;
    }

    public void setLogBlockSize(int szBytes) {
        if (szBytes > 0xFFFFFF) {
            throw new IllegalArgumentException();
        }
        this.logBlockSize = Math.max(0, szBytes);
    }

    public int getRestartInterval() {
        return this.restartInterval;
    }

    public void setRestartInterval(int interval) {
        this.restartInterval = Math.max(0, interval);
    }

    public int getMaxIndexLevels() {
        return this.maxIndexLevels;
    }

    public void setMaxIndexLevels(int levels) {
        this.maxIndexLevels = Math.max(0, levels);
    }

    public boolean isAlignBlocks() {
        return this.alignBlocks;
    }

    public void setAlignBlocks(boolean align) {
        this.alignBlocks = align;
    }

    public boolean isIndexObjects() {
        return this.indexObjects;
    }

    public void setIndexObjects(boolean index) {
        this.indexObjects = index;
    }

    public void fromConfig(Config rc) {
        this.refBlockSize = rc.getInt("reftable", "blockSize", this.refBlockSize);
        this.logBlockSize = rc.getInt("reftable", "logBlockSize", this.logBlockSize);
        this.restartInterval = rc.getInt("reftable", "restartInterval", this.restartInterval);
        this.maxIndexLevels = rc.getInt("reftable", "indexLevels", this.maxIndexLevels);
        this.alignBlocks = rc.getBoolean("reftable", "alignBlocks", this.alignBlocks);
        this.indexObjects = rc.getBoolean("reftable", "indexObjects", this.indexObjects);
    }
}

