/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.merge;

import java.io.IOException;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectInserter;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.merge.Merger;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevTree;
import org.openrewrite.jgit.treewalk.AbstractTreeIterator;
import org.openrewrite.jgit.treewalk.EmptyTreeIterator;

public abstract class ThreeWayMerger
extends Merger {
    private RevTree baseTree;
    private ObjectId baseCommitId;

    protected ThreeWayMerger(Repository local) {
        super(local);
    }

    protected ThreeWayMerger(Repository local, boolean inCore) {
        this(local);
    }

    protected ThreeWayMerger(ObjectInserter inserter) {
        super(inserter);
    }

    public void setBase(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.baseTree = id != null ? this.walk.parseTree(id) : null;
    }

    @Override
    public boolean merge(AnyObjectId ... tips) throws IOException {
        if (tips.length != 2) {
            return false;
        }
        return super.merge(tips);
    }

    @Override
    public ObjectId getBaseCommitId() {
        return this.baseCommitId;
    }

    protected AbstractTreeIterator mergeBase() throws IOException {
        RevCommit baseCommit;
        if (this.baseTree != null) {
            return this.openTree(this.baseTree);
        }
        RevCommit revCommit = baseCommit = this.baseCommitId != null ? this.walk.parseCommit(this.baseCommitId) : this.getBaseCommit(this.sourceCommits[0], this.sourceCommits[1]);
        if (baseCommit == null) {
            this.baseCommitId = null;
            return new EmptyTreeIterator();
        }
        this.baseCommitId = baseCommit.toObjectId();
        return this.openTree(baseCommit.getTree());
    }
}

