/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.obr.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.pax.scanner.ScannedBundle;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.scanner.ScannerException;
import org.ops4j.pax.scanner.common.ScannedFileBundle;
import org.ops4j.pax.scanner.common.ScannerConfiguration;
import org.ops4j.pax.scanner.common.ScannerConfigurationImpl;
import org.ops4j.pax.scanner.common.SystemPropertyUtils;
import org.ops4j.pax.scanner.obr.internal.FilterValidator;
import org.ops4j.util.property.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObrScanner
implements Scanner {
    private static final Log LOG = LogFactory.getLog(ObrScanner.class);
    private static final String COMMENT_SIGN = "#";
    private static final String PROPERTY_PREFIX = "-D";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(.*)=(.*)");
    private PropertyResolver m_propertyResolver;
    private final FilterValidator m_filterValidator;
    private File m_scriptFile;

    public ObrScanner(PropertyResolver propertyResolver, FilterValidator filterValidator) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        NullArgumentException.validateNotNull(filterValidator, "Filter syntax validator");
        this.m_propertyResolver = propertyResolver;
        this.m_filterValidator = filterValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScannedBundle> scan(ProvisionSpec provisionSpec) throws MalformedSpecificationException, ScannerException {
        NullArgumentException.validateNotNull(provisionSpec, "Provision spec");
        LOG.debug("Scanning [" + provisionSpec.getPath() + "]");
        ArrayList<ScannedBundle> scannedBundles = new ArrayList<ScannedBundle>();
        ScannerConfiguration config = this.createConfiguration();
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(URLUtils.prepareInputStream(provisionSpec.getPathAsUrl(), config.getCertificateCheck() == false)));
                Integer defaultStartLevel = this.getDefaultStartLevel(provisionSpec, config);
                Boolean defaultStart = this.getDefaultStart(provisionSpec, config);
                Boolean defaultUpdate = this.getDefaultUpdate(provisionSpec, config);
                scannedBundles.add((ScannedBundle)new ScannedFileBundle("mvn:org.apache.felix/org.apache.felix.bundlerepository", defaultStartLevel, defaultStart, defaultUpdate));
                scannedBundles.add((ScannedBundle)new ScannedFileBundle("mvn:org.ops4j.pax.scanner/pax-scanner-obr-script", defaultStartLevel, defaultStart, defaultUpdate));
                File scriptFile = this.createScript();
                System.setProperty("org.ops4j.pax.scanner.obr.script", scriptFile.toURI().toASCIIString());
                System.setProperty("obr.repository.url", this.m_propertyResolver.get("obr.repository.url"));
                bufferedWriter = new BufferedWriter(new FileWriter(scriptFile));
                while ((line = bufferedReader.readLine()) != null) {
                    if ("".equals(line.trim()) || line.trim().startsWith(COMMENT_SIGN)) continue;
                    if (line.trim().startsWith(PROPERTY_PREFIX)) {
                        Matcher matcher = PROPERTY_PATTERN.matcher(line.trim());
                        if (!matcher.matches() || matcher.groupCount() != 2) {
                            throw new ScannerException("Invalid property: " + line);
                        }
                        String value = matcher.group(2);
                        value = SystemPropertyUtils.resolvePlaceholders(value);
                        System.setProperty(matcher.group(1), value);
                        continue;
                    }
                    line = SystemPropertyUtils.resolvePlaceholders(line);
                    String obrFilter = this.createObrFilter(line);
                    bufferedWriter.append(obrFilter);
                    bufferedWriter.newLine();
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
        }
        catch (IOException e) {
            throw new ScannerException("Could not parse the provision file", (Throwable)e);
        }
        return scannedBundles;
    }

    private File createScript() throws IOException {
        if (this.m_scriptFile == null) {
            this.m_scriptFile = File.createTempFile("pax.scanner.obr.script", ".txt");
            LOG.trace("Created script file [" + this.m_scriptFile.getCanonicalPath() + "]");
        } else {
            LOG.trace("Using script file [" + this.m_scriptFile.getCanonicalPath() + "]");
        }
        return this.m_scriptFile;
    }

    private String createObrFilter(String path) throws MalformedURLException {
        if (path == null || path.trim().length() == 0) {
            throw new MalformedURLException("OBR spec cannot be null or empty");
        }
        String[] segments = path.split("/");
        if (segments.length > 2) {
            throw new MalformedURLException("OBR spec cannot contain more then one '/'");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(symbolicname=").append(segments[0]).append(")");
        if (!this.m_filterValidator.validate(builder.toString())) {
            throw new MalformedURLException("Invalid symbolic name value.");
        }
        if (segments.length > 1) {
            builder.insert(0, "(&").append("(version=").append(segments[1]).append("))");
            if (!this.m_filterValidator.validate(builder.toString())) {
                throw new MalformedURLException("Invalid version value.");
            }
        }
        return builder.toString();
    }

    private Integer getDefaultStartLevel(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Integer startLevel = provisionSpec.getStartLevel();
        if (startLevel == null) {
            startLevel = config.getStartLevel();
        }
        return startLevel;
    }

    private Boolean getDefaultStart(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean start = provisionSpec.shouldStart();
        if (start == null) {
            start = config.shouldStart();
        }
        return start;
    }

    private Boolean getDefaultUpdate(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean update = provisionSpec.shouldUpdate();
        if (update == null) {
            update = config.shouldUpdate();
        }
        return update;
    }

    public void setResolver(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.m_propertyResolver = propertyResolver;
    }

    ScannerConfiguration createConfiguration() {
        return new ScannerConfigurationImpl(this.m_propertyResolver, "org.ops4j.pax.scanner.obr");
    }
}

