/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.badge;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.badge.Badge;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class BadgeRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Badge badge = (Badge)component;
        this.encodeScript(context, badge);
    }

    protected void encodeScript(FacesContext context, Badge badge) throws IOException {
        String target = this.isValueBlank(badge.getFor()) ? badge.getParent().getClientId(context) : this.resolveTarget(context, badge);
        UIComponent targetComponent = SearchExpressionFacade.resolveComponent((FacesContext)context, (UIComponent)badge, (String)target);
        if (!targetComponent.isRendered()) {
            return;
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtBadge", (UIComponent)badge);
        wb.attr("target", target);
        wb.attr("color", badge.getColor());
        wb.attr("position", badge.getPosition());
        if (badge.getContent() != null) {
            wb.attr("content", badge.getContent());
        }
        wb.finish();
    }

    protected String resolveTarget(FacesContext context, Badge badge) {
        String target = SearchExpressionFacade.resolveClientIds((FacesContext)context, (UIComponent)badge, (String)badge.getFor());
        if (this.isValueBlank(target)) {
            throw new FacesException("Badge for=\"target\" resolved to null");
        }
        return target;
    }
}

