/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.calculator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.event.ButtonEvent;
import org.primefaces.extensions.event.CloseEvent;
import org.primefaces.extensions.event.OpenEvent;
import org.primefaces.util.LocaleUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="calculator/calculator.css"), @ResourceDependency(library="primefaces-extensions", name="calculator/calculator.js")})
public class Calculator
extends UIComponentBase
implements ClientBehaviorHolder,
Widget,
RTLAware {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.Calculator";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.CalculatorRenderer";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("open", "close", "button"));
    private Locale appropriateLocale;

    public Calculator() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return "open";
    }

    public void processDecodes(FacesContext fc) {
        if (this.isSelfRequest(fc)) {
            this.decode(fc);
        } else {
            super.processDecodes(fc);
        }
    }

    public void processValidators(FacesContext fc) {
        if (!this.isSelfRequest(fc)) {
            super.processValidators(fc);
        }
    }

    public void processUpdates(FacesContext fc) {
        if (!this.isSelfRequest(fc)) {
            super.processUpdates(fc);
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (this.isSelfRequest(fc) && event instanceof AjaxBehaviorEvent) {
            Map params = fc.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(fc);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("open".equals(eventName)) {
                OpenEvent openEvent = new OpenEvent((UIComponent)this, behaviorEvent.getBehavior());
                openEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)openEvent);
                return;
            }
            if ("close".equals(eventName)) {
                CloseEvent closeEvent = new CloseEvent((UIComponent)this, behaviorEvent.getBehavior());
                closeEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)closeEvent);
                return;
            }
            if ("button".equals(eventName)) {
                String name = (String)params.get(clientId + "_button");
                BigDecimal value = new BigDecimal((String)params.get(clientId + "_value"));
                ButtonEvent buttonEvent = new ButtonEvent((UIComponent)this, behaviorEvent.getBehavior(), name, value);
                buttonEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)buttonEvent);
                return;
            }
        }
        super.queueEvent(event);
    }

    public Locale calculateLocale() {
        if (this.appropriateLocale == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            this.appropriateLocale = LocaleUtils.resolveLocale((FacesContext)fc, (Object)this.getLocale(), (String)this.getClientId(fc));
        }
        return this.appropriateLocale;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getFor() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.forValue), null);
    }

    public void setFor(String _for) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.forValue), (Object)_for);
    }

    public String getShowOn() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showOn), (Object)"focus");
    }

    public void setShowOn(String _showOn) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showOn), (Object)_showOn);
    }

    public String getLayout() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.layout), (Object)"standard");
    }

    public void setLayout(String _layout) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.layout), (Object)_layout);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
    }

    public int getPrecision() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.precision), (Object)10);
    }

    public void setPrecision(int _precision) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.precision), (Object)_precision);
    }

    public void setDir(String _dir) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dir), (Object)_dir);
    }

    public String getDir() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dir), (Object)"ltr");
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public String getOnopen() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onopen), null);
    }

    public void setOnopen(String _onOpen) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onopen), (Object)_onOpen);
    }

    public String getOnclose() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onclose), null);
    }

    public void setOnclose(String _onClose) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onclose), (Object)_onClose);
    }

    public String getOnbutton() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onbutton), null);
    }

    public void setOnbutton(String _onButton) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onbutton), (Object)_onButton);
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    protected static enum PropertyKeys {
        widgetVar,
        showOn,
        layout,
        locale,
        precision,
        dir,
        styleClass,
        onopen,
        onbutton,
        onclose,
        forValue("for");

        private final String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
            this.toString = null;
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

